if SERVER then
	AddCSLuaFile()
end

SWEP.PrintName = "Funkgerät"
SWEP.Purpose = "Hiermit kann über Distanz mit allen Mitgliedern des ausgewählten Channels kommuniziert werden.\nDafür muss das Funkgerät in der Hand gehalten werden."
SWEP.Instructions = "Linksklick zum stummen/entstummen.\nRechtsklick zum Sender wechseln.\nNachladen zum Anschalten des Geräts."
SWEP.Slot = 1
SWEP.SlotPos = 10
SWEP.DrawAmmo = false
SWEP.DrawCrosshair = false
SWEP.Spawnable = true
SWEP.Base = "weapon_base"
SWEP.UseHands = true
SWEP.ViewModel = Model("models/radio/c_radio.mdl")
SWEP.WorldModel = Model("models/radio/w_radio.mdl")
SWEP.Primary.Clipsize = -1
SWEP.Primary.DefaultClip = -1
SWEP.Primary.Automatic = false
SWEP.Primary.Ammo = "none"
SWEP.Secondary.Clipsize = -1
SWEP.Secondary.DefaultClip = -1
SWEP.Secondary.Automatic = false
SWEP.Secondary.Ammo = "none"

function SWEP:SetupDataTables()
	self:NetworkVar("Bool", 0, "DeviceStatus")
	self:NetworkVar("Bool", 1, "DeviceMuted")
	self:NetworkVar("Float", 0, "NextDeviceMute")
	self:NetworkVar("Float", 1, "NextDeviceSwitch")
	self:NetworkVar("Float", 2, "NextDeviceActivate")
end

function SWEP:Initialize()
	self:SetHoldType("slam")
	self:SetDeploySpeed(2)
	self:SetDeviceStatus(false)
	self:SetDeviceMuted(false)
	timer.Simple(0, function()
		if !IsValid(self) or !IsValid(self.Owner) then return end
		local ply = self.Owner
		ply:SetNWEntity("HasRadio", self)
		if SERVER then
			ply:setDarkRPVar("channelID", nil)
			ply:setDarkRPVar("channelName", nil)
		end
	end)
end

function SWEP:Deploy()
	if SERVER then
		local ply = self.Owner
		if IsValid(ply) then
			PoliceRadio.PlayerTable[ply] = 1
		end
	end
	return true
end

function SWEP:Holster()
	if SERVER then
		local ply = self.Owner
		if IsValid(ply) then
			PoliceRadio.PlayerTable[ply] = nil
		end
	end
	return true
end

function SWEP:OnRemove()
	local ply = self.Owner
	if IsValid(ply) then
		if SERVER then
			PoliceRadio.PlayerTable[ply] = nil
		end
		if !ply:HasWeapon("radio_device") then
			ply:SetNWEntity("HasRadio", NULL)
			if SERVER then
				ply:setDarkRPVar("channelID", nil)
				ply:setDarkRPVar("channelName", nil)
			end
		end
	end
	if CLIENT then
		if IsValid(self.DeviceScreen) then
			self.DeviceScreen:Remove()
		end
		if IsValid(self.TextScreen) then
			self.TextScreen:Remove()
		end
		if IsValid(self.BatteryIcon) then
			self.BatteryIcon:Remove()
		end
		if IsValid(self.SignalIcon) then
			self.SignalIcon:Remove()
		end
	end
	return true
end

function SWEP:PrimaryAttack()
	if self:GetDeviceStatus() then
		if self:GetNextDeviceMute() < CurTime() then
			if CLIENT then
				self:EmitSound("buttons/lightswitch2.wav")
			end
			if IsFirstTimePredicted() then
				self:SetDeviceMuted(!self:GetDeviceMuted())
			end
			self:SetNextDeviceMute(CurTime() + 0.5)
		end	
	end
end

function SWEP:SecondaryAttack()
	if self:GetDeviceStatus() then
		if self:GetNextDeviceSwitch() < CurTime() then
			if CLIENT then
				self:EmitSound("buttons/lightswitch2.wav")
			end
			if SERVER then
				PoliceRadio.NextChannel(self:GetOwner())
			end
			self:SetNextDeviceSwitch(CurTime())
		end
	end
end

function SWEP:Reload()
	if self:GetOwner():KeyPressed(IN_RELOAD) and self:GetNextDeviceActivate() < CurTime() then
		if self:GetDeviceStatus() then
			if IsFirstTimePredicted() then
				self:SetDeviceStatus(false)
				self:SetDeviceMuted(false)
			end
			if CLIENT then
				self:EmitSound("npc/metropolice/vo/off2.wav")
			end
		else
			if IsFirstTimePredicted() then
				self:SetDeviceStatus(true)
				self:SetDeviceMuted(false)
			end
			if CLIENT then
				self:EmitSound("npc/metropolice/vo/on2.wav")
			end
		end
		self:SetNextDeviceActivate(CurTime() + 0.5)
	end	
end

if SERVER then return end

surface.CreateFont("PoliceRadio_DeviceFont", {font = "New X Digital tfb Light", size = 22, weight = 400, antialias = true})

function SWEP:CreateIcons()
	self.DeviceScreen = vgui.Create("DFrame")
	self.DeviceScreen:SetSize(156, 64)
	self.DeviceScreen:SetDraggable(false)
	self.DeviceScreen:ShowCloseButton(false)
	self.DeviceScreen:SetTitle("")
	self.DeviceScreen:SetPos(0, 0)
	self.DeviceScreen:SetPaintedManually(true)
	self.DeviceScreen.Paint = function(slf, w, h)
		if !IsValid(self) then return end
		if self:GetDeviceMuted() then
			draw.RoundedBox(0, 0, 0, w, h, Color(200, 0, 25))
		elseif self:GetDeviceStatus() then
			draw.RoundedBox(0, 0, 0, w, h, Color(0, 200, 25))
		else
			draw.RoundedBox(0, 0, 0, w, h, Color(20, 20, 20))
		end
	end
	self.TextScreen = vgui.Create("DLabel", self.DeviceScreen)
	self.TextScreen:SetText("")
	self.TextScreen:SetFont("PoliceRadio_DeviceFont")
	self.TextScreen:SizeToContents()
	self.TextScreen:SetPos(25, 20)
	self.TextScreen:SetWidth(110)
	self.TextScreen:SetWrap(true)
	self.TextScreen:SetTextColor(Color(255, 255, 255, 255))
	self.BatteryIcon = vgui.Create("DImage", self.DeviceScreen)
	self.BatteryIcon:SetPos(5, 5)
	self.BatteryIcon:SetImage("police_radio/battery.png")
	self.BatteryIcon:SizeToContents()
	self.SignalIcon = vgui.Create("DImage", self.DeviceScreen)
	self.SignalIcon:SetPos(135, 5)
	self.SignalIcon:SetImage("police_radio/signal.png")
	self.SignalIcon:SizeToContents()
end

function SWEP:PostDrawViewModel(vm)
	if !IsValid(self.TextScreen) or !IsValid(self.DeviceScreen) then self:CreateIcons() return end
	local bone_index = vm:LookupBone("ValveBiped.Bip01_R_Hand")
	if !bone_index then return end
	local matrix = vm:GetBoneMatrix(bone_index)
	if matrix then
		local bonepos, boneang = matrix:GetTranslation(), matrix:GetAngles()
		
		local textpos = bonepos + boneang:Forward() * 5.23 + boneang:Right() * 3.6 + boneang:Up() * -4.26
		local textang = boneang
		textang:RotateAroundAxis(textang:Right(), 185)
		textang:RotateAroundAxis(textang:Up(), -3.8)
		textang:RotateAroundAxis(textang:Forward(), 95)
		if self:GetDeviceStatus() then
			local ply = LocalPlayer()
			if ply:getDarkRPVar("channelName") then
				self.TextScreen:SetText(ply:getDarkRPVar("channelName"))
			else
				self.TextScreen:SetText("Kein Sender ausgewählt.")
			end
			self.BatteryIcon:SetVisible(true)
			self.SignalIcon:SetVisible(true)
		else
			self.TextScreen:SetText("")
			self.BatteryIcon:SetVisible(false)
			self.SignalIcon:SetVisible(false)
		end
		cam.Start3D2D(textpos, textang, 0.015)
			self.DeviceScreen:PaintManual()
		cam.End3D2D()
	end
end