TOOL.Category = "MG PropSave"
TOOL.Name = "Props speichern"
TOOL.AddToMenu = false

TOOL.Information = {
	{name = "left"},
	{name = "right"},
	{name = "reload"}
}

if CLIENT then
	language.Add("tool.propsave.name", "Props speichern")
	language.Add("tool.propsave.left", "Gegenstand speichern")
	language.Add("tool.propsave.right", "Gegenstand entspeichern")
	language.Add("tool.propsave.reload", "Prop entspeichern und entfernen")
	language.Add("tool.propsave.desc", "Mit diesem Werkzeug lassen sich Props auf der Map permanent speichern. Nur für die Administrative benutzbar.")
	language.Add("tool.propsave.help", "mg_props_help in die Konsole für eine Überblick aller Befehle.")
end

function TOOL:LeftClick(tr)
	local ret = MG_PropSave.Save(self:GetOwner(), tr)
	return ret
end

function TOOL:RightClick(tr)
	local ret = MG_PropSave.UnSave(self:GetOwner(), tr)
	return ret
end

function TOOL:Reload(tr)
	local ply = self:GetOwner()
	local ret = MG_PropSave.UnSave(ply, ply:GetEyeTrace(), true)
	return ret
end

if CLIENT then
	function TOOL.BuildCPanel(CPanel)
		CPanel:AddControl("Header", {Description = "#tool.propsave.desc"})
		CPanel:AddControl("Header", {Description = "#tool.propsave.help"})
	end
end