surface.CreateFont("raid.notify", {font = "BebasNeue", size = 30, weight = 400, antialias = true, strikeout = true, shadow = true})
surface.CreateFont("raid.info", {font = "BebasNeue", size = 20, weight = 400, antialias = true, strikeout = true, shadow = true})

local stay
local text
local smooth
local color
net.Receive("raid.notify", function()
	stay = CurTime() + 10
	text = net.ReadString()
	smooth = 0
	color = net.ReadColor()
	print(text)
end)

raid.target_id = NULL
raid.time = 0

raid.active = false
raid.failed = false

net.Receive("raid.init", function()
	raid.target_id = net.ReadString()
	raid.time = net.ReadFloat()
	raid.active = net.ReadBool()
	raid.failed = net.ReadBool()
end)

net.Receive("raid.update", function()
	raid.active = net.ReadBool()
	raid.failed = net.ReadBool()
end)

local local_ply
local function DrawDoorInfo()
	if !raid.config.UseKey then return end
	local_ply = local_ply or LocalPlayer()
	if local_ply:isArrested() then return end
	local ent = local_ply:GetEyeTrace().Entity
	if !IsValid(ent) or ent:IsVehicle() then return end
	if ent:GetPos():DistToSqr(local_ply:GetPos()) < 40000 and raid.IsRaidableEntity(ent) and raid.config.Leaders[local_ply:Team()] then
		local pos = {x = ScrW() / 2, y = ScrH() / 2}
		local text = "Drücke "..raid.config.RaidKeyText..", um einen Raid zu starten!"
		if raid.active then
			text = "Du befindest dich in einem Raid!"
		end
		draw.DrawText(text, "Roboto20", pos.x + 1, pos.y - 148, Color(0, 0, 0, 200), 1)
		draw.DrawText(text, "Roboto20", pos.x, pos.y - 149, Color(255, 255, 255, 200), 1)
	end
end
hook.Add("HUDPaint", "raid.doorinfo", DrawDoorInfo)

local function DrawRaidText(x, y, w, h, bgcolor, bcolor, color, font, text)
	surface.SetDrawColor(bgcolor)
	surface.DrawRect(x, y, w, h)
	surface.SetDrawColor(bcolor)
	surface.DrawRect(x, y, 0, h)
	surface.SetFont(font)
	local tw, th = surface.GetTextSize(text)
	surface.SetTextColor(color)
	surface.SetTextPos(x + w / 2 - tw / 2, y + h / 2 - th / 2)
	surface.DrawText(text, 10, 10)
end

local nextcheck = 0
raid.nearraid = false
raid.distance = 0
function raid.CheckPositions()
	if nextcheck < CurTime() then
		nextcheck = CurTime() + raid.config.ClientCheckDelay
		raid.nearraid, raid.distance = raid.CheckPlayerPositions({LocalPlayer():GetPos()}, raid.target_id, true)
	end
end

local raidnotifications = CreateClientConVar("cl_raidnotifications", 1, FCVAR_ARCHIVE)
local raidinfo = CreateClientConVar("cl_raidinfo", 1, FCVAR_ARCHIVE)

local DistToSqr = raid.config.WarnDistance * raid.config.WarnDistance
local function DrawRaidInfo()
	local curtime = CurTime()
	if (stay or 0) > curtime and raidnotifications:GetBool() then
		if stay - curtime < 3 then
			smooth = smooth - 1.65
		end
		local alpha = 255
		alpha = alpha + smooth + (math.sin(smooth * 2) / 2) - math.cos(RealFrameTime() * 2)
		if alpha < 1 then
			alpha = 0
		end
		surface.SetFont("raid.notify")
		local w = 320
		local x, y = surface.GetTextSize(text)
		w = x + 20
		if w < 320 then
			w = 320
		end
		DrawRaidText(ScrW() / 2 - w / 2, 124, w, 40, Color(40, 40, 40, alpha), Color(37, 74, 107, alpha), Color(color.r, color.g, color.b, alpha), "raid.notify", text)
	end
	if !raidinfo:GetBool() then return end
	local_ply = local_ply or LocalPlayer()
	if local_ply:isArrested() then return end
	local veh = local_ply:GetVehicle()
	if IsValid(veh) then
		local class = veh:GetClass()
		if class == "prop_vehicle_jeep" or class == "prop_vehicle_jeep_old" or class == "prop_vehicle_airboat" then return end
	end
	if raid.active and !raid.failed then
		raid.CheckPositions()
		local t = "Du nimmst an einem Raid teil!"
		local c = Color(150, 200, 150, 150)
		if raid.nearraid and raid.config.WarnPlayers and raid.distance > DistToSqr then
			t = "Du bist nahe der Raidgrenze!"
			c = Color(255, 98, 0, 150)
		elseif !raid.nearraid then
			t = "Du bist nicht in der Nähe des Raids!"
			c = Color(250, 10, 18, 150)
		end
		local scrw = ScrW()
		local scrh = r_drawing and ScrH() + 180 or ScrH()
		draw.SimpleTextOutlined(t, "raid.info", scrw - 15, scrh / 2, c, TEXT_ALIGN_RIGHT, TEXT_ALIGN_TOP, 1, Color(0, 0, 0, 150))
		if raid.config.StopRaidTimer and raid.config.StopRaidTimer != 0 then
			local t2 = "Zeit verbleibend: "..string.ToMinutesSeconds(math.max(0, raid.time - curtime)).." min."
			draw.SimpleTextOutlined(t2, "raid.info", scrw - 15, scrh / 2 + 20, Color(255, 255, 50, 150), TEXT_ALIGN_RIGHT, TEXT_ALIGN_TOP, 1, Color(0, 0, 0, 150))
		end
	elseif raid.time > curtime then
		local scrw = ScrW()
		local scrh = r_drawing and ScrH() + 180 or ScrH()
		local t = "Raid-Cooldown: "..string.ToMinutesSeconds(math.max(0, raid.time - curtime)).." min."
		draw.SimpleTextOutlined(t, "raid.info", scrw - 15, scrh / 2 + 20, Color(255, 98, 0, 150), TEXT_ALIGN_RIGHT, TEXT_ALIGN_TOP, 1, Color(0, 0, 0, 150))
	end
end
hook.Add("HUDPaint", "raid.raidinfo", DrawRaidInfo)