timer.Simple(0, function()
	DarkRP.declareChatCommand({
		command = "startraid",
		description = "Starts a raid.",
		delay = 1.5
	})

	DarkRP.declareChatCommand({
		command = "stopraid",
		description = "Stops a raid.",
		delay = 1.5
	})
end)

function raid.IsRaidableEntity(ent)
	local can_raid = hook.Run("canRaidEntity", ent)
	if isbool(can_raid) then return can_raid end
	return ((ent:isDoor() or raid.config.RaidVehicles and ent:IsVehicle()) and (ent:isKeysOwned() or raid.config.DoorGroups[ent:getDoorData().groupOwn])) or (raid.config.SupportFadingDoors and ent:GetNW2Bool("isFadingDoor"))
end

local DistToSqr = raid.config.Radius * raid.config.Radius
function raid.CheckPlayerPositions(positions, id, dist) -- Ugly ents.GetAll() function for checking the distance between raiding players and entities.
	dist = dist and math.huge
	local near = false
	for _,ent in ipairs(ents.GetAll()) do
		if ((ent:isDoor() or raid.config.RaidVehicles and ent:IsVehicle()) and (IsValid(ent:getDoorOwner()) and ent:getDoorOwner():SteamID() == id or ent:getDoorData().groupOwn == id)) or (IsValid(ent:CPPIGetOwner()) and ent:CPPIGetOwner():SteamID() == id) then
			for _, pos in ipairs(positions) do	
				local pos2 = ent:GetPos()
				if raid.config.IgnoreZ then
					pos.z = 0
					pos2.z = 0
				end
				local cache = pos:DistToSqr(pos2)
				if dist and cache < dist then
					dist = cache
				end
				local check = cache <= DistToSqr
				if check and !near then
					near = true
					if !dist then return true end
				end
			end
		end
	end
	return near, dist
end