REWARDS = REWARDS or {}

surface.CreateFont("REWARDS_FONT", {font = "BebasNeue", size= 24, weight = 400, antialias = true})

REWARDS.DrawHeight = 35
REWARDS.ControlHeight = 27
REWARDS.CurrentAlpha = 0
REWARDS.DisplayType = 1
REWARDS.MessageBoxPadding = 14

include("sh_rewards_config.lua")
include("sgrpanels/cl_menubutton.lua")

function REWARDS.OpenRewards(settings)
	REWARDS.JoinCheckWidth = 0
	REWARDS.DisplayType = 1
	if !IsValid(RewardsMainWindow) then
		REWARDS.CurrentAlpha = 0
		RewardsMainWindow = vgui.Create("DFrame")
		RewardsMainWindow:SetSize(ScrW(), REWARDS.DrawHeight)
		RewardsMainWindow:SetPos(0,0)
		RewardsMainWindow:SetDraggable(false)
		RewardsMainWindow:ShowCloseButton(false)
		RewardsMainWindow:SetTitle("")
		RewardsMainWindow.Paint = REWARDS.PaintMainWindow
		local MenuButtonList = vgui.Create("DPanelList", RewardsMainWindow)
		MenuButtonList:SetPadding(0)
		MenuButtonList:SetSpacing(5)
		MenuButtonList:SetAutoSize(true)
		MenuButtonList:SetNoSizing(false)
		MenuButtonList:EnableHorizontal(true)
		MenuButtonList:EnableVerticalScrollbar(false)
		MenuButtonList.Paint = function() end
		MenuButtonList.Think = function()
			if REWARDS.DisplayType == 3 then
				MenuButtonList:Remove()
			end
		end
		local JoinButton = vgui.Create("rewards_button")
		JoinButton:SetText(REWARDS.Settings.JoinButtonText)
		JoinButton.DoClick = function() 
			RunConsoleCommand("rewards_joingroup")
			REWARDS.DisplayType = 2
			gui.OpenURL(REWARDS.Settings.SteamGroupPage)
			gui.EnableScreenClicker(false)
		end
		MenuButtonList:AddItem(JoinButton)
		local DontJoinButton = vgui.Create("rewards_button")
		DontJoinButton:SetText(REWARDS.Settings.DontJoinButtonText)
		DontJoinButton.DoClick = function()
			REWARDS.CloseRewards()
			gui.EnableScreenClicker(false)
		end
		if settings.autoclosetime then
			REWARDS.AutoCloseTime = CurTime() + settings.autoclosetime
		end
		DontJoinButton.Think = function()
			if (REWARDS.DisplayType > 1) then
				DontJoinButton:SetText(REWARDS.Settings.DontJoinButtonText)
			elseif REWARDS.AutoCloseTime then
				local time = math.Clamp(REWARDS.AutoCloseTime - CurTime(), 0, settings.autoclosetime)
				local timetext = string.FormattedTime(time, "%02i:%02i")
				DontJoinButton:SetText(REWARDS.Settings.DontJoinButtonText.." (Schließt in "..timetext..")")				
				if time <= 0 then
					REWARDS.CloseRewards()
				end
			end
			local width = 0
			for _,v in ipairs(MenuButtonList:GetItems()) do
				width = width + v.CurrentWidth + 5
			end
			MenuButtonList:SetSize(width , 27)
			MenuButtonList:SetPos(ScrW() - (5 + MenuButtonList:GetWide()), 4)
		end
		MenuButtonList:AddItem(DontJoinButton)
		local width = 0
		for _,v in ipairs(MenuButtonList:GetItems()) do
			width = width + v.CurrentWidth + 5
		end
		MenuButtonList:SetSize(width , 27)
		MenuButtonList:SetPos(ScrW() - (5 + MenuButtonList:GetWide()), 4)
	else
		REWARDS.CloseRewards()
	end
end
concommand.Add("rewards_steamgroup", REWARDS.OpenRewards)

function REWARDS.PaintMainWindow()
	REWARDS.CurrentAlpha = math.Approach(REWARDS.CurrentAlpha, 225, FrameTime() * 200)
	surface.SetDrawColor(REWARDS.ColorWithCurrentAlpha(REWARDS.Theme.WindowColor))
	surface.DrawRect(0, 0, ScrW(), REWARDS.DrawHeight)
	surface.SetMaterial(REWARDS.Theme.Logo)
	surface.SetDrawColor(REWARDS.Theme.LogoColor)
	surface.DrawTexturedRect(5, 2, 64, 32)
	local cin = (math.sin(CurTime()) + 1) / 2
	if REWARDS.DisplayType == 1 then
		surface.SetDrawColor(REWARDS.ColorWithCurrentAlpha(REWARDS.Theme.MessageBoxBackColor))
		surface.DrawRect(107, 4, REWARDS.FindMessageBoxWidth(REWARDS.Settings.RewardsMessage), 27)
		draw.DrawText(REWARDS.Settings.RewardsMessage, REWARDS.Theme.Font, 114, 7, color_white, 0)
	elseif REWARDS.DisplayType == 2 then
		local width = REWARDS.FindMessageBoxWidth(REWARDS.Settings.RewardsMessage)
		surface.SetDrawColor(REWARDS.ColorWithCurrentAlpha(REWARDS.Theme.MessageBoxJoinCheckBackColor))
		surface.DrawRect(107, 4, width, 27)
		REWARDS.JoinCheckWidth = math.Approach(REWARDS.JoinCheckWidth, width, FrameTime() * ((width / REWARDS.Settings.JoinCheckDelay)))
		surface.SetDrawColor(REWARDS.ColorWithCurrentAlpha(REWARDS.Theme.MessageBoxJoinBarColor))
		surface.DrawRect(107, 4, REWARDS.JoinCheckWidth, 27)
		draw.DrawText(REWARDS.Settings.RewardsJoinCheckMessage, REWARDS.Theme.Font, 114, 7, color_white, 0)
	elseif REWARDS.DisplayType == 3 then
		if REWARDS.Theme.SuccessColorEffect then
			surface.SetDrawColor(cin * 255,255 - (cin * 255), 255, REWARDS.CurrentAlpha)
		else
			surface.SetDrawColor(REWARDS.ColorWithCurrentAlpha(REWARDS.Theme.MessageBoxSuccessBackColor))
		end
		surface.DrawRect(107, 4, REWARDS.FindMessageBoxWidth(REWARDS.Settings.RewardsSuccessMessage), 27)
		draw.DrawText(REWARDS.Settings.RewardsSuccessMessage, REWARDS.Theme.Font, 114, 7, color_white, 0)
	else
		surface.SetDrawColor(REWARDS.ColorWithCurrentAlpha(REWARDS.Theme.MessageBoxBackColor))
		surface.DrawRect(107, 4, REWARDS.FindMessageBoxWidth(REWARDS.Settings.RewardsMessage), 27)
		draw.DrawText(REWARDS.Settings.RewardsMessage, REWARDS.Theme.Font, 114, 7, color_white, 0)
	end
end

function REWARDS.ColorWithCurrentAlpha(c)
	local r, g, b = c.r,c.g,c.b
	return Color(r, g, b, REWARDS.CurrentAlpha)
end

function REWARDS.FindMessageBoxWidth(text)
	surface.SetFont(REWARDS.Theme.Font)
	local tw = surface.GetTextSize(text) 
	return tw + REWARDS.MessageBoxPadding
end

function REWARDS.Open(msg)
	local autoclosetime = msg:ReadLong()
	local settings = {}
	if autoclosetime and autoclosetime > 0 then
		settings.autoclosetime = tonumber(autoclosetime)
	else
		gui.EnableScreenClicker(true)
	end
	REWARDS.OpenRewards(settings)
end
usermessage.Hook("REWARDS_Open", REWARDS.Open)

function REWARDS.Success(msg)
	local settings = {}
	if !IsValid(RewardsMainWindow) then
		REWARDS.OpenRewards(settings)
	end
	REWARDS.DisplayType = 3
	if REWARDS.Settings.PlaySounds then
		surface.PlaySound(REWARDS.Settings.SuccessSound)
	end
	timer.Simple(REWARDS.Settings.SuccessCloseTime or 10, function()
		REWARDS.CloseRewards()
	end)
end
usermessage.Hook("REWARDS_Success", REWARDS.Success)

function REWARDS.CloseRewards()
	if IsValid(RewardsMainWindow) then
		RewardsMainWindow:Remove()
		REWARDS.AutoCloseTime = nil
	end
end
usermessage.Hook("REWARDS_Close", REWARDS.CloseRewards)

local binds = {
	["gm_showhelp"] = "F1",
	["gm_showteam"] = "F2",
	["gm_showspare1"] = "F3",
	["gm_showspare2"] = "F4"
}

local show_cursor
hook.Add("PlayerBindPress", "REWARDS_PlayerBindPress", function(ply, bind, down)
	if !down then return end
	local bnd = string.match(string.lower(bind), "gm_[a-z]+[12]?")
	if bnd and binds[bnd] and binds[bnd] == REWARDS.Settings.FKeyShowCursor then
		show_cursor = !show_cursor
		gui.EnableScreenClicker(show_cursor)
	end
end)

net.Receive("REWARDS_Notify", function()
	local bool = net.ReadBool()
	local str = net.ReadString()
	if bool then
		chat.AddText(Color(255, 200, 50), str.." ", REWARDS.Theme.NoticeTextColor, REWARDS.Settings.SteamRewardsChatMessage)
	else
		chat.AddText(Color(255, 200, 50), str.." ", REWARDS.Theme.NoticeTextColor, REWARDS.Settings.NametagRewardsChatMessage)
	end
end)