MG_Scoreboard = MG_Scoreboard or {}

MG_Scoreboard.Theme = "default"

MG_Scoreboard.Staff = {
	["owner"] = "Owner",
	["stellv. owner"] = "Stellv. Owner",
	["infrastrukturadmin"] = "Infrastrukturadmin",
	["community-manager"] = "Community-Manager",
	["teamleiter"] = "Teamleiter",
	["developer"] = "Developer",
	["superadmin_vip"] = "Superadmin (VIP)",
	["superadmin"] = "Superadmin",
	["admin_vip"] = "Admin (VIP)",
	["admin"] = "Admin",
	["moderator_vip"] = "Moderator (VIP)",
	["moderator"] = "Moderator",
	["vip++"] = "VIP++",
	["vip+"] = "VIP+",
	["vip"] = "VIP",
	["user"] = "User"
}

MG_Scoreboard.PlayerInfo = {
	{name = "Steam-Name", func = function(ply)
		return ply.SteamName and ply:SteamName() or ply:Name()
	end},
	{name = "Rang", func = function(ply)
		local group = ply:GetUserGroup()
		return MG_Scoreboard.Staff[group] or group
	end},
	{name = "Spielzeit", func = function(ply)
		return UTime_TimeToString(ply:GetUTimeTotalTime())
	end, visible = function(ply)
		return UTime_TimeToString
	end},
	{name = "Level", func = function(ply)
		return ply.getLevel and ply:getLevel()
	end, visible = function(ply)
		return ply.getLevel
	end},
	{name = "Fahndungsgrund", func = function(ply)
		return ply.getDarkRPVar and ply:getDarkRPVar("wantedReason")
	end, visible = function(ply)
		return ply.getDarkRPVar and ply:getDarkRPVar("wanted")
	end},
	{name = "Geldstand", admin = true, func = function(ply)
		return ply.getDarkRPVar and DarkRP.formatMoney(ply:getDarkRPVar("money"))
	end},
	{name = "Status", admin = true, func = function(ply)
		return ply.getDarkRPVar and ply:getDarkRPVar("job") == "AFK" and "Abwesend" or ply:Alive() and "Am Leben ("..math.max(0, ply:Health()).." / "..ply:Armor()..")" or "Verstorben"
	end},
	{name = "Props", admin = true, func = function(ply)
		return ply:GetCount("props")
	end}
}

MG_Scoreboard.Buttons = {
	{name = "SteamID kopieren", func = function(ply)
		local steamid = ply:SteamID()
		SetClipboardText(steamid)
		LocalPlayer():ChatPrint(string.format("SteamID von %s (%s) kopiert.", ply:Name(), steamid))
	end},
	{name = "Profil aufrufen", func = function(ply)
		ply:ShowProfile()
	end},
	{name = "Spielzeiten-Übersicht", func = function(ply)
		UTime.AskData(ply:SteamID())
	end, visible = function(ply)
		return UTime
	end},
	{name = "Private Nachricht", title = "PM: #name", reason = true, reasontext = "Nachricht:", hideicon = true, func = function(ply, reason, time)
		RunConsoleCommand("say", "/pm "..ply:UserID().." "..reason)
	end, visible = function(ply)
		return ply != LocalPlayer()
	end},
	{name = "Fahnden", cmd = "darkrp wanted", title = "Fahnden: #name", reason = true, reasontext = "Fahndungsgrund:", hideicon = true, visible = function(ply)
		return ply.getDarkRPVar and !ply:getDarkRPVar("wanted") and LocalPlayer():isCP()
	end},
	{name = "Fahndung einstellen", cmd = "darkrp unwanted", visible = function(ply)
		return ply.getDarkRPVar and ply:getDarkRPVar("wanted") and LocalPlayer():isCP()
	end},
	{name = "Durchsuchungsbefehl anfordern", cmd = "darkrp warrant", title = "Durchsuchen: #name", reason = true, reasontext = "Durchsuchungsgrund:", hideicon = true, visible = function(ply)
		local local_ply = LocalPlayer()
		return local_ply.isCP and local_ply:isCP()
	end},
	{name = "Spectate", admin = true, cmd = "ulx fspectate", ulx = true, newline = true},
	{name = "Spectate (ULX)", admin = true, cmd = "ulx spectate", ulx = true},
	{name = "Teleport", admin = true, cmd = "ulx teleport", ulx = true},
	{name = "Bring", admin = true, cmd = "ulx bring", ulx = true},
	{name = "Goto", admin = true, cmd = "ulx goto", ulx = true},
	{name = "Return", admin = true, cmd = "ulx return", ulx = true},
	{name = "Respawn", admin = true, cmd = "ulx respawn", ulx = true},
	{name = "Invisible", admin = true, cmd = "ulx invis", ulx = true},
	{name = "Visible", admin = true, cmd = "ulx vis", ulx = true},
	{name = "Freeze", admin = true, cmd = "ulx freeze", ulx = true, newline = true},
	{name = "Unfreeze", admin = true, cmd = "ulx unfreeze", ulx = true},
	{name = "Jail", admin = true, cmd = "ulx jail", ulx = true, title = "Jail: #name", time = true},
	{name = "Unjail", admin = true, cmd = "ulx unjail", ulx = true},
	{name = "Teleport & Jail", admin = true, func = function(ply)
		LocalPlayer():ConCommand("ulx jailtp $"..ply:UserID().." 300")
		LocalPlayer():ConCommand("ulx openrules $"..ply:UserID().." 300")
	end},
	{name = "Slay", admin = true, cmd = "ulx slay", ulx = true},
	{name = "Gag", admin = true, cmd = "ulx gag", ulx = true},
	{name = "Ungag", admin = true, cmd = "ulx ungag", ulx = true},
	{name = "Mute", admin = true, cmd = "ulx mute", ulx = true},
	{name = "Unmute", admin = true, cmd = "ulx unmute", ulx = true},
	{name = "Give Weapon", admin = true, func = MG_Scoreboard.ULX_GiveWeapon, newline = true},
	{name = "Set Job", admin = true, func = MG_Scoreboard.ULX_SetJob},
	{name = "Job Ban", admin = true, func = MG_Scoreboard.ULX_JobBan},
	{name = "Job Unban", admin = true, func = MG_Scoreboard.ULX_JobUnban},
	{name = "Kick", admin = true, cmd = "ulx kick", ulx = true, title = "Kick: #name", reason = true},
	{name = "Ban", admin = true, cmd = "say !xban", ulx = true},
	{name = "Freeze Ban", admin = true, cmd = "say !fban", ulx = true},
	{name = "IP Ban", sadmin = true, cmd = "ulx ipban", ulx = true, title = "IP Ban: #name", reason = true},
	{name = "Watchlist", admin = true, cmd = "ulx watchlist", ulx = true},
	{name = "Bannliste", admin = true, cmd = "ulx banlist", ulx = true}
}

MG_Scoreboard.RightClickMenu = {
	{name = "Spectate", admin = true, cmd = "ulx fspectate", icon = "icon16/eye.png"},
	{name = "Spectate (ULX)", admin = true, cmd = "ulx spectate", icon = "icon16/eye.png"},
	{name = "Teleport", admin = true, cmd = "ulx teleport", ulx = true, icon = "icon16/arrow_join.png", newline = true},
	{name = "Bring", admin = true, cmd = "ulx bring", ulx = true, icon = "icon16/arrow_in.png"},
	{name = "Goto", admin = true, cmd = "ulx goto", ulx = true, icon = "icon16/arrow_out.png"},
	{name = "Return", admin = true, cmd = "ulx return", ulx = true, icon = "icon16/arrow_undo.png"},
	{name = "Respawn", admin = true, cmd = "ulx respawn", ulx = true, icon = "icon16/heart.png", newline = true},
	{name = "Freeze", admin = true, cmd = "ulx freeze", ulx = true, icon = "icon16/hourglass.png", newline = true},
	{name = "Unfreeze", admin = true, cmd = "ulx unfreeze", ulx = true, icon = "icon16/clock.png"},
	{name = "Jail", admin = true, cmd = "ulx jail", ulx = true, icon = "icon16/link.png", newline = true},
	{name = "Unjail", admin = true, cmd = "ulx unjail", ulx = true, icon = "icon16/link_break.png"},
	{name = "Quick Kick", admin = true, cmd = "ulx kick", ulx = true, icon = "icon16/world.png", newline = true},
	{name = "Quick Ban", admin = true, cmd = "ulx ban", ulx = true, icon = "icon16/shield.png", newline = true},
	{name = "Verwarnungen öffnen", admin = true, func = function(ply) LocalPlayer():ConCommand("warn_menu "..ply:UserID()) end, icon = "icon16/chart_bar.png", newline = true},
	{name = "Watchlist öffnen", admin = true, cmd = "ulx watchlist", icon = "icon16/chart_bar.png"},
	{name = "Bannliste öffnen", admin = true, cmd = "ulx banlist", icon = "icon16/chart_bar.png"},
}