MG_Scoreboard = MG_Scoreboard or {}

MG_Scoreboard.Materials = {}
MG_Scoreboard.Materials["name_tag"] = Material("mg_scoreboard/name.png")
MG_Scoreboard.Materials["job_tag"] = Material("mg_scoreboard/job.png")
MG_Scoreboard.Materials["gun_tag"] = Material("mg_scoreboard/gun.png")
MG_Scoreboard.Materials["punish_tag"] = Material("mg_scoreboard/punish.png")
MG_Scoreboard.Materials["ping_tag"] = Material("mg_scoreboard/ping.png")

function MG_Scoreboard.ManageFonts(min, max, font)
	for x = min, max do
		surface.CreateFont("MG_Scoreboard_"..x, {font = font, size = x, weight = 500})
	end
end

MG_Scoreboard.ManageFonts(10, 40, "Roboto Cn")

local weplist = {}
timer.Simple(0.1, function()
	for _, v in ipairs(weapons.GetList()) do
		local cat = v.Category or "Other"
		if !cat or !v.Spawnable then continue end
		weplist[cat] = weplist[cat] or {}
		table.insert(weplist[cat], v)
	end

	for _, v in pairs(weplist) do
		table.sort(v, function(a, b) return a.ClassName > b.ClassName end)
	end
end)

function MG_Scoreboard.ULX_GiveWeapon(ply)
	local menu = DermaMenu()
	for k, v in SortedPairs(weplist) do
		local parent = menu:AddSubMenu(k)
		for _, v in ipairs(v) do
			parent:AddOption(v.PrintName or v.ClassName, function()
				if !IsValid(ply) then return end
				LocalPlayer():ConCommand("ulx give $"..ply:UserID().." \""..v.ClassName.."\"")
			end)
		end
	end
	menu:Open()
end

function MG_Scoreboard.ULX_SetJob(ply)
	local menu = DermaMenu()
	for k, v in SortedPairsByMemberValue(RPExtraTeams, "name") do
		menu:AddOption(v.name, function()
			if !IsValid(ply) then return end
			LocalPlayer():ConCommand("ulx setjob $"..ply:UserID().." \""..v.name.."\"")
		end)
	end
	menu:Open()
end

function MG_Scoreboard.ULX_JobBan(ply)
	local menu = DermaMenu()
	for k, v in SortedPairsByMemberValue(RPExtraTeams, "name") do
		local parent = menu:AddSubMenu(v.name)
		local function teamban(ply, t)
			if !IsValid(ply) then return end
			if t then
				LocalPlayer():ConCommand("ulx jobban $"..ply:UserID().." \""..v.name.."\" "..t)
			else
				LocalPlayer():ConCommand("ulx jobban $"..ply:UserID().." \""..v.name.."\"")
			end
		end
		parent:AddOption("10 Minuten", function()
			teamban(ply, 10)
		end)
		parent:AddOption("20 Minuten", function()
			teamban(ply, 20)
		end)
		parent:AddOption("30 Minuten", function()
			teamban(ply, 30)
		end)
		parent:AddOption("1 Stunde", function()
			teamban(ply, 60)
		end)
		parent:AddOption("2 Stunden", function()
			teamban(ply, 120)
		end)
		parent:AddOption("3 Stunden", function()
			teamban(ply, 180)
		end)
		parent:AddOption("Permanent", function()
			teamban(ply)
		end)
	end
	menu:Open()
end

function MG_Scoreboard.ULX_JobUnban(ply)
	local menu = DermaMenu()
	for k, v in SortedPairsByMemberValue(RPExtraTeams, "name") do
		menu:AddOption(v.name, function()
			if !IsValid(ply) then return end
			LocalPlayer():ConCommand("ulx jobunban $"..ply:UserID().." \""..v.name.."\"")
		end)
	end
	menu:Open()
end