function MG_Scoreboard.DrawRect(x, y, w, h, col)
	surface.SetDrawColor(col)
	surface.DrawRect(x, y, w, h)
end

function MG_Scoreboard.DrawText(msg, fnt, x, y, c, align)
	draw.SimpleText(msg, fnt, x, y, c, align and align or TEXT_ALIGN_CENTER)
end

function MG_Scoreboard.DrawOutline(x, y, w, h, t, c)
	surface.SetDrawColor(c)
	for i = 0, t - 1 do
		surface.DrawOutlinedRect(x + i, y + i, w - i * 2, h - i * 2)
	end
end

function MG_Scoreboard.DrawIcon(mat, x, y, col, w, h)
	surface.SetDrawColor(col and col or color_white)
	surface.SetMaterial(mat)
	surface.DrawTexturedRect(x, y, w and w or 32, h and h or 32)
end

function MG_Scoreboard.PaintBar(parent, bar_color)
	if !parent.VBar then return end
	parent.VBar.Paint = function(self, w, h)
	end
	parent.VBar.btnUp.Paint = function(self, w, h)
	end
	parent.VBar.btnDown.Paint = function(self, w, h)
	end
	parent.VBar.btnGrip.Paint = function(self, w, h)
		MG_Scoreboard.DrawRect(3, 0, w / 2, h, bar_color)
	end
end

function MG_Scoreboard.CreateButton(parent, x, y, w, h, font, txt)
	local btn = vgui.Create("DButton", parent)
	btn:SetSize(w, h)
	btn:SetFont(font)
	btn:SetText(txt)
	btn:SetPos(x, y)
	btn:SetTextColor(color_white)
	btn.Paint = function(self, w, h)
		if self:IsHovered() then
			MG_Scoreboard.DrawOutline(0, 0, w, h, 2, color_white)
		else
			self:SetTextColor(color_white)
		end
		MG_Scoreboard.DrawRect(0, 0, w, h, Color(4, 4, 4, 200))
	end
	return btn
end