AddCSLuaFile()

RSC = RSC or {}
RSC.Config = RSC.Config or {}

local function IncludeClient(file)
	AddCSLuaFile(file)
	if CLIENT then include(file) end
end

local function IncludeServer(file)
	if SERVER then include(file) end
end

local function IncludeShared(file)
	AddCSLuaFile(file)
	include(file)
end

-- Config, and shared scripts
IncludeServer("rsc/config.lua")
IncludeShared("rsc/shared/sh_utils.lua")
IncludeShared("rsc/shared/sh_language.lua")
IncludeShared("rsc/shared/sh_net.lua")
IncludeShared("rsc/shared/sh_metadata.lua")

-- Promise library
AddCSLuaFile("includes/modules/promise.lua")
require("promise")

-- Classes
IncludeShared("rsc/classes/event.lua")
IncludeShared("rsc/classes/service.lua")
IncludeShared("rsc/classes/capture_request.lua")

-- Loading services
for _, fileName in ipairs( file.Find("rsc/services/*", "LUA") ) do
	IncludeShared("rsc/services/" .. fileName)
end

-- Server side scripts
IncludeServer("rsc/server/sv_init.lua")
IncludeServer("rsc/server/sv_net.lua")
IncludeServer("rsc/server/sv_discord.lua")

-- Client side scripts
IncludeClient("rsc/client/cl_init.lua")
IncludeClient("rsc/client/cl_net.lua")
IncludeClient("rsc/client/cl_capture.lua")
IncludeClient("rsc/client/cl_gallery.lua")
IncludeClient("rsc/client/cl_admin.lua")

local function Init()
	if CLIENT then
		local temporary_files = file.Find("rsc/temp/*", "DATA")
		for _, f in ipairs(temporary_files) do
			file.Delete("rsc/temp/" .. f)
		end
	end

	RSC.Log("info", "Done.")
end
hook.Add("Initialize", "RSC.Initialzie", Init)

concommand.Add("rsc", promise.Async(function(ply, _, args)
	if #args == 0 then
		if IsValid(ply) then ply:ConCommand("rsc_menu") end
	return end
	if IsValid(ply) and not RSC.AsyncHasAccess(ply):Await() then return end

	local victim = RSC.FindPlayer(args[1])
	if not victim then
		print(RSC.GetPhrase("#rsc.errors.invalid_victim"))
	return end
	if IsValid(ply) and not RSC.AsyncCanScreengrab(ply, victim) then return end

	local request = RSC.CaptureRequest.New()
	request:Capture(victim, args[2], tonumber(args[3])):Await()

	print("You can find screengrab here: ", request:GetDownloadURL():Await())
end))
