-- Here is all language phrases
local LANG = {}

-- English. Default language
LANG["en"] = {
	["rsc.errors.invalid_victim"] = "Invalid victim",
	["rsc.errors.no_rights"] = "You don't have enough rights",
	["rsc.errors.capture_faked"] = "Failed to get actual screen capture (capture has been faked)",
	["rsc.errors.error_happened"] = "An error happened :(",
	["rsc.errors.timeout"] = "Request timed out (victim didn't respond)",
	["rsc.errors.player_disconnected"] = "Player disconnected",
	["rsc.errors.upload_failed"] = "Upload failed (%s)",
	["rsc.errors.download_failed"] = "Download failed (%s)",
	["rsc.errors.not_implemented"] = "not implemented",
	["rsc.errors.capture_is_running"] = "Capture is already running...",
	["rsc.errors.invalid_service"] = "Invalid service specified",

	["rsc.notify.copying_screen"] = "Capturing screen...",
	["rsc.notify.screen_to_image"] = "Getting a screen image...",
	["rsc.notify.checking_image"] = "Checking the image for faking...",
	["rsc.notify.uploading"] = "Uploading the image...",
	["rsc.notify.sending_capture_data"] = "Got capture data. Sending it to you...",
	["rsc.notify.downloading"] = "Downloading the image...",
	["rsc.notify.receiver_added"] = "Player '%s' has been added as receiver",
	["rsc.notify.upload_success"] = "Image successfully uploaded. Sending image url to the server...",

	["rsc.ui.in_progress"] = "In progress...",
	["rsc.ui.open_gallery"] = "Open gallery",
	["rsc.ui.screengrab"] = "Screengrab",
	["rsc.ui.options"] = "OPTIONS",
	["rsc.ui.transfer_service"] = "Transfer service",
	["rsc.ui.checking_status"] = "Checking status...",
	["rsc.ui.online"] = "Online",
	["rsc.ui.offline"] = "Offline",
	["rsc.ui.more_later"] = "More later...",
	["rsc.ui.image_quality"] = "Image quality",
	["rsc.ui.quality_best"] = "Best",
	["rsc.ui.quality_good"] = "Good",
	["rsc.ui.quality_low"] = "Low",
	["rsc.ui.other"] = "Other",
	["rsc.ui.save_screengrabs"] = "Save screengrabs",
	["rsc.ui.image_check"] = "If you don't see this text, then image has been faked.",
	["rsc.ui.search_placeholder"] = "name / steamid / usergroup",
	["rsc.ui.captured_by"] = "Captured by",
	["rsc.ui.user_target"] = "User Target",
	["rsc.ui.unique_id"] = "Unique ID",
	["rsc.ui.date"] = "Date",

	["rsc.discord.new_screengrab"] = "Received new screengrab",
	["rsc.discord.screengrabbed_by"] = "From player '%s'",
}

-- German
LANG["de"] = {
	["rsc.errors.invalid_victim"] = "Ungültiges Ziel.",
	["rsc.errors.no_rights"] = "Fehlende Privilegien.",
	["rsc.errors.capture_faked"] = "Screengrab fehgeschlagen. (Screen wurde gefälscht)",
	["rsc.errors.error_happened"] = "Ein Fehler ist aufgetreten :(",
	["rsc.errors.timeout"] = "Anfrage abgelaufen. (Ziel hat nicht reagiert)",
	["rsc.errors.player_disconnected"] = "Verbindung verloren.",
	["rsc.errors.upload_failed"] = "Upload fehlgeschlagen (%s)",
	["rsc.errors.download_failed"] = "Download fehlgeschlagen (%s)",
	["rsc.errors.not_implemented"] = "Nicht implementiert.",
	["rsc.errors.capture_is_running"] = "Screengrab läuft bereits...",
	["rsc.errors.invalid_service"] = "Ungültiger Service festgelegt.",

	["rsc.notify.copying_screen"] = "Bildschirm wird abgefragt...",
	["rsc.notify.screen_to_image"] = "Bild wird empfangen...",
	["rsc.notify.checking_image"] = "Bild wird auf Fälschung überprüft...",
	["rsc.notify.uploading"] = "Bild wird hochgeladen...",
	["rsc.notify.sending_capture_data"] = "Daten erhalten. Werden an dich gesendet...",
	["rsc.notify.downloading"] = "Bild wird heruntergeladen...",
	["rsc.notify.receiver_added"] = "Spieler \"%s\" wurde als Empfänger hinzugefügt.",
	["rsc.notify.upload_success"] = "Bild erfolgreich hochgeladen. Link wird an Server weitergegeben...",

	["rsc.ui.in_progress"] = "In Arbeit...",
	["rsc.ui.open_gallery"] = "Gallerie öffnen",
	["rsc.ui.screengrab"] = "Screengrab",
	["rsc.ui.options"] = "OPTIONEN",
	["rsc.ui.transfer_service"] = "Transfer-Service",
	["rsc.ui.checking_status"] = "Status wird überprüft...",
	["rsc.ui.online"] = "Online",
	["rsc.ui.offline"] = "Offline",
	["rsc.ui.more_later"] = "Zukünftig mehr...",
	["rsc.ui.image_quality"] = "Bildqualität",
	["rsc.ui.quality_best"] = "Sehr hoch",
	["rsc.ui.quality_good"] = "Hoch",
	["rsc.ui.quality_low"] = "Niedrig",
	["rsc.ui.other"] = "Sonstiges",
	["rsc.ui.save_screengrabs"] = "Screengrabs speichern",
	["rsc.ui.image_check"] = "Wenn du diesen Text nicht siehst, ist der Screengrab von einem Cheater gefälscht worden.",
	["rsc.ui.search_placeholder"] = "Name / SteamID / Nutzergruppe",
	["rsc.ui.captured_by"] = "Aufgenommen von:",
	["rsc.ui.user_target"] = "Bildschirm von:",
	["rsc.ui.unique_id"] = "Einzigartige ID:",
	["rsc.ui.date"] = "Datum:",

	["rsc.discord.new_screengrab"] = "Received new screengrab",
	["rsc.discord.screengrabbed_by"] = "From player '%s'",
}

-- DO NOT TOUCH CODE BELOW
RSC.CurrentLang = RSC.CurrentLang or "en"
RSC.Phrases = RSC.Phrases or {}

function RSC.GetPhrase(phrase, lang) -- Just copies language.GetPhrase for server and clients
	if phrase:StartWith("#") then phrase = phrase:sub(2) end
	return lang and LANG[lang][phrase] or RSC.Phrases[phrase]
end

local function RegisterLanguage(lang)
	for placeholder, fulltext in pairs(lang or {}) do
		if CLIENT then language.Add(placeholder, fulltext) end
		RSC.Phrases[placeholder] = fulltext
	end
end

local function UpdateCurrentLanguage()
	RSC.CurrentLang = SERVER and RSC.Config.DefaultLanguage or cvars.String("gmod_language") or "en"

	-- Forcing language if specified
	if RSC.Config.ForceLanguage then
		RSC.CurrentLang = RSC.Config.DefaultLanguage
	end

	RegisterLanguage(LANG["en"]) -- English just in case if some phrases are missing
	RegisterLanguage(LANG[tostring(RSC.CurrentLang)])
end

cvars.AddChangeCallback("gmod_language", UpdateCurrentLanguage, "RSC.OnLanguageChange")
hook.Add("RSC.OnConfigUpdated", "RSC.OnLanguageChange", UpdateCurrentLanguage)

UpdateCurrentLanguage()
