local buttons = {
	{
		title = "Bank-Admin öffnen",
		func = function()
			LocalPlayer():ConCommand("glorifiedbanking_admin")
		end,
	},
	{
		title = "Family-Admin öffnen",
		func = function()
			LocalPlayer():ConCommand("family_admin")
		end,
	},
	{
		title = "Inventar-Admin öffnen",
		func = function()
			LocalPlayer():ConCommand("inventory_admin")
		end,
	},
	{
		title = "Cardealer-Admin öffnen",
		func = function()
			LocalPlayer():ConCommand("car_dealer_admin")
		end,
	},
	{
		title = "Mapwechsel erzwingen",
		func = function()
			LocalPlayer():ConCommand("votemap_startmapvote 1")
		end,
	},
	{
		title = "Mapwechsel abbrechen",
		func = function()
			LocalPlayer():ConCommand("votemap_abort")
		end,
	},
	{
		title = "Selbstmord umschalten",
		func = function()
			RunConsoleCommand("mg_disablesuicide", GetConVar("mg_disablesuicide"):GetBool() and "0" or "1")
		end,
		defname = "switchsuicide_bttn",
	},
	{
		title = "Prop-Schaden umschalten",
		func = function()
			RunConsoleCommand("mg_propdamage", GetConVar("mg_propdamage"):GetBool() and "0" or "1")
		end,
		defname = "switchpropdmg_bttn",
	},
}

if CLIENT then
	local use_font = system.IsWindows() and "Tahoma" or "Verdana"
	surface.CreateFont("MGManageMenu_Title", {font = use_font, size = 30, weight = 1000, antialias = true})
	surface.CreateFont("MGManageMenu_Close", {font = use_font, size = 20, weight = 1000, antialias = true})
	surface.CreateFont("MGManageMenu_Body", {font = use_font, size = 25, weight = 500, antialias = true})

	local base
	concommand.Add("mg_manage_menu", function()
		if IsValid(base) then base:Remove() end
		if !LocalPlayer():IsSuperAdmin() then return end
		base = vgui.Create("DFrame")
		base:SetSize(400, 500)
		base:SetTitle("")
		base:Center()
		base:MakePopup()
		base:ShowCloseButton(false)
		base.Paint = function(self, w, h)
			draw.RoundedBox(2, 0, 0, w, h, Color(28, 28, 28))
			draw.RoundedBox(2, 0, 0, w, 56, Color(35, 35, 35))
			draw.RoundedBox(0, 0, 56, w, 7, Color(65, 144, 191))
			draw.SimpleText("Verwaltungsmenü", "MGManageMenu_Title", 7, 28, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_CENTER)
		end
		base:DockPadding(0, 70, 0, 0)

		local scroll = vgui.Create("DScrollPanel", base)
		scroll:Dock(FILL)
		scroll:GetVBar():SetHideButtons(true)
		scroll:GetVBar().Paint = function(self, w, h)
			draw.RoundedBox(2, 0, 0, w, h, Color(30, 30, 30))
		end
		scroll:GetVBar().btnGrip.Paint = function(self, w, h)
			draw.RoundedBox(2, 0, 0, w, h, Color(40, 40, 40))
		end

		local clsBttn = vgui.Create("DButton", base)
		clsBttn:SetText("")
		clsBttn:SetSize(70, 20)
		clsBttn:SetPos(base:GetWide() - 70, 0)
		clsBttn.Paint = function(self, w, h)
			draw.RoundedBox(0, 0, 0, w, h, self:IsHovered() and Color(194, 54, 22) or Color(232, 65, 24))
			draw.SimpleText("X", "MGManageMenu_Close", w * 0.5, h * 0.5, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		end
		clsBttn.DoClick = function()
			surface.PlaySound("buttons/button24.wav")
			base:Close()
		end

		for k, v in ipairs(buttons) do
			local Entry = vgui.Create("DButton", scroll)
			Entry:SetText("")
			Entry:DockMargin(10, 10, 10, 0)
			Entry:SetTall(30)
			Entry:Dock(TOP)
			Entry.Paint = function(self, w, h)
				draw.RoundedBox(2, 0, 0, w, h, self:IsHovered() and Color(38, 38, 38) or Color(35, 35, 35))
				draw.SimpleText(v.title, "MGManageMenu_Body", w * 0.5, h * 0.5, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			end
			Entry.DoClick = function()
				if v.defname then
					LocalPlayer():ConCommand("mg_manage_"..v.defname)
					surface.PlaySound("buttons/button24.wav")
					return
				else
					v.func()
					surface.PlaySound("buttons/button24.wav")
				end
				base:Close()
			end
		end
	end)
else
	for k, v in ipairs(buttons) do
		if !v.defname then continue end
		concommand.Add("mg_manage_"..v.defname, function(ply)
			if !ply:IsSuperAdmin() then return end
			ServerLog("[MG Admin Manage] "..ply:Name().." ("..ply:SteamID()..") used "..v.title.."\n")
			v.func()
		end)
	end
end