hook.Add("CanTool", "MG_PreventGridAbuse", function(ply, tr, tool)
	local ent = tr.Entity
	if tool == "material" and IsValid(ent) then
		local model = ent:GetModel()
		if (model == "models/props_building_details/storefront_template001a_bars.mdl" or model == "models/props_combine/combine_window001.mdl") then
			if SERVER then
				DarkRP.notify(ply, 1, 2, "Du kannst kein Material auf dieses Prop anwenden!")
			end
			return false
		end
	end
end)

properties.Add("MG_CopyClipboard", {
	MenuLabel = "Modellpfad kopieren",
	Order = -100,
	MenuIcon = "icon16/cut.png",
	Filter = function(self, ent, ply)
		if !IsValid(ent) or ent:IsPlayer() then return false end
		return true
	end,
	Action = function(self, ent)
		self:MsgStart()
			net.WriteEntity(ent)
		self:MsgEnd()
	end,
	Receive = function(self, length, player)
		local ent = net.ReadEntity()
		local model = ent:GetModel()
		player:ConCommand("mg_copymodel "..tostring(model))
	end
})

if CLIENT then
	concommand.Add("mg_copymodel", function(ply, cmd, args)
		if !args or !args[1] then return end
		SetClipboardText(args[1])
		ply:ChatPrint("Modell \""..args[1].."\" kopiert.")
	end)
end

if SERVER then
	local function LogQuit(msg)
		MsgN(msg)
		ServerLog(msg.."\n")
	end

	local function CheckForPlayers()
		LogQuit("quit_nice: Checking for players...")
		if player.GetCount() > 0 then
			LogQuit("quit_nice: More than 0 players online... Aborting...")
		else
			LogQuit("quit_nice: Less than 0 players online... Quitting server in 5 seconds...")
			timer.Simple(5, function()
				RunConsoleCommand("_restart")
			end)
		end
	end

	concommand.Add("quit_nice", function(ply, cmd, args)
		if IsValid(ply) then return end
		LogQuit("quit_nice: Running quit_nice...")
		CheckForPlayers()
		timer.Create("quit_nice", 60, 0, function()
			CheckForPlayers()
		end)
	end)

	concommand.Add("quit_stop", function(ply, cmd, args)
		if IsValid(ply) then return end
		timer.Remove("quit_nice")
	end)
end