surface.CreateFont("mg_taxifont", {
	font = "Bebas Neue",
	size = 24,
	outline = true,
})

local taxistat, pass, period = false, 0, mg_taxisystem.config.period
local pricemin, pricemax, pricedef = mg_taxisystem.config.pricemin, mg_taxisystem.config.pricemax, mg_taxisystem.config.pricedef
local job, pricecl

timer.Simple(0, function()
	job = mg_taxisystem.config.job
end)

local ply
local function drawstatus()
	ply = ply or LocalPlayer()
	local veh = ply:GetVehicle()
	if !ply:InVehicle() then
		hook.Remove("HUDPaint", "mg_taxisystem_hooks_hudpaint")
		hook.Remove("KeyPress", "mg_taxisystem_hooks_keypress")
		taxistat = false
		return
	end
	local scrw, scrh = ScrW() / 2, ScrH() - 70
	if taxistat then
		draw.SimpleText("Taxameter Status: Aktiv", "mg_taxifont", scrw, scrh - 50, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		draw.SimpleText("Passagiere: "..pass, "mg_taxifont", scrw, scrh - 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		draw.SimpleText("Zum Stoppen "..(input.LookupKeyBinding(IN_SPEED) or "SHIFT").." drücken.", "mg_taxifont", scrw, scrh, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	else
		draw.SimpleText("Taxameter Status: Deaktiviert", "mg_taxifont", scrw, scrh - 50, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		draw.SimpleText("Zum Starten "..(input.LookupKeyBinding(IN_SPEED) or "SHIFT").." drücken.", "mg_taxifont", scrw, scrh - 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end
end

local function keypress(ply, key)
	if gui.IsGameUIVisible() then return end
	if ply:IsTyping() then return end
	if !IsFirstTimePredicted() then return end
	if key != IN_SPEED then return end
	if taxistat then
	   net.Start("mg_taxisystem_net_stopreq")
	   net.SendToServer()
	else
	   net.Start("mg_taxisystem_net_startreq")
	   net.SendToServer()
	end
end

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("mg_taxifont_ent", {font = use_font, size = 100, weight = 1000, blursize = 0, antialias = true, shadow = false})
surface.CreateFont("mg_taxifont_ent_2", {font = use_font, size = 60, weight = 600, blursize = 0, antialias = true, shadow = false})

local local_ply
local vector_1 = Vector(0, 0, 1.1)
local function drawprice(d, s)
	if d or s then return end
	local_ply = local_ply or LocalPlayer()
	if local_ply:InVehicle() then return end
	for k, v in pairs(mg_taxisystem.taxis) do
		if k:IsDormant() or k:GetNoDraw() then continue end
		local owner = k:getDoorOwner() 
		if !IsValid(owner) or !owner:IsPlayer() or owner:Team() != job then continue end
		if local_ply:GetPos():DistToSqr(k:GetPos()) > 100000 then continue end
		local ang = k:GetAngles()	
		local pos = k:GetPos() + (vector_1 * (k:OBBMaxs().z + 5 + math.sin(SysTime() * 2) * 2))
		ang:RotateAroundAxis(ang:Forward(), 90)
		ang:RotateAroundAxis(ang:Right(), -90)
		ang:RotateAroundAxis(ang:Up(), 0)
		cam.Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.1)
			draw.SimpleTextOutlined("Taxi", "mg_taxifont_ent", 0, -20, Color(152, 152, 203, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			draw.SimpleTextOutlined("Preis: $"..(mg_taxisystem.prices[owner:SteamID()] or pricedef)..", alle "..period.." Sekunden", "mg_taxifont_ent_2", 0, 50, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
		cam.End3D2D()
	end
end

hook.Add("NetworkEntityCreated", "mg_taxisystem_hooks_entcreated", function(ent)
	if !ent:IsVehicle() then return end
	if table.IsEmpty(mg_taxisystem.taxis) then
		hook.Add("PostDrawTranslucentRenderables", "mg_taxi_postdrwtrans", drawprice)
	end
	mg_taxisystem.taxis[ent] = true
end)

hook.Add("EntityRemoved", "mg_taxisystem_hooks_entremoved", function(ent)
	if mg_taxisystem.taxis[ent] then
		mg_taxisystem.taxis[ent] = nil
		if table.IsEmpty(mg_taxisystem.taxis) then
			hook.Remove("PostDrawTranslucentRenderables", "mg_taxi_postdrwtrans")
		end
	end
end)

net.Receive("mg_taxisystem_net_showhud", function()
	hook.Add("KeyPress", "mg_taxisystem_hooks_keypress", keypress)
	hook.Add("HUDPaint", "mg_taxisystem_hooks_hudpaint", drawstatus)
end)

net.Receive("mg_taxisystem_net_updatehud", function()
	pass = net.ReadUInt(6)
	taxistat = net.ReadBool()
end)

net.Receive("mg_taxisystem_net_updatepricecl", function()
	mg_taxisystem.prices[net.ReadString()] = net.ReadInt(32)
end)

net.Receive("mg_taxisystem_net_showhudpass", function()
	pricecl = net.ReadInt(32)
	drv = net.ReadEntity()
	if !IsValid(drv) then return end
	local message = "Preis: $"..pricecl..", alle "..period.." Sekunden."
	local ply = LocalPlayer()
	hook.Add("HUDPaint", "mg_taxisystem_hooks_hudpaintpass", function()
		if !ply:InVehicle() or !drv:InVehicle() then
			hook.Remove("HUDPaint", "mg_taxisystem_hooks_hudpaintpass")
			pricecl = pricedef
			return
		end
		local scrw, scrh = ScrW() / 2, ScrH() - 150
		draw.SimpleText("Automatische Zahlung aktiv.", "mg_taxifont", scrw, scrh - 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		draw.SimpleText(message, "mg_taxifont", scrw, scrh, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
	end)
end)

net.Receive("mg_taxisystem_net_updatehudpass", function()
	pricecl = net.ReadInt(32)
end)

net.Receive("mg_taxisystem_net_hidehudpass", function()
	hook.Remove("HUDPaint", "mg_taxisystem_hooks_hudpaintpass")
	pricecl = pricedef
end)