local function AddClientFile(file)
	if CLIENT then
		include(file)
	else
		AddCSLuaFile(file)
	end
end

if SERVER then
	include("ticketsys/sh_config.lua")
	include("ticketsys/sh_util.lua")
	include("ticketsys/sv_sys.lua")
	for _, v in pairs(file.Find("ticketsys/languages/*.lua", "LUA")) do
		AddCSLuaFile("lua/ticketsys/languages/"..v)
	end
end

AddClientFile("ticketsys/sh_config.lua")
AddClientFile("ticketsys/sh_util.lua")
AddClientFile("ticketsys/cl_gui.lua")
AddClientFile("ticketsys/cl_hud.lua")
AddClientFile("ticketsys/cl_logic.lua")

local languages = {}
function languages:Init()
	self.Phrases = include("ticketsys/languages/"..TicketSystem_Config.DefaultLanguage..".lua")
end

function languages:GetPhrase(phrase)
	return self.Phrases[phrase] or "LANG.ERROR PHRASE: "..phrase
end

languages:Init()

TicketSystem_Language = languages