if SERVER then
	util.AddNetworkString("TicketSystem_Notify")

	TicketSystem_Notify = {}
	function TicketSystem_Notify:Add(ply, ...)
		net.Start("TicketSystem_Notify")
			net.WriteTable({...})
		net.Send(ply)
	end

	return
end

local TICK_COUNT = 0
local function GetTickCount()
	return TICK_COUNT
end

TicketSystem_Notify = {}
function TicketSystem_Notify:Init()
	self.Active = true
	self.NotificationsTbl = {}
	self.Positions = {}
	self.PanelWidth, self.PanelHeight = 230, 50
	self.TitleHeight = 25
	self.TopOffset = 65
	self.Space = 5
	self.BlendDuration = 500
	self.MoveDuration = 3000

	hook.Add("HUDPaint", "TicketSystem_Notify", function()
		self:Render()
	end, HOOK_MONITOR_LOW or 2)

	hook.Add("Think", "TicketSystem_CountTicks", function()
		TICK_COUNT = TICK_COUNT + (RealFrameTime() * 1000)
	end)

	net.Receive("TicketSystem_Notify", function()
		local args = net.ReadTable()
		TicketSystem_Notify:Add(args[1], args[2], args[3], args[4])
	end)
end

TicketSystem_Notify:Init()

function TicketSystem_Notify:Render()
	if self.Active then
		for index, box in pairs(self.NotificationsTbl) do
			local alpha = 1
			local tick_cnt = GetTickCount()
			local start = box.Start
			local duration = box.Duration
			local blend = self.BlendDuration
			if ((start + duration) < tick_cnt) then
				alpha = 1 - Lerp((tick_cnt - (start + duration)) / blend, 0, 100) / 100
			end
			local mess = box.Message
			local pnl_wid = self.PanelWidth
			surface.SetFont("DermaDefault")
			local w = surface.GetTextSize(mess)
			if w >= pnl_wid - 25 then
				pnl_wid = w + 25
			end
			local sx = ScrW()
			local x = (sx / 2) - (pnl_wid / 2)
			local pnl_hgt = self.PanelHeight
			local ttl_hgt = self.TitleHeight
			local y = Lerp((tick_cnt - box.Time) / self.MoveDuration, (self.Positions[index] or 0) + 0.01, self.TopOffset + (box.Position * (self.Space + pnl_hgt + ttl_hgt)))
			self.Positions[index] = y
			surface.SetDrawColor(15, 15, 15, 200 * alpha)
			surface.DrawRect(x, y + ttl_hgt, pnl_wid, pnl_hgt)
			surface.SetDrawColor(255, 255, 255, 200 * alpha)
			surface.DrawRect(x, y + ttl_hgt, pnl_wid, 1)
			surface.SetDrawColor(box.Color[1], box.Color[2], box.Color[3], 200 * alpha)
			surface.DrawRect(x, y, pnl_wid, ttl_hgt)
			draw.SimpleText(box.Title, "DermaDefaultBold", x + pnl_wid / 2, y + ttl_hgt / 2, Color(255, 255, 255, 230 * alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			draw.SimpleText(mess, "DermaDefault", x + pnl_wid / 2, y + ttl_hgt + (pnl_hgt / 2) - 2, Color(255, 255, 255, 230 * alpha), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			if ((start + duration + blend) < tick_cnt) then
				self.NotificationsTbl[index] = nil
				self.Positions[index] = nil
			end
		end
	end
end

function TicketSystem_Notify:UpdatePositions()
	for _, box in pairs(self.NotificationsTbl) do
		box.Position = box.Position + 1
		box.Time = GetTickCount()
	end
end

local DEF_COLOR = {
	["DEFAULT"] = {255, 160, 35},
	["DANGER"] = {255, 60, 60},
	["WARNING"] = {235, 235, 35},
	["SUCCESS"] = {40, 190, 85},
}

local notify_sound = CreateClientConVar("cl_ticketsys_notifysound", 1)
local notify_important = CreateClientConVar("cl_ticketsys_notifyimportant", 1)
function TicketSystem_Notify:Add(message, duration, color, important)
	local color = DEF_COLOR[color] or {255, 255, 255}
	self:UpdatePositions()
	local tick_cnt = GetTickCount()
	table.insert(self.NotificationsTbl, {
		Title = "Ticketsystem",
		Message = message or "-",
		Duration = tonumber(duration) or 3000,
		Color = color,
		Time = tick_cnt,
		Start = tick_cnt,
		Position = 0
	})
	if notify_sound:GetBool() then
		if !notify_important:GetBool() or important then
			surface.PlaySound("garrysmod/content_downloaded.wav")
		end
	end
	print("Ticketsystem: "..message)
end