TicketSystem_HUD = {}

local HUD = TicketSystem_HUD

local local_ply
local showopentickets = CreateClientConVar("cl_showopentickets", 1)
local function HUDRender()
	if !showopentickets:GetBool() then return end
	if (HUD.IsOpen or 0) > 0 then
		local_ply = local_ply or LocalPlayer()
		local group = local_ply:GetUserGroup()
		if HUD.PlayerGroup != group then
			HUD.PlayerGroup = group
			HUD.IsAdminUser = TicketSystem:IsAdmin(local_ply)
		end
		if HUD.IsAdminUser then
			local scrw = ScrW()
			local scrh = ScrH() / 4
			local w = HUD.PanelWidth
			local h = HUD.PanelHeight
			local offset = HUD.PanelOffset
			draw.RoundedBox(0, scrw - w, scrh - offset, w, h, Color(30, 30, 30, 200))
			draw.RoundedBox(0, scrw - w + 2, scrh - offset + 2, w - 4, h - 4, Color(25, 25, 25, 200))
			surface.SetMaterial(HUD.PanelIcon)
			surface.SetDrawColor(color_white)
			surface.DrawTexturedRect(scrw - w + 15, (scrh - offset) + h / 2 - 7, 16, 16)
			draw.SimpleText(TicketSystem_Language:GetPhrase("OPEN_TICKETS")..": "..HUD.IsOpen, "DermaDefaultBold", scrw - w / 2, (scrh - offset) + h / 2, MG_Theme.Theme:GetPrimaryColor(), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		end
	end
end

function HUD:Init()
	self.IsAdminUser = false
	self.IsOpen = 0
	self.PlayerGroup = false
	self.PanelWidth = TicketSystem_Config.HUDSize[1]
	self.PanelHeight = TicketSystem_Config.HUDSize[2]
	self.PanelOffset = TicketSystem_Config.HUDYOffset

	hook.Add("HUDPaint", "TicketSystem_HUD", HUDRender)

	net.Receive("TicketSystem_UpdateHUD", function()
		self.IsOpen = net.ReadUInt(32)
	end)

	self.PanelIcon = Material("icon16/exclamation.png")
end

HUD:Init()