TicketSystem_Logic = {}

local Logic = TicketSystem_Logic
local TicketsGUI = TicketSystem_TicketsGUI
local TicketsShowGUI = TicketSystem_TicketsShowGUI
local AdminTicketsGUI = TicketSystem_AdminTicketsGUI
local AdminShowGUI = TicketSystem_AdminShowGUI
local AdminStatsGUI = TicketSystem_AdminStatsGUI

function Logic:Init()
	net.Receive("TicketSystem_SendTickets", function()
		local leng = net.ReadUInt(32)
		local tickets = net.ReadData(leng)
		tickets = util.JSONToTable(util.Decompress(tickets))
		TicketsGUI:UpdateTickets(tickets)
	end)

	net.Receive("TicketSystem_Admin_SendTickets", function()
		local leng = net.ReadUInt(32)
		local tickets = net.ReadData(leng)
		local page = net.ReadUInt(32)
		tickets = util.JSONToTable(util.Decompress(tickets))
		AdminTicketsGUI:UpdateTickets(tickets, page)
	end)

	net.Receive("TicketSystem_SendMessages", function()
		local id = net.ReadUInt(32)
		local leng = net.ReadUInt(32)
		local messages = net.ReadData(leng)
		messages = util.JSONToTable(util.Decompress(messages))
		if IsValid(AdminShowGUI.Frame) and AdminShowGUI.ID == id then
			AdminShowGUI:AddMessages(messages)
		elseif IsValid(TicketsShowGUI.Frame) and TicketsShowGUI.ID == id then
			TicketsShowGUI:AddMessages(messages)
		end
	end)

	net.Receive("TicketSystem_Admin_SendStats", function()
		local leng = net.ReadUInt(32)
		local stats = net.ReadData(leng)
		stats = util.JSONToTable(util.Decompress(stats))
		AdminStatsGUI:UpdateStats(stats)
	end)

	net.Receive("TicketSystem_UpdateMenu", function()
		local typ = net.ReadUInt(16)
		local tab = net.ReadTable()
		if typ == 1 then
			local id = tab[1]
			local name = tab[2]
			local steamid = tab[3]
			if IsValid(AdminTicketsGUI.Frame) then
				if AdminTicketsGUI.DermaID == id and IsValid(AdminTicketsGUI.DermaMenu) then
					AdminTicketsGUI.DermaMenu:Remove()
				end
				if IsValid(AdminTicketsGUI.TicketList) then
					for _, line in pairs(AdminTicketsGUI.TicketList:GetLines()) do
						if id == tonumber(line:GetColumnText(1)) then
							local tdata = AdminTicketsGUI.TicketData[id]
							tdata["status"] = 2
							tdata["admin"] = name
							tdata["admin_steamid"] = steamid
							if tonumber(AdminTicketsGUI.Selected) == id then
								AdminTicketsGUI.TicketList:OnRowSelected(id, line)
							end
							line.Columns[3]:SetText(TicketSystem_Config.TicketStatus[2] or TicketSystem_Language:GetPhrase("UNKNOWN"))
							local ply = LocalPlayer()
							if steamid == ply:SteamID() then
								line.BackgroundColor = MG_Theme.Theme:GetPrimaryColor(30)
							end
							local color = MG_Theme.Theme:GetStatusColor(2)
							line:SetColumnColor(3, color)
							break
						end
					end
				end
			end
			if IsValid(AdminShowGUI.Frame) and AdminShowGUI.ID == id then
				local tdata = AdminShowGUI.Ticket
				tdata["status"] = 2
				tdata["admin"] = name
				tdata["admin_steamid"] = steamid
				AdminShowGUI.StateLabel:SetText(TicketSystem_Config.TicketStatus[2] or TicketSystem_Language:GetPhrase("UNKNOWN"))
				AdminShowGUI.StateLabel:SetTextColor(MG_Theme.Theme:GetStatusColor(2))
				AdminShowGUI.AdminLabel:SetText(name)
				AdminShowGUI:AddMenuBar(tdata)
			end
			if IsValid(TicketsGUI.Frame) then
				if TicketsGUI.DermaID == id and IsValid(TicketsGUI.DermaMenu) then
					TicketsGUI.DermaMenu:Remove()
				end
				if IsValid(TicketsGUI.TicketList) then
					for _, line in pairs(TicketsGUI.TicketList:GetLines()) do
						if id == tonumber(line:GetColumnText(1)) then
							local tdata = TicketsGUI.TicketData[id]
							tdata["status"] = 2
							tdata["admin"] = name
							tdata["admin_steamid"] = steamid
							line.Columns[3]:SetText(TicketSystem_Config.TicketStatus[2] or TicketSystem_Language:GetPhrase("UNKNOWN"))
							line.Columns[5]:SetText(name)
							local color = MG_Theme.Theme:GetStatusColor(2)
							line:SetColumnColor(3, color)
							break
						end
					end
				end
			end
			if IsValid(TicketsShowGUI.Frame) and TicketsShowGUI.ID == id then
				local tdata = TicketsShowGUI.Ticket
				tdata["status"] = 2
				tdata["admin"] = name
				tdata["admin_steamid"] = steamid
				TicketsShowGUI.StateLabel:SetText(TicketSystem_Config.TicketStatus[2] or TicketSystem_Language:GetPhrase("UNKNOWN"))
				TicketsShowGUI.StateLabel:SetTextColor(MG_Theme.Theme:GetStatusColor(2))
				TicketsShowGUI.AdminLabel:SetText(name)
			end
		elseif typ == 2 then
			local id = tab[1]
			local name = tab[2]
			local steamid = tab[3]
			if IsValid(AdminTicketsGUI.Frame) then
				if AdminTicketsGUI.DermaID == id and IsValid(AdminTicketsGUI.DermaMenu) then
					AdminTicketsGUI.DermaMenu:Remove()
				end
				if IsValid(AdminTicketsGUI.TicketList) then
					for _, line in pairs(AdminTicketsGUI.TicketList:GetLines()) do
						if id == tonumber(line:GetColumnText(1)) then
							local tdata = AdminTicketsGUI.TicketData[id]
							tdata["status"] = 3
							if name then
								tdata["admin"] = name
							end
							if steamid then
								tdata["admin_steamid"] = steamid
							end
							if tonumber(AdminTicketsGUI.Selected) == id then
								AdminTicketsGUI.TicketList:OnRowSelected(id, line)
							end
							line.Columns[3]:SetText(TicketSystem_Config.TicketStatus[3] or TicketSystem_Language:GetPhrase("UNKNOWN"))
							local ply = LocalPlayer()
							if steamid == ply:SteamID() then
								line.BackgroundColor = MG_Theme.Theme:GetPrimaryColor(30)
							end
							local color = MG_Theme.Theme:GetStatusColor(3)
							line:SetColumnColor(3, color)
							break
						end
					end
				end
			end
			if IsValid(AdminShowGUI.Frame) and AdminShowGUI.ID == id then
				local tdata = AdminShowGUI.Ticket
				tdata["status"] = 3
				if name then
					tdata["admin"] = name
				end
				if steamid then
					tdata["admin_steamid"] = steamid
				end
				AdminShowGUI.StateLabel:SetText(TicketSystem_Config.TicketStatus[3] or TicketSystem_Language:GetPhrase("UNKNOWN"))
				AdminShowGUI.StateLabel:SetTextColor(MG_Theme.Theme:GetStatusColor(3))
				if name then
					AdminShowGUI.AdminLabel:SetText(name)
				end
				AdminShowGUI:AddMenuBar(AdminShowGUI.Ticket)
			end
			if IsValid(TicketsGUI.Frame) then
				if TicketsGUI.DermaID == id and IsValid(TicketsGUI.DermaMenu) then
					TicketsGUI.DermaMenu:Remove()
				end
				if IsValid(TicketsGUI.TicketList) then
					for _, line in pairs(TicketsGUI.TicketList:GetLines()) do
						if id == tonumber(line:GetColumnText(1)) then
							local tdata = TicketsGUI.TicketData[id]
							tdata["status"] = 3
							if name then
								tdata["admin"] = name
							end
							if steamid then
								tdata["admin_steamid"] = steamid
							end
							line.Columns[3]:SetText(TicketSystem_Config.TicketStatus[3] or TicketSystem_Language:GetPhrase("UNKNOWN"))
							if name then
								line.Columns[5]:SetText(name)
							end
							local color = MG_Theme.Theme:GetStatusColor(3)
							line:SetColumnColor(3, color)
							break
						end
					end
				end
			end
			if IsValid(TicketsShowGUI.Frame) and TicketsShowGUI.ID == id then
				TicketsShowGUI.Ticket["status"] = 3
				if name then
					tdata["admin"] = name
				end
				if steamid then
					tdata["admin_steamid"] = steamid
				end
				TicketsShowGUI.StateLabel:SetText(TicketSystem_Config.TicketStatus[3] or TicketSystem_Language:GetPhrase("UNKNOWN"))
				TicketsShowGUI.StateLabel:SetTextColor(MG_Theme.Theme:GetStatusColor(3))
				if name then
					TicketsShowGUI.AdminLabel:SetText(name)
				end
			end
		elseif typ == 3 then
			if IsValid(AdminTicketsGUI.Frame) then
				if IsValid(AdminTicketsGUI.DermaMenu) then
					AdminTicketsGUI.DermaMenu:Remove()
				end
				if IsValid(AdminTicketsGUI.TicketList) then
					for _, line in pairs(AdminTicketsGUI.TicketList:GetLines()) do
						local id = tonumber(line:GetColumnText(1))
						AdminTicketsGUI.TicketData[id]["status"] = 3
						if tonumber(AdminTicketsGUI.Selected) == id then
							AdminTicketsGUI.TicketList:OnRowSelected(id, line)
						end
						line.Columns[3]:SetText(TicketSystem_Config.TicketStatus[3] or TicketSystem_Language:GetPhrase("UNKNOWN"))
						local color = MG_Theme.Theme:GetStatusColor(3)
						line:SetColumnColor(3, color)
					end
				end
			end
			if IsValid(AdminShowGUI.Frame) then
				AdminShowGUI.Ticket["status"] = 3
				AdminShowGUI.StateLabel:SetText(TicketSystem_Config.TicketStatus[3] or TicketSystem_Language:GetPhrase("UNKNOWN"))
				AdminShowGUI.StateLabel:SetTextColor(MG_Theme.Theme:GetStatusColor(3))
				AdminShowGUI:AddMenuBar(AdminShowGUI.Ticket)
			end
			if IsValid(TicketsGUI.Frame) then
				if IsValid(TicketsGUI.DermaMenu) then
					TicketsGUI.DermaMenu:Remove()
				end
				if IsValid(TicketsGUI.TicketList) then
					for _, line in pairs(TicketsGUI.TicketList:GetLines()) do
						TicketsGUI.TicketData[tonumber(line:GetColumnText(1))]["status"] = 3
						line.Columns[3]:SetText(TicketSystem_Config.TicketStatus[3] or TicketSystem_Language:GetPhrase("UNKNOWN"))
						local color = MG_Theme.Theme:GetStatusColor(3)
						line:SetColumnColor(3, color)
					end
				end
			end
			if IsValid(TicketsShowGUI.Frame) then
				TicketsShowGUI.Ticket["status"] = 3
				TicketsShowGUI.StateLabel:SetText(TicketSystem_Config.TicketStatus[3] or TicketSystem_Language:GetPhrase("UNKNOWN"))
				TicketsShowGUI.StateLabel:SetTextColor(MG_Theme.Theme:GetStatusColor(3))
			end
		elseif typ == 4 then
			local steamid = tab[1]
			if IsValid(AdminTicketsGUI.Frame) then
				if IsValid(AdminTicketsGUI.TicketList) then
					for _, line in pairs(AdminTicketsGUI.TicketList:GetLines()) do
						local id = tonumber(line:GetColumnText(1))
						if steamid == AdminTicketsGUI.TicketData[id]["steamid"] then
							if AdminTicketsGUI.DermaID == id and IsValid(AdminTicketsGUI.DermaMenu) then
								AdminTicketsGUI.DermaMenu:Remove()
							end
							local tdata = AdminTicketsGUI.TicketData[id]
							tdata["status"] = 3
							if tonumber(AdminTicketsGUI.Selected) == id then
								AdminTicketsGUI.TicketList:OnRowSelected(id, line)
							end
							line.Columns[3]:SetText(TicketSystem_Config.TicketStatus[3] or TicketSystem_Language:GetPhrase("UNKNOWN"))
							local color = MG_Theme.Theme:GetStatusColor(3)
							line:SetColumnColor(3, color)
						end
					end
				end
			end
			if IsValid(AdminShowGUI.Frame) and AdminShowGUI.Ticket["steamid"] == steamid then
				AdminShowGUI.Ticket["status"] = 3
				AdminShowGUI.StateLabel:SetText(TicketSystem_Config.TicketStatus[3] or TicketSystem_Language:GetPhrase("UNKNOWN"))
				AdminShowGUI.StateLabel:SetTextColor(MG_Theme.Theme:GetStatusColor(3))
				AdminShowGUI:AddMenuBar(AdminShowGUI.Ticket)
			end
			if IsValid(TicketsGUI.Frame) then
				if IsValid(TicketsGUI.TicketList) then
					for _, line in pairs(TicketsGUI.TicketList:GetLines()) do
						local id = tonumber(line:GetColumnText(1))
						if steamid == TicketsGUI.TicketData[id]["steamid"] then
							if TicketsGUI.DermaID == id and IsValid(TicketsGUI.DermaMenu) then
								TicketsGUI.DermaMenu:Remove()
							end
							local tdata = TicketsGUI.TicketData[id]
							tdata["status"] = 3
							line.Columns[3]:SetText(TicketSystem_Config.TicketStatus[3] or TicketSystem_Language:GetPhrase("UNKNOWN"))
							local color = MG_Theme.Theme:GetStatusColor(3)
							line:SetColumnColor(3, color)
						end
					end
				end
			end
			if IsValid(TicketsShowGUI.Frame) and TicketsShowGUI.Ticket["steamid"] == steamid then
				TicketsShowGUI.Ticket["status"] = 3
				TicketsShowGUI.StateLabel:SetText(TicketSystem_Config.TicketStatus[3] or TicketSystem_Language:GetPhrase("UNKNOWN"))
				TicketsShowGUI.StateLabel:SetTextColor(MG_Theme.Theme:GetStatusColor(3))
			end
		elseif typ == 5 then
			local id = tab[1]
			if IsValid(AdminTicketsGUI.Frame) then
				if AdminTicketsGUI.DermaID == id and IsValid(AdminTicketsGUI.DermaMenu) then
					AdminTicketsGUI.DermaMenu:Remove()
				end
				if IsValid(AdminTicketsGUI.TicketList) then
					for _, line in pairs(AdminTicketsGUI.TicketList:GetLines()) do
						if id == tonumber(line:GetColumnText(1)) then
							local tdata = AdminTicketsGUI.TicketData[id]
							tdata["status"] = 1
							tdata["admin"] = TicketSystem_Language:GetPhrase("NOBODY")
							tdata["admin_steamid"] = "N/A"
							if tonumber(AdminTicketsGUI.Selected) == id then
								AdminTicketsGUI.TicketList:OnRowSelected(id, line)
							end
							line.Columns[3]:SetText(TicketSystem_Config.TicketStatus[1] or TicketSystem_Language:GetPhrase("UNKNOWN"))
							line.BackgroundColor = nil
							local color = MG_Theme.Theme:GetStatusColor(1)
							line:SetColumnColor(3, color)
							break
						end
					end
				end
			end
			if IsValid(AdminShowGUI.Frame) and AdminShowGUI.ID == id then
				local tdata = AdminShowGUI.Ticket
				tdata["status"] = 1
				tdata["admin"] = TicketSystem_Language:GetPhrase("NOBODY")
				tdata["admin_steamid"] = "N/A"
				AdminShowGUI.StateLabel:SetText(TicketSystem_Config.TicketStatus[1] or TicketSystem_Language:GetPhrase("UNKNOWN"))
				AdminShowGUI.StateLabel:SetTextColor(MG_Theme.Theme:GetStatusColor(1))
				AdminShowGUI.AdminLabel:SetText(TicketSystem_Language:GetPhrase("NOBODY"))
				AdminShowGUI:AddMenuBar(tdata)
			end
			if IsValid(TicketsGUI.Frame) then
				if TicketsGUI.DermaID == id and IsValid(TicketsGUI.DermaMenu) then
					TicketsGUI.DermaMenu:Remove()
				end
				if IsValid(TicketsGUI.TicketList) then
					for _, line in pairs(TicketsGUI.TicketList:GetLines()) do
						if id == tonumber(line:GetColumnText(1)) then
							local tdata = TicketsGUI.TicketData[id]
							tdata["status"] = 1
							tdata["admin"] = TicketSystem_Language:GetPhrase("NOBODY")
							tdata["admin_steamid"] = "N/A"
							line.Columns[3]:SetText(TicketSystem_Config.TicketStatus[1] or TicketSystem_Language:GetPhrase("UNKNOWN"))
							line.Columns[5]:SetText(TicketSystem_Language:GetPhrase("NOBODY"))
							local color = MG_Theme.Theme:GetStatusColor(1)
							line:SetColumnColor(3, color)
							break
						end
					end
				end
			end
			if IsValid(TicketsShowGUI.Frame) and TicketsShowGUI.ID == id then
				local tdata = TicketsShowGUI.Ticket
				tdata["status"] = 1
				tdata["admin"] = TicketSystem_Language:GetPhrase("NOBODY")
				tdata["admin_steamid"] = "N/A"
				TicketsShowGUI.StateLabel:SetText(TicketSystem_Config.TicketStatus[1] or TicketSystem_Language:GetPhrase("UNKNOWN"))
				TicketsShowGUI.StateLabel:SetTextColor(MG_Theme.Theme:GetStatusColor(1))
				TicketsShowGUI.AdminLabel:SetText(TicketSystem_Language:GetPhrase("NOBODY"))
			end
		elseif typ == 6 then
			local id = tab[1]
			if IsValid(AdminTicketsGUI.TicketList) then
				for k, line in pairs(AdminTicketsGUI.TicketList:GetLines()) do
					if id == tonumber(line:GetColumnText(1)) then
						AdminTicketsGUI.TicketData[id] = nil
						if AdminTicketsGUI.DermaID == id and IsValid(AdminTicketsGUI.DermaMenu) then
							AdminTicketsGUI.DermaMenu:Remove()
						end
						if tonumber(AdminTicketsGUI.Selected) == id then
							AdminTicketsGUI.TicketList:OnRowSelected()
						end
						AdminTicketsGUI.TicketList:RemoveLine(k)
					end
				end
				AdminTicketsGUI.TicketsLabel:SetText(TicketSystem_Language:GetPhrase("TICKETS")..": "..string.Comma(table.Count(AdminTicketsGUI.TicketData)))
			end
			if IsValid(AdminShowGUI.Frame) and AdminShowGUI.ID == id then
				AdminShowGUI:Close()
			end
			if IsValid(TicketsGUI.TicketList) then
				for k, line in pairs(TicketsGUI.TicketList:GetLines()) do
					if id == tonumber(line:GetColumnText(1)) then
						TicketsGUI.TicketData[id] = nil
						if TicketsGUI.DermaID == id and IsValid(TicketsGUI.DermaMenu) then
							TicketsGUI.DermaMenu:Remove()
						end
						TicketsGUI.TicketList:RemoveLine(k)
					end
				end
			end
			if IsValid(TicketsShowGUI.Frame) and TicketsShowGUI.ID == id then
				TicketsShowGUI:Close()
			end
		elseif typ == 7 then
			if IsValid(AdminTicketsGUI.Frame) then
				if IsValid(AdminTicketsGUI.DermaMenu) then
					AdminTicketsGUI.DermaMenu:Remove()
				end
				if IsValid(AdminTicketsGUI.TicketList) then
					AdminTicketsGUI.TicketList:OnRowSelected()
					for k, line in pairs(AdminTicketsGUI.TicketList:GetLines()) do
						AdminTicketsGUI.TicketList:RemoveLine(k)
					end
				end
				AdminTicketsGUI.TicketData = {}
				AdminTicketsGUI.TicketsLabel:SetText(TicketSystem_Language:GetPhrase("TICKETS")..": 0")
			end
			if IsValid(AdminShowGUI.Frame) then
				AdminShowGUI:Close()
			end
			if IsValid(TicketsGUI.Frame) then
				if IsValid(TicketsGUI.DermaMenu) then
					TicketsGUI.DermaMenu:Remove()
				end
				if IsValid(TicketsGUI.TicketList) then
					for k, line in pairs(TicketsGUI.TicketList:GetLines()) do
						TicketsGUI.TicketList:RemoveLine(k)
					end
				end
				TicketsGUI.TicketData = {}
			end
			if IsValid(TicketsShowGUI.Frame) then
				TicketsShowGUI:Close()
			end
		elseif typ == 8 then
			local steamid = tab[1]
			if IsValid(AdminTicketsGUI.TicketList) then
				for k, line in pairs(AdminTicketsGUI.TicketList:GetLines()) do
					local id = tonumber(line:GetColumnText(1))
					if steamid == AdminTicketsGUI.TicketData[id]["steamid"] then
						AdminTicketsGUI.TicketData[id] = nil
						if AdminTicketsGUI.DermaID == id and IsValid(AdminTicketsGUI.DermaMenu) then
							AdminTicketsGUI.DermaMenu:Remove()
						end
						if tonumber(AdminTicketsGUI.Selected) == id then
							AdminTicketsGUI.TicketList:OnRowSelected()
						end
						AdminTicketsGUI.TicketList:RemoveLine(k)
					end
				end
				AdminTicketsGUI.TicketsLabel:SetText(TicketSystem_Language:GetPhrase("TICKETS")..": "..string.Comma(table.Count(AdminTicketsGUI.TicketData)))
			end
			if IsValid(AdminShowGUI.Frame) and AdminShowGUI.Ticket["steamid"] == steamid then
				AdminShowGUI:Close()
			end
			if IsValid(TicketsGUI.TicketList) then
				for k, line in pairs(TicketsGUI.TicketList:GetLines()) do
					local id = tonumber(line:GetColumnText(1))
					if steamid == TicketsGUI.TicketData[id]["steamid"] then
						TicketsGUI.TicketData[id] = nil
						if TicketsGUI.DermaID == id and IsValid(TicketsGUI.DermaMenu) then
							TicketsGUI.DermaMenu:Remove()
						end
						TicketsGUI.TicketList:RemoveLine(k)
					end
				end
			end
			if IsValid(TicketsShowGUI.Frame) and TicketsShowGUI.Ticket["steamid"] == steamid then
				TicketsShowGUI:Close()
			end
		end
	end)

	function TicketSystem.UpdateTickets(page, showclosed)
		net.Start("TicketSystem_UpdateTickets")
			local ply = LocalPlayer()
			if TicketSystem:IsAdmin(ply) then
				net.WriteUInt(page or 1, 32)
				if showclosed != nil then
					net.WriteBool(showclosed)
				else
					net.WriteBool(GetConVar("cl_showclosedtickets"):GetBool())
				end
			end
		net.SendToServer()
	end

	local function OpenTicketMenu(ply)
		if TicketSystem:IsAdmin(ply) then
			AdminTicketsGUI:Open()
		else
			TicketsGUI:Open()
		end
		TicketSystem.UpdateTickets(1)
	end

	local function CloseTicketMenu()
		TicketsGUI:Close()
		AdminTicketsGUI:Close()
		TicketsShowGUI:Close()
		AdminShowGUI:Close()
		AdminStatsGUI:Close()
	end

	concommand.Add("ticket_system", function(ply)
		OpenTicketMenu(ply)
	end)

	local commands = {}
	local function AddChatCommand(command)
		commands[string.lower(command)] = true
	end

	for _, cmd in ipairs(TicketSystem_Config.ChatCommands) do
		AddChatCommand(cmd)
	end

	hook.Add("OnPlayerChat", "TicketSystem_Commands", function(ply, text)
		text = string.lower(text)
		local text_sub = string.sub(text, 1, 1)
		if text_sub == "@" or text_sub == "!" or text_sub == "/" then
			local command = string.sub(text, 2, #text)
			if text_sub == "@" or commands[string.lower(command)] then
				if ply != LocalPlayer() then return true end
				OpenTicketMenu(ply)
				return true
			end
		end
	end)

	local down = false
	local delay = 0
	local function BindHandler()
		if input.IsKeyDown(TicketSystem_Config.TicketBind or KEY_F8) then
			if !down then
				if IsValid(TicketsGUI.Frame) or IsValid(AdminTicketsGUI.Frame) then
					CloseTicketMenu()
					CloseDermaMenus()
				else
					local cur_time = CurTime()
					if delay > cur_time then return end
					delay = cur_time + 0.15
					OpenTicketMenu(LocalPlayer())
				end
				down = true
			end
		else
			down = false
		end
	end
	hook.Add("Think", "TicketSystem_BindHandler", BindHandler)
end

Logic:Init()