function ENT:CalculateCursorPos()
	local ply = LocalPlayer()
	if !IsValid(ply) then return 0, 0 end
	local eyepos = ply:EyePos()
	local aimvector = ply:GetAimVector()
	local tr = util.TraceLine({start = eyepos, endpos = eyepos + aimvector * 65, filter = ply})
	if tr.Entity != self then return 0, 0 end
	local scale = self.Scale
	local pos, ang = self:CalculateRenderPos(), self:CalculateRenderAng()
	local normal = self:GetForward()
	local intersection = util.IntersectRayWithPlane(eyepos, aimvector, pos, normal)
	if !intersection then return 0, 0 end
	local diff = pos - intersection
	local x = diff:Dot(-ang:Forward()) / scale
	local y = diff:Dot(-ang:Right()) / scale
	return x, y
end

function ENT:CalculateRenderPos()
	local pos = self:GetPos()
	pos:Add(self:GetForward() * self.Maxs.x)
	pos:Add(self:GetRight() * self.Maxs.y)
	pos:Add(self:GetUp() * self.Maxs.z)
	pos:Add(self:GetForward() * 0.15)
	return pos
end

function ENT:CalculateRenderAng()
	local ang = self:GetAngles()
	ang:RotateAroundAxis(ang:Right(), -90)
	ang:RotateAroundAxis(ang:Up(), 90)	
	return ang
end