if SERVER then
	AddCSLuaFile()
end

ENT.Type = "anim"
ENT.Base = "base_gmodentity"
ENT.PrintName = "Money Pot"
ENT.Spawnable = false
ENT.IsMoneyPot = true

if CLIENT then
	function ENT:Think()
		if self:BeingLookedAtByLocalPlayer() and !self:GetNoDraw() then
			local text = "Money Pot\nInhalt: $"..string.Comma(self:GetDTInt(0))

			if self:GetNWInt("Production") > 0 then
				text = text.."\n"..string.ToMinutesSeconds(self:GetNWInt("Production") - CurTime())
			end

			AddWorldTip(self:EntIndex(), text, 0.5, self:GetPos(), self)

			halo.Add({self}, color_white, 1, 1, 1, true, true)
		end
	end
end

if !SERVER then return end

ENT.SpawnTime = 0
ENT.IsSpawning = false

function ENT:Initialize()
	self:SetModel("models/props_lab/powerbox02b.mdl")
	self:PhysicsInit(SOLID_VPHYSICS)
	self:SetMoveType(MOVETYPE_VPHYSICS)
	self:SetSolid(SOLID_VPHYSICS)
	self:SetUseType(SIMPLE_USE)
	local phys = self:GetPhysicsObject()
	if IsValid(phys) then
		phys:Wake()
	end
end

function ENT:Use(activator)
	if activator:IsPlayer() and !self.IsSpawning then
		self:DelayedSpawn(self:GetDTInt(0))
	end
end

function ENT:StartTouch(ent)
	if !IsValid(ent) or ent:GetClass() != "spawned_money" or ent.USED or ent.hasMerged or ((ent.MP_NextTouch or 0) > CurTime()) then return end
	hook.Run("MoneyPot_ReceiveMoney", self, ent)
	ent.USED = true
	ent.hasMerged = true
	self:SetDTInt(0, self:GetDTInt(0) + ent:Getamount())
	ent:Remove()
end

function ENT:SpawnAmount(amount)
	amount = math.Clamp(amount, 0, self:GetDTInt(0))
	if (amount == 0) then return end
	local cash = ents.Create("spawned_money")
	if !IsValid(cash) then return end
	cash:SetPos(self:LocalToWorld(Vector(0, 0, 17)))
	cash:Setamount(amount)
	cash:Spawn()
	cash:Activate()
	cash.MP_NextTouch = CurTime() + 5
	self:SetDTInt(0, self:GetDTInt(0) - amount)
	self:SetNWInt("Production", 0)
	hook.Run("MoneyPot_SpawnMoney", self, cash, amount)
end

function ENT:DelayedSpawn(amount)
	amount = math.Clamp(amount, 0, self:GetDTInt(0))
	if (amount == 0) then return end
	self.SpawnTime = CurTime() + 1
	self.IsSpawning = true
end

function ENT:Think()
	if self:GetNWInt("Production") > 0 and self:GetNWInt("Production") < CurTime() then
		if self:GetDTInt(0) < self.ProductionMaxMoney then
			self:SetDTInt(0, math.ceil(math.min(self:GetDTInt(0) + (self:GetDTInt(0) * self.ProductionValue), self.ProductionMaxMoney)))
		end
		self:SetNWInt("Production", CurTime() + self.ProductionTime)
	end

	if !self.IsSpawning then return end
	if self.SpawnTime < CurTime() then
		self:SpawnAmount(self:GetDTInt(0))
		self.IsSpawning = false
		return
	end
	local ed = EffectData()
	ed:SetOrigin(self:GetPos())
	ed:SetMagnitude(1)
	ed:SetScale(1)
	ed:SetRadius(2)
	util.Effect("Sparks", ed, true, true)
end

function ENT:OnTakeDamage(dmginfo)
	self:TakePhysicsDamage(dmginfo)
end

function ENT:OnRemove()
	self:SpawnAmount(self:GetDTInt(0))
end

function MakeMoneyPot(ply, pos, ang)
	if !IsValid(ply) or !ply:CheckLimit("money_pots") then return end
	local money_pot = ents.Create("money_pot")
	if !IsValid(money_pot) then return false end
	money_pot:SetPos(pos)
	money_pot:SetAngles(ang)
	money_pot:Spawn()
	money_pot:SetPlayer(ply)
	ply:AddCount("money_pots", money_pot)
	ply:AddCleanup("money_pots", money_pot)
	DoPropSpawnedEffect(money_pot)
	return money_pot
end