local mg_ulxproperties = {
	["mg_ulxprop_copyid"] = {
		label = "SteamID kopieren",
		icon = "icon16/cut.png",
		order = 1,
		divider = false,
		adminonly = false,
		action = function(self, ent)
			SetClipboardText(ent:SteamID())
			LocalPlayer():ChatPrint(string.format("SteamID von %s (%s) kopiert.", ent:Name(), ent:SteamID()))
		end,
	},
	["mg_ulxprop_freeze"] = {
		label = "Freeze",
		icon = "icon16/hourglass.png",
		order = 3,
		divider = true,
		adminonly = true,
		action = function(self, ent)
			LocalPlayer():ConCommand("ulx freeze $"..ent:UserID())
		end,
	},
	["mg_ulxprop_unfreeze"] = {
		label = "Unfreeze",
		icon = "icon16/clock.png",
		order = 4,
		divider = false,
		adminonly = true,
		action = function(self, ent)
			LocalPlayer():ConCommand("ulx unfreeze $"..ent:UserID())
		end,
	},
	["mg_ulxprop_jail"] = {
		label = "Jail",
		icon = "icon16/link.png",
		order = 5,
		divider = false,
		adminonly = true,
		action = function(self, ent)
			LocalPlayer():ConCommand("ulx jail $"..ent:UserID())
		end,
	},
	["mg_ulxprop_unjail"] = {
		label = "Unjail",
		icon = "icon16/link_break.png",
		order = 6,
		divider = false,
		adminonly = true,
		action = function(self, ent)
			LocalPlayer():ConCommand("ulx unjail $"..ent:UserID())
		end,
	},
	["mg_ulxprop_return"] = {
		label = "Return",
		icon = "icon16/arrow_undo.png",
		order = 7,
		divider = true,
		adminonly = true,
		action = function(self, ent)
			LocalPlayer():ConCommand("ulx return $"..ent:UserID())
		end,
	},
	["mg_ulxprop_refund"] = {
		label = "Refund",
		icon = "icon16/money.png",
		order = 8,
		divider = false,
		adminonly = true,
		action = function(self, ent)
			LocalPlayer():ConCommand("ulx refund $"..ent:UserID())
		end,
	},
	["mg_ulxprop_unnlr"] = {
		label = "NLR entfernen",
		icon = "icon16/world.png",
		order = 9,
		divider = false,
		adminonly = true,
		action = function(self, ent)
			LocalPlayer():ConCommand("ulx unnlr $"..ent:UserID())
		end,
	},
	["mg_ulxprop_jailrules300"] = {
		label = "Regeln öffnen & Jail für 5 Minuten",
		icon = "icon16/layout.png",
		order = 10,
		divider = true,
		adminonly = true,
		action = function(self, ent)
			LocalPlayer():ConCommand("ulx openrules $"..ent:UserID().." 300")
			LocalPlayer():ConCommand("ulx jail $"..ent:UserID().." 300")
		end,
	},
	["mg_ulxprop_warnlist"] = {
		label = "Verwarnungen öffnen",
		icon = "icon16/chart_bar.png",
		order = 11,
		divider = true,
		adminonly = true,
		action = function(self, ent)
			LocalPlayer():ConCommand("warn_menu "..ent:UserID())
		end,
	},
	["mg_ulxprop_watchlist"] = {
		label = "Watchlist öffnen",
		icon = "icon16/chart_bar.png",
		order = 12,
		divider = false,
		adminonly = true,
		action = function(self, ent)
			LocalPlayer():ConCommand("ulx watchlist $"..ent:UserID())
		end,
	},
	["mg_ulxprop_banlist"] = {
		label = "Bannliste öffnen",
		icon = "icon16/chart_bar.png",
		order = 13,
		divider = false,
		adminonly = true,
		action = function(self, ent)
			LocalPlayer():ConCommand("ulx banlist $"..ent:UserID())
		end,
	}
}

for k, v in pairs(mg_ulxproperties) do
	properties.Add(k, {
		MenuLabel = v["label"],
		MenuIcon = v["icon"],
		Order = v["order"],
		PrependSpacer = v["divider"] and true or false,
		Filter = function(self, ent)
			if !IsValid(ent) or !ent:IsPlayer() then return false end
			if v["adminonly"] then
				if !LocalPlayer():IsAdmin() or ent:IsAdmin() then return false end
				return true
			else
				return true
			end
		end,
		Action = function(self, ent) 
			if !IsValid(ent) then return end
			v["action"](self, ent)
		end
	})
end