utime_total = utime_total or 0
utime_start = utime_start or 0

utime_total_draw = utime_total_draw or UTime_TimeToString(utime_total)
utime_session_draw = utime_session_draw or UTime_TimeToString(utime_start)

local surface, draw = surface, draw

local utime_enable = CreateClientConVar("utime_enable", 1, true, false)

local use_default = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("UTime_Default", {font = use_default, size = 16, weight = 1000})

local local_ply
local date = os.date("%d.%m.%y", os.time()).." / "..os.date("%X", os.time())
timer.Create("UTime_UpdateTime", 1, 0, function()
	date = os.date("%d.%m.%y", os.time()).." / "..os.date("%X", os.time())
	local_ply = LocalPlayer()
	if local_ply:IsValid() then
		utime_total_draw = UTime_TimeToString(local_ply:GetUTimeTotalTime())
		utime_session_draw = UTime_TimeToString(local_ply:GetUTimeSessionTime())
	end
end)

local local_ply
local box_color = Color(54, 54, 54, 150)
local function DrawUTime()
	if !utime_enable:GetBool() then return end

	local_ply = local_ply or LocalPlayer()

	local W, H = 260, 55
	local Border = 5
	local WPos = ScrW() - W - Border
	local HPos = Border
	surface.SetDrawColor(box_color)
	surface.DrawRect(WPos, HPos, W, H)
	surface.DrawRect(WPos - 2, HPos - 2, W + 4, H + 4)

	local pos = 4

	draw.SimpleText("Datum: "..date, "UTime_Default", WPos + W / 2, HPos + pos, color_cache_grey, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)

	pos = pos + 15

	draw.SimpleText("Gesamt: "..utime_total_draw, "UTime_Default", WPos + W / 2, HPos + pos, color_cache_grey, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)

	pos = pos + 15

	draw.SimpleText("Sitzung: "..utime_session_draw, "UTime_Default", WPos + W / 2, HPos + pos, color_cache_grey, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
end
hook.Add("HUDPaint", "UTime_DrawUTime", DrawUTime)