UTime = UTime or {}

function UTime.AskData(steamid)
	steamid = steamid or LocalPlayer():IsValid() and LocalPlayer():SteamID()

	if !steamid then return end

	net.Start("UTime.Data")
		net.WriteString(steamid)
	net.SendToServer()
end

local frame
net.Receive("UTime.Data", function()
	if IsValid(frame) then frame:Remove() end

	local name = net.ReadString()
	local data = net.ReadTable()

	frame = vgui.Create("DFrame")
	frame:SetTitle("Spielzeiten-Übersicht von "..name)
	frame:SetSize(600, 400)
	frame:Center()
	frame:MakePopup()
	frame.Paint = MG_Theme.Theme.Frame.Paint
	frame.PaintOver = MG_Theme.Theme.Frame.PaintOver

	local search = vgui.Create("DTextEntry", frame)
	search:SetSize(frame:GetWide() - 215, 20)
	search:SetPos(5, 30)
	search:SetPlaceholderText("Nach SteamID suchen... (Enter zum Bestätigen)")
	search:SetTextColor(color_white)

	search.OnEnter = function(self, text)
		text = string.upper(string.Trim(text))
		if text:match("^(STEAM_[0-9]+:[0-9]+:[0-9]+)$") then
			UTime.AskData(text)
		else
			chat.AddText(Color(255, 0, 0), "Das ist keine gültige SteamID!")
		end
	end

	MG_Theme.Theme.TextEntry.Setup(search)

	local button = vgui.Create("DButton", frame)
	button:SetSize(200, 20)
	button:SetPos(frame:GetWide() - 205, 30)
	button:SetText("Spieler auswählen...")
	button.DoClick = function()
		local menu = DermaMenu()
		menu.Paint = MG_Theme.Theme.DMenu.Paint

		for _, v in ipairs(player.GetAll()) do
			MG_Theme.Theme.DMenu.AddOption(menu, v:Name(), function()
				if !IsValid(v) then return end
				UTime.AskData(v:SteamID())
			end)
		end

		menu:Open()
	end

	MG_Theme.Theme.Button.SetupTheme(button)

	local listview = vgui.Create("DListView", frame)
	listview:SetSize(frame:GetWide() - 10, frame:GetTall() - 60)
	listview:SetPos(5, 55)
	listview:SetMultiSelect(false)

	listview:AddColumn(DarkRP and "Beruf" or PVP and "Klasse" or "Rolle")
	listview:AddColumn("Spielzeit")

	if DarkRP then
		for k, v in pairs(RPExtraTeams) do
			local name = team.GetName(k)
			listview:AddLine(name, UTime.TimeToString(data[v.command] or 0))
		end

		listview:AddLine("AFK", UTime.TimeToString(data["afk"] or 0))
	elseif PVP then
		for _, v in ipairs({"melon", "builder", "fighter"}) do
			listview:AddLine(v == "melon" and "Melone" or v == "builder" and "Builder" or "Fighter", UTime.TimeToString(data[v] or 0))
		end
	elseif CORPSE then
		for _, v in ipairs({"traitor", "detective", "innocent", "inactive"}) do
			listview:AddLine(v == "traitor" and "Traitor" or v == "detective" and "Detektiv" or v == "innocent" and "Innocent" or "Unbeteiligt", UTime.TimeToString(data[v] or 0))
		end
	end
	
	MG_Theme.Theme.ListView.SetupTheme(listview)
end)

hook.Add("OnPlayerChat", "UTime.Data", function(ply, text)
	local text = string.lower(text)
	if text == "!utime" then
		if ply != LocalPlayer() then return true end
		local steamid = string.upper(string.Trim(string.sub(text, 8, #text)))
		if !steamid or steamid == "" or steamid:match("^(STEAM_[0-9]+:[0-9]+:[0-9]+)$") then
			UTime.AskData(steamid and steamid != "" and steamid or ply:SteamID())
		else
			chat.AddText(Color(255, 0, 0), "Das ist keine gültige SteamID!")
		end
		return true
	end
end)