UTime = UTime or {}

local meta = FindMetaTable("Player")

function meta:GetUTime()
	return self:GetNWFloat("TotalUTime", 0)
end

function meta:GetUTimeStart()
	return self:GetNWFloat("UTimeStart", 0)
end

function meta:GetUTimeSessionTime()
	return CurTime() - self:GetUTimeStart()
end

function meta:GetUTimeTotalTime()
	return self:GetUTime() + CurTime() - self:GetUTimeStart()
end

function UTime.TimeToString(time)
	local tmp = math.floor(time)
	local s = tmp % 60
	tmp = math.floor(tmp / 60)
	local m = tmp % 60
	tmp = math.floor(tmp / 60)
	local h = tmp % 24
	tmp = math.floor(tmp / 24)
	local d = tmp % 7
	local w = math.floor(tmp / 7)
	return string.format("%02iw %id %02ih %02im %02is", w, math.min(d, 6), math.min(h, 23), math.min(m, 59), math.min(s, 59))
end

UTime_TimeToString = UTime.TimeToString