VoteMap = VoteMap or {}

local surface, draw = surface, draw

local showvotemap = CreateClientConVar("cl_showvotemap", 1, FCVAR_ARCHIVE)

local votemap_timeleft = 0
local votemap_votesleft = 0
local votemap_nextmap = ""
local votemap_done = false

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("VoteMap_Normal", {font = "Helvetica", size = 20, weight = 800})
surface.CreateFont("VoteMap_ScoreBoard", {font = use_font, size = 16, weight = 1000, antialias = true, additive = false})

usermessage.Hook("VoteMap_TimeLeft", function(um)
	votemap_timeleft = tonumber(um:ReadString())
	votemap_votesleft = um:ReadLong()
	votemap_nextmap = um:ReadString()
	votemap_done = um:ReadBool()
	timer.Create("VoteMap_TimeLeft", 1, 0, function()
		if votemap_timeleft > 0 then
			votemap_timeleft = votemap_timeleft - 1
		end
	end)
end)

local nxtmp_pre, votestr_pre, votelstr_pre, nxtmp_act, votestr_nxt = "Nächste Map: ", "Wechsel in: ", "Abstimmungen verbleibend: ", "Aktuelle Map: ", "Nächste Abstimmung: "
local str, nxtmp, votestr, votelstr
local w, h = 300, 60
local box_color, change_color, no_change_color = Color(0, 0, 0, 175), Color(255, 255, 225), Color(225, 255, 225)
local function VotemapHUD()
	if !showvotemap:GetBool() then return end
	str = VoteMap.TimeToString(votemap_timeleft)
	nxtmp = nxtmp_pre..votemap_nextmap
	votestr = votestr_pre..str
	votelstr = votelstr_pre..votemap_votesleft
	if !votemap_done then
		nxtmp = nxtmp_act..votemap_nextmap
		votestr = votestr_nxt..str
	end
	surface.SetFont("VoteMap_ScoreBoard")
	local mapsize = surface.GetTextSize(nxtmp)
	local votesize = surface.GetTextSize(votestr)
	local votelsize = surface.GetTextSize(votelstr)
	w = math.max(mapsize, votesize, votelsize) + 18
	local x, y = (ScrW() / 2) - (w / 2), ScrH() - h
	draw.RoundedBoxEx(4, x, y, w, h, box_color, true, true, false, false)
	draw.SimpleText(votestr, "VoteMap_ScoreBoard", x + w / 2, y + 5, votemap_done and change_color or no_change_color, TEXT_ALIGN_CENTER)
	draw.SimpleText(votelstr, "VoteMap_ScoreBoard", x + w / 2, y + 20, color_white, TEXT_ALIGN_CENTER)
	draw.SimpleText(nxtmp, "VoteMap_ScoreBoard", x + w / 2, y + 35, color_white, TEXT_ALIGN_CENTER)
end
hook.Add("HUDPaint", "VoteMap_HUD", VotemapHUD)

local votemap_maps = {}
local votemap_title = ""
local votemap_voted = false
local votemap_votecount = {}
local votemap_myvote = 0
local selected_color = Color(220, 221, 225, 230)
local function DrawVoteOptions()
	local maxwide = 0
	local y = 5
	local height = 0
	local maxheight = 20
	surface.SetFont("VoteMap_Normal")
	for _, v in pairs(votemap_maps) do
		local size, h = surface.GetTextSize(v)
		size = size + 22
		if size > maxwide then
			maxwide = size
		end
		height = h
		maxheight = maxheight + h + 3
	end
	surface.SetFont("VoteMap_Normal")
	local titlesize = surface.GetTextSize(votemap_title)
	if titlesize > maxwide then
		maxwide = titlesize
	end
	local wide = maxwide + 20
	local ypos = (ScrH() / 2) - (maxheight / 2)
	draw.RoundedBox(0, 5, ypos, wide, maxheight + 10, box_color)
	draw.RoundedBox(0, 3, ypos - 2, wide + 4, maxheight + 14, box_color)
	draw.DrawText(votemap_title, "VoteMap_Normal", 15, ypos + 0.5, nochange_color)
	y = y + 18
	for k, v in pairs(votemap_maps) do
		local votes = votemap_votecount[k] or 0
		local color = color_white
		if votemap_myvote == k then
			color = selected_color
		end
		draw.DrawText(v.." ("..votes..")", "VoteMap_Normal", 10, ypos + y, color, 0)
		y = y + height + 3
	end
end

net.Receive("VoteMap_UpdateVoteMap", function(len)
	votemap_votecount = net.ReadTable()
end)

net.Receive("VoteMap_StartVoteMap", function()
	local decoded = net.ReadTable()
	votemap_title = decoded.title
	local str = "%i: %s"
	for k, v in pairs(decoded.maps) do
		if v.ext then
			if (k == 10) then
				votemap_maps[k] = string.format("%i: %s", 0, v.map)
			else
				votemap_maps[k] = string.format("%i: %s", k, v.map)
			end
		else
			votemap_maps[k] = string.format(str, k, v.map)
		end
	end

	hook.Add("HUDPaint", "VoteMap_DrawVotes", DrawVoteOptions)

	timer.Simple(1, function()
		hook.Add("PlayerBindPress", "VoteMap_BindVoteButtons", function(ply, bind, pressed)
			if string.Left(bind, 4) == "slot" and pressed and !votemap_voted then
				local tbl = string.ToTable(bind)
				local votearg = tonumber(tbl[5])
				if !votearg then return end
				if (votearg == 0) then
					votearg = 10
				end
				if votearg != 0 and votearg <= table.Count(votemap_maps) then
					RunConsoleCommand("votemap_vote", votearg)
					votemap_voted = true
					votemap_myvote = votearg
				end
				return true
			end
		end)
	end)
end)

local function CloseVote()
	hook.Remove("HUDPaint", "VoteMap_DrawVotes")
	hook.Remove("PlayerBindPress", "VoteMap_BindVoteButtons")
	timer.Simple(1, function()
		hook.Remove("PlayerBindPress", "VoteMap_BindVoteButtons")
	end)
	votemap_maps = {}
	votemap_votecount = {}
	votemap_voted = false
	votemap_myvote = 0
end
usermessage.Hook("VoteMap_CloseVote", CloseVote)