MG_Warn = MG_Warn or {}

surface.CreateFont("WarnFont1", {font = "Arial", size = 16, weight = 600})

local function VoiceChatEnable(bool)
	if permissions and permissions.EnableVoiceChat then
		permissions.EnableVoiceChat(bool)
	else
		RunConsoleCommand((bool and "+" or "-").."voicerecord")
	end
end

local PlayerWarnFrame
local PlayerToOpen
function mg_warn_playerwarnmenu()
	if IsValid(PlayerWarnFrame) then PlayerWarnFrame:Close() end
	PlayerWarnFrame = vgui.Create("DFrame")
	PlayerWarnFrame:SetSize(380, 150)
	PlayerWarnFrame:Center()
	PlayerWarnFrame:SetVisible(true)
	PlayerWarnFrame:SetDraggable(true)
	PlayerWarnFrame:ShowCloseButton(true)
	PlayerWarnFrame:MakePopup()
	PlayerWarnFrame.Paint = MG_Theme.Theme.Frame.Paint
	PlayerWarnFrame.PaintOver = MG_Theme.Theme.Frame.PaintOver
	local MenuPanel = vgui.Create("DPanel", PlayerWarnFrame)
	MenuPanel:SetPos(5, 30)
	MenuPanel:SetSize(370, 115)
	MenuPanel.Paint = function()
	end
	local HiddenLabel = vgui.Create("DLabel", MenuPanel)
	HiddenLabel:SetPos(0, 0)
	HiddenLabel:SetColor(Color(255, 255, 255, 0))
	HiddenLabel:SetFont("WarnFont1")
	HiddenLabel:SetText(MG_Warn.activeplayer)
	HiddenLabel:SizeToContents()
	PlayerWarnFrame:SetTitle("Verwarnungsmenü: "..HiddenLabel:GetText())
	local MenuPanelLabel1 = vgui.Create("DLabel", MenuPanel)
	MenuPanelLabel1:SetPos(5, 5)
	MenuPanelLabel1:SetColor(Color(255, 255, 255, 255))
	MenuPanelLabel1:SetFont("WarnFont1")
	MenuPanelLabel1:SetText("Spieler: ")
	MenuPanelLabel1:SizeToContents()
	local MenuPanelLabel2 = vgui.Create("DLabel", MenuPanel)
	MenuPanelLabel2:SetPos(65, 5)
	MenuPanelLabel2:SetColor(Color(255, 50, 50, 255))
	MenuPanelLabel2:SetFont("WarnFont1")
	MenuPanelLabel2:SetText(HiddenLabel:GetText())
	MenuPanelLabel2:SizeToContents()
	local MenuPanelLabel3 = vgui.Create("DLabel", MenuPanel)
	MenuPanelLabel3:SetPos(5, 25)
	MenuPanelLabel3:SetColor(Color(255, 255, 255, 255))
	MenuPanelLabel3:SetFont("WarnFont1")
	MenuPanelLabel3:SetText("Grund:")
	MenuPanelLabel3:SizeToContents()
	local MenuPanelTextEntry1 = vgui.Create("DTextEntry", MenuPanel)
	MenuPanelTextEntry1:SetPos(5, 45)
	MenuPanelTextEntry1:SetMultiline(false)
	MenuPanelTextEntry1:SetSize(360, 25)
	MG_Theme.Theme.TextEntry.Setup(MenuPanelTextEntry1)
	local MenuPanelButton1 = vgui.Create("DButton", MenuPanel)
	MenuPanelButton1:SetSize(80, 30)
	MenuPanelButton1:SetPos(5, 80)
	MenuPanelButton1:SetText("Bestätigen")
	MenuPanelButton1.DoClick = function(MenuPanelButton1)
		if mg_warn_trywarn(HiddenLabel:GetText(), MenuPanelTextEntry1:GetValue()) then
			PlayerWarnFrame:Close()
		end
	end
	MG_Theme.Theme.Button.SetupTheme(MenuPanelButton1)
	local MenuPanelButton2 = vgui.Create("DButton", MenuPanel)
	MenuPanelButton2:SetSize(80, 30)
	MenuPanelButton2:SetPos(90, 80)
	MenuPanelButton2:SetText("Abbrechen")
	MenuPanelButton2.DoClick = function(MenuPanelButton2)
		PlayerWarnFrame:Close()
	end
	MG_Theme.Theme.Button.SetupTheme(MenuPanelButton2)
end

local OfflineMenuFrame
function mg_warn_offlineplayerprompt()
	if IsValid(OfflineMenuFrame) then OfflineMenuFrame:Close() end
	local ply = LocalPlayer()
	OfflineMenuFrame = vgui.Create("DFrame")
	OfflineMenuFrame:SetTitle("Nicht gelistete Spieler")
	OfflineMenuFrame:SetSize(300, 195)
	OfflineMenuFrame:Center()
	OfflineMenuFrame:SetVisible(true)
	OfflineMenuFrame:SetDraggable(true)
	OfflineMenuFrame:ShowCloseButton(true)
	OfflineMenuFrame:MakePopup()
	OfflineMenuFrame.Paint = MG_Theme.Theme.Frame.Paint
	OfflineMenuFrame.PaintOver = MG_Theme.Theme.Frame.PaintOver
	local MenuPanel = vgui.Create("DPanel", OfflineMenuFrame)
	MenuPanel:SetPos(5, 30)
	MenuPanel:SetSize(290, 160)
	MenuPanel.Paint = function()
	end
	local text = "SteamID eines Spielers:"
	surface.SetFont("WarnFont1")
	local x = surface.GetTextSize(text)
	local MenuPanelLabel1 = vgui.Create("DLabel", MenuPanel)
	MenuPanelLabel1:SetPos(140 - x / 2, 10)
	MenuPanelLabel1:SetColor(Color(255, 255, 255, 255))
	MenuPanelLabel1:SetFont("WarnFont1")
	MenuPanelLabel1:SetText("SteamID eines Spielers:")
	MenuPanelLabel1:SizeToContents()
	local MenuPanelTextEntry1 = vgui.Create("DTextEntry", MenuPanel)
	MenuPanelTextEntry1:SetPos(5, 30)
	MenuPanelTextEntry1:SetMultiline(false)
	MenuPanelTextEntry1:SetTall(25)
	MenuPanelTextEntry1:SetWidth(280)
	MG_Theme.Theme.TextEntry.Setup(MenuPanelTextEntry1)
	local MenuPanelButton1 = vgui.Create("DButton", MenuPanel)
	MenuPanelButton1:SetSize(80, 24)
	MenuPanelButton1:SetPos(5, 60)
	MenuPanelButton1:SetText("Öffnen")
	MenuPanelButton1.DoClick = function(MenuPanelButton1)
		if !IsValid(MG_Warn.MenuFrame) then
			mg_warn_menu()
		end
		net.Start("mg_warn_fetchwarns")
			net.WriteString(MenuPanelTextEntry1:GetValue())
			net.WriteString("id")
		net.SendToServer()
		if mg_warn_validate(MenuPanelTextEntry1:GetValue()) then
			MG_Warn.MenuFrame:SetTitle("Verwarnungsmenü: Verwarnungen von "..string.Trim(MenuPanelTextEntry1:GetValue()))
			MG_Warn.lastselected = MenuPanelTextEntry1:GetValue()
			MG_Warn.lastid = "id"
		end
	end
	MG_Theme.Theme.Button.SetupTheme(MenuPanelButton1)
	local MenuPanelButton2 = vgui.Create("DButton", MenuPanel)
	MenuPanelButton2:SetSize(80, 24)
	MenuPanelButton2:SetPos(90, 60)
	MenuPanelButton2:SetText("Verwarnen")
	MenuPanelButton2.DoClick = function(MenuPanelButton2)
		if !mg_warn_checkadmin_warn(ply) then
			ply:ChatPrint("Du hast keinen Zugriff auf diesen Befehl!")
			return
		end
		if mg_warn_validate(MenuPanelTextEntry1:GetValue()) then
			MG_Warn.activeplayer = mg_warn_validate(MenuPanelTextEntry1:GetValue())
			mg_warn_playerwarnmenu()
		else
			ply:PrintMessage(HUD_PRINTTALK, "Bitte gebe eine gültige SteamID an!")
		end
	end
	if !mg_warn_checkadmin_warn(ply) then
		MenuPanelButton2:SetDisabled(true)
	end
	MG_Theme.Theme.Button.SetupTheme(MenuPanelButton2)
	local MenuPanelButton3 = vgui.Create("DButton", MenuPanel)
	MenuPanelButton3:SetSize(280, 24)
	MenuPanelButton3:SetPos(5, 100)
	MenuPanelButton3:SetText("Aktive Verwarnungen reduzieren")
	MenuPanelButton3.DoClick = function(MenuPanelButton3)
		if !mg_warn_checkadmin_remove(ply) then
			ply:ChatPrint("Du hast keinen Zugriff auf diesen Befehl!")
			return
		end
		if mg_warn_validate(MenuPanelTextEntry1:GetValue()) then
			mg_warn_decreasewarn(MenuPanelTextEntry1:GetValue())
		else
			ply:PrintMessage(HUD_PRINTTALK, "Bitte gebe eine gültige SteamID an!")
		end
	end
	if !mg_warn_checkadmin_remove(ply) then
		MenuPanelButton3:SetDisabled(true)
	end
	MG_Theme.Theme.Button.SetupTheme(MenuPanelButton3)
	local MenuPanelButton4 = vgui.Create("DButton", MenuPanel)
	MenuPanelButton4:SetSize(280, 24)
	MenuPanelButton4:SetPos(5, 130)
	MenuPanelButton4:SetText("Alle Verwarnungen löschen")
	MenuPanelButton4.DoClick = function(MenuPanelButton4)
		if !mg_warn_checkadmin_deleteall(ply) then
			ply:ChatPrint("Du hast keinen Zugriff auf diesen Befehl!")
			return
		end
		if mg_warn_validate(MenuPanelTextEntry1:GetValue()) then
			mg_warn_deleteall(MenuPanelTextEntry1:GetValue())
			MG_Warn.MenuFrame:SetTitle("Verwarnungsmenü: Verwarnungen von "..string.Trim(MenuPanelTextEntry1:GetValue()))
			MG_Warn.MenuFrame.WarningsList:Clear()
			MG_Warn.playerinfo = {}
			MG_Warn.MenuFrame.MenuPanel2Text2:SetText("0")
			MG_Warn.MenuFrame.MenuPanel2Text4:SetText("0")
		else
			ply:PrintMessage(HUD_PRINTTALK, "Bitte gebe eine gültige SteamID an!")
		end
	end
	if !mg_warn_checkadmin_deleteall(ply) then
		MenuPanelButton4:SetDisabled(true)
	end
	MG_Theme.Theme.Button.SetupTheme(MenuPanelButton4)
	local MenuPanelButton5 = vgui.Create("DButton", MenuPanel)
	MenuPanelButton5:SetSize(80, 24)
	MenuPanelButton5:SetPos(205, 60)
	MenuPanelButton5:SetText("Schließen")
	MenuPanelButton5.DoClick = function(MenuPanelButton4)
		OfflineMenuFrame:Close()
	end
	MG_Theme.Theme.Button.SetupTheme(MenuPanelButton5)
end

local PlayerList
function mg_warn_menu()
	if IsValid(MG_Warn.MenuFrame) then return end
	local ply = LocalPlayer()
	MG_Warn.MenuFrame = vgui.Create("DFrame")
	MG_Warn.MenuFrame:SetSize(800, 595)
	MG_Warn.MenuFrame:Center()
	MG_Warn.MenuFrame:SetTitle("[MG] Verwarnungsmenü: Rechtsklick auf einen Spieler für mehr Optionen!")
	MG_Warn.MenuFrame:SetVisible(true)
	MG_Warn.MenuFrame:SetDraggable(true)
	MG_Warn.MenuFrame:ShowCloseButton(true)
	MG_Warn.MenuFrame:MakePopup()
	MG_Warn.MenuFrame.Think = function(self)
		if self.Closing then return end
		if !self.Communicating and input.IsKeyDown(input.GetKeyCode(input.LookupBinding("+voicerecord") or "") or KEY_X) then
			VoiceChatEnable(true)
			self.KeyUse = true
			self.Communicating = true
		end
		if self.Communicating and self.KeyUse and !input.IsKeyDown(input.GetKeyCode(input.LookupBinding("+voicerecord") or "") or KEY_X) then
			VoiceChatEnable(false)
			self.KeyUse = nil
			self.Communicating = nil
		end
	end
	MG_Warn.MenuFrame.OnClose = function(self)
		if IsValid(PlayerWarnFrame) then
			PlayerWarnFrame:Close()
		end
		if IsValid(OfflineMenuFrame) then
			OfflineMenuFrame:Close()
		end
		if self.Closing then return end
		self.Closing = true
		if self.Communicating then
			timer.Simple(0, function()
				VoiceChatEnable(false)
			end)
			self.Communicating = nil
		end
	end
	MG_Warn.MenuFrame.Paint = MG_Theme.Theme.Frame.Paint
	MG_Warn.MenuFrame.PaintOver = MG_Theme.Theme.Frame.PaintOver
	local MenuPanel = vgui.Create("DPanel", MG_Warn.MenuFrame)
	MenuPanel:SetPos(10, 35)
	MenuPanel:SetSize(780, 510)
	MenuPanel.Paint = function()
	end
	local MenuPanel2 = vgui.Create("DPanel", MG_Warn.MenuFrame)
	MenuPanel2:SetPos(10, 550)
	MenuPanel2:SetSize(780, 35)
	MenuPanel2.Paint = function()
	end
	local MenuPanel2Text1 = vgui.Create("DLabel", MenuPanel2)
	MenuPanel2Text1:SetPos(5, 2)
	MenuPanel2Text1:SetColor(Color(255, 50, 50, 255))
	MenuPanel2Text1:SetFont("WarnFont1")
	MenuPanel2Text1:SetText("Aktive Verwarnungen: ")
	MenuPanel2Text1:SizeToContents()
	MG_Warn.MenuFrame.MenuPanel2Text2 = vgui.Create("DLabel", MenuPanel2)
	MG_Warn.MenuFrame.MenuPanel2Text2:SetPos(5, 2)
	MG_Warn.MenuFrame.MenuPanel2Text2:SetColor(Color(255, 200, 200, 255))
	MG_Warn.MenuFrame.MenuPanel2Text2:SetFont("WarnFont1")
	MG_Warn.MenuFrame.MenuPanel2Text2:SetText("0")
	MG_Warn.MenuFrame.MenuPanel2Text2:SizeToContents()
	MG_Warn.MenuFrame.MenuPanel2Text2:MoveRightOf(MenuPanel2Text1)
	local MenuPanel2Text3 = vgui.Create("DLabel", MenuPanel2)
	MenuPanel2Text3:SetPos(5, 17)
	MenuPanel2Text3:SetColor(Color(255, 50, 50, 255))
	MenuPanel2Text3:SetFont("WarnFont1")
	MenuPanel2Text3:SetText("Gesamte Verwarnungen: ")
	MenuPanel2Text3:SizeToContents()
	MG_Warn.MenuFrame.MenuPanel2Text4 = vgui.Create("DLabel", MenuPanel2)
	MG_Warn.MenuFrame.MenuPanel2Text4:SetPos(5, 17)
	MG_Warn.MenuFrame.MenuPanel2Text4:SetColor(Color(255, 200, 200, 255))
	MG_Warn.MenuFrame.MenuPanel2Text4:SetFont("WarnFont1")
	MG_Warn.MenuFrame.MenuPanel2Text4:SetText("0")
	MG_Warn.MenuFrame.MenuPanel2Text4:SizeToContents()
	MG_Warn.MenuFrame.MenuPanel2Text4:MoveRightOf(MenuPanel2Text3)
	local MenuPanel2Button1 = vgui.Create("DButton", MenuPanel2)
	MenuPanel2Button1:SetSize(140, 25)
	MenuPanel2Button1:SetPos(630, 5)
	MenuPanel2Button1:SetText("Nicht gelistete Spieler")
	MG_Theme.Theme.Button.SetupTheme(MenuPanel2Button1)
	MenuPanel2Button1:SetTextColor(MG_Theme.Theme:GetUserColor())
	MenuPanel2Button1.DoClick = function(MenuPanel2Button2)
		mg_warn_offlineplayerprompt()
	end
	MG_Warn.MenuFrame.WarningsList = vgui.Create("DListView", MenuPanel)
	MG_Warn.MenuFrame.WarningsList:SetPos(5, 5)
	MG_Warn.MenuFrame.WarningsList:SetSize(565, 500)
	MG_Warn.MenuFrame.WarningsList:SetMultiSelect(false)
	MG_Warn.MenuFrame.WarningsList:AddColumn("ID"):SetFixedWidth(40)
	MG_Warn.MenuFrame.WarningsList:AddColumn("Ausführender Admin"):SetFixedWidth(175)
	MG_Warn.MenuFrame.WarningsList:AddColumn("Grund"):SetFixedWidth(190)
	MG_Warn.MenuFrame.WarningsList:AddColumn("Datum"):SetFixedWidth(160)
	MG_Warn.MenuFrame.WarningsList.OnRowRightClick = function(PlayerList, line)
		local DropDown = DermaMenu()
		MG_Theme.Theme.DMenu.Setup(DropDown)
		DropDown:AddOption("Verwarnungsgrund kopieren", function()
			local reason = MG_Warn.MenuFrame.WarningsList:GetLine(line):GetValue(3)
			SetClipboardText(reason)
			ply:ChatPrint("Verwarnungsgrund ("..reason..") kopiert.")
		end)
		if mg_warn_checkadmin_edit(ply) then
			DropDown:AddOption("Verwarnungsgrund editieren", function()
				if !mg_warn_checkadmin_edit(ply) then
					ply:ChatPrint("Du hast keinen Zugriff auf diesen Befehl!")
					return
				end
				local warning = MG_Warn.MenuFrame.WarningsList:GetLine(line):GetValue(1)
				local reason = MG_Warn.MenuFrame.WarningsList:GetLine(line):GetValue(3)
				Derma_StringRequest("Verwarnung editieren", "Füge hier den neuen Grund der Verwarnung ein.", reason, function(text)
					if string.Trim(text) == "" then
						ply:ChatPrint("Du musst einen Grund angeben!")
						return
					elseif #text > 100 then
						ply:ChatPrint("Der Grund muss unter 100 Zeichen liegen!")
						return
					end
					net.Start("mg_warn_editwarn")
						net.WriteUInt(warning, 32)
						net.WriteString(text)
					net.SendToServer()
					if IsValid(MG_Warn.MenuFrame) and IsValid(MG_Warn.MenuFrame.WarningsList) then
						local line = MG_Warn.MenuFrame.WarningsList:GetLine(line)
						if IsValid(line) then
							line:SetColumnText(text)
						end
					end
				end, nil, "Übernehmen", "Zurück")
			end)
		end
		if mg_warn_checkadmin_delete(ply) then
			DropDown:AddSpacer()
			DropDown:AddOption("Verwarnung löschen", function()
				if !mg_warn_checkadmin_delete(ply) then
					ply:ChatPrint("Du hast keinen Zugriff auf diesen Befehl!")
					return
				end
				local warning = MG_Warn.MenuFrame.WarningsList:GetLine(line):GetValue(1)
				net.Start("mg_warn_deletewarn")
					net.WriteUInt(warning, 32)
				net.SendToServer()
				MG_Warn.MenuFrame.WarningsList:RemoveLine(line)
				MG_Warn.MenuFrame.MenuPanel2Text4:SetText(MG_Warn.MenuFrame.MenuPanel2Text4:GetText() - 1)
				if tonumber(MG_Warn.MenuFrame.MenuPanel2Text4:GetText()) < tonumber(MG_Warn.MenuFrame.MenuPanel2Text2:GetText()) then
					MG_Warn.MenuFrame.MenuPanel2Text2:SetText(MG_Warn.MenuFrame.MenuPanel2Text2:GetText() - 1)
				end
			end)
		end
		DropDown:Open()
	end
	MG_Theme.Theme.ListView.SetupTheme(MG_Warn.MenuFrame.WarningsList)
	PlayerList = vgui.Create("DListView", MenuPanel)
	PlayerList:SetPos(575, 5)
	PlayerList:SetSize(200, 500)
	PlayerList:SetMultiSelect(false)
	PlayerList:AddColumn("Spielername")
	PlayerList.OnRowSelected = function(PlayerList, line)
		MG_Warn.MenuFrame:SetTitle("[MG] Verwarnungsmenü: Verwarnungen von "..tostring(PlayerList:GetLine(line):GetValue(1)))
		MG_Warn.MenuFrame.WarningsList:Clear()
		net.Start("mg_warn_fetchwarns")
			net.WriteString(tostring(PlayerList:GetLine(line):GetValue(1)))
		net.SendToServer()
		MG_Warn.lastselected = tostring(PlayerList:GetLine(line):GetValue(1))
		MG_Warn.lastid = nil
	end
	PlayerList.OnRowRightClick = function(PlayerList, line)
		local open
		local DropDown = DermaMenu()
		MG_Theme.Theme.DMenu.Setup(DropDown)
		if mg_warn_checkadmin_warn(ply) then
			open = true
			DropDown:AddOption("Verwarnen", function()
				if !mg_warn_checkadmin_warn(ply) then
					ply:ChatPrint("Du hast keinen Zugriff auf diesen Befehl!")
					return
				end
				MG_Warn.activeplayer = PlayerList:GetLine(line):GetValue(1)
				mg_warn_playerwarnmenu()
			end)
		end
		if mg_warn_checkadmin_remove(ply) then
			open = true
			DropDown:AddOption("Aktive Verwarnungen reduzieren", function()
				if !mg_warn_checkadmin_remove(ply) then
					ply:ChatPrint("Du hast keinen Zugriff auf diesen Befehl!")
					return
				end
				mg_warn_decreasewarn(PlayerList:GetLine(line):GetValue(1))
				MG_Warn.MenuFrame.MenuPanel2Text2:SetText(math.max(0, MG_Warn.MenuFrame.MenuPanel2Text2:GetText() - 1))
			end)
		end
		DropDown:AddSpacer()
		if mg_warn_checkadmin_deleteall(ply) then
			open = true
			DropDown:AddOption("Alle Verwarnungen löschen", function()
				if !mg_warn_checkadmin_deleteall(ply) then
					ply:ChatPrint("Du hast keinen Zugriff auf diesen Befehl!")
					return
				end
				MG_Warn.MenuFrame.WarningsList:Clear()
				MG_Warn.playerinfo = {} 
				mg_warn_deleteall(PlayerList:GetLine(line):GetValue(1))
				MG_Warn.MenuFrame.MenuPanel2Text2:SetText("0")
				MG_Warn.MenuFrame.MenuPanel2Text4:SetText("0")
			end)
		end
		if open then
			DropDown:Open()
		else
			DropDown:Remove()
		end
		MG_Warn.lastselected = tostring(PlayerList:GetLine(line):GetValue(1))
	end
	local players = player.GetAll()
	table.sort(players, function(a, b) return a:Name() < b:Name() end)
	for _, v in ipairs(players) do		
		if PlayerToOpen and tonumber(PlayerToOpen) == v:UserID() then			
			PlayerList:SelectItem(PlayerList:AddLine(v:Name()))
		else
			PlayerList:AddLine(v:Name())
		end
	end
	PlayerToOpen = nil
	MG_Theme.Theme.ListView.SetupTheme(PlayerList)
end

function mg_warn_clientmenu()
	if IsValid(MG_Warn.ClientMenuFrame) then MG_Warn.ClientMenuFrame:Close() end
	MG_Warn.ClientMenuFrame = vgui.Create("DFrame")
	MG_Warn.ClientMenuFrame:SetSize(800, 595)
	MG_Warn.ClientMenuFrame:Center()
	MG_Warn.ClientMenuFrame:SetTitle("[MG] Verwarnungsmenü: Deine Verwarnungen")
	MG_Warn.ClientMenuFrame:SetVisible(true)
	MG_Warn.ClientMenuFrame:SetDraggable(true)
	MG_Warn.ClientMenuFrame:ShowCloseButton(true)
	MG_Warn.ClientMenuFrame:MakePopup()
	MG_Warn.ClientMenuFrame.Paint = MG_Theme.Theme.Frame.Paint
	MG_Warn.ClientMenuFrame.PaintOver = MG_Theme.Theme.Frame.PaintOver
	local MenuPanel = vgui.Create("DPanel", MG_Warn.ClientMenuFrame)
	MenuPanel:SetPos(10, 35)
	MenuPanel:SetSize(780, 510)
	MenuPanel.Paint = function()
	end
	local MenuPanel2 = vgui.Create("DPanel", MG_Warn.ClientMenuFrame)
	MenuPanel2:SetPos(10, 550)
	MenuPanel2:SetSize(780, 35)
	MenuPanel2.Paint = function()
	end
	local MenuPanel2Text1 = vgui.Create("DLabel", MenuPanel2)
	MenuPanel2Text1:SetPos(5, 2)
	MenuPanel2Text1:SetColor(Color(255, 50, 50, 255))
	MenuPanel2Text1:SetFont("WarnFont1")
	MenuPanel2Text1:SetText("Deine aktiven Verwarnungen: ")
	MenuPanel2Text1:SizeToContents()
	MG_Warn.ClientMenuFrame.MenuPanel2Text2 = vgui.Create("DLabel", MenuPanel2)
	MG_Warn.ClientMenuFrame.MenuPanel2Text2:SetPos(5, 2)
	MG_Warn.ClientMenuFrame.MenuPanel2Text2:SetColor(Color(255, 200, 200, 255))
	MG_Warn.ClientMenuFrame.MenuPanel2Text2:SetFont("WarnFont1")
	MG_Warn.ClientMenuFrame.MenuPanel2Text2:SetText("0")
	MG_Warn.ClientMenuFrame.MenuPanel2Text2:SizeToContents()
	MG_Warn.ClientMenuFrame.MenuPanel2Text2:MoveRightOf(MenuPanel2Text1)
	local MenuPanel2Text3 = vgui.Create("DLabel", MenuPanel2)
	MenuPanel2Text3:SetPos(5, 17)
	MenuPanel2Text3:SetColor(Color(255, 50, 50, 255))
	MenuPanel2Text3:SetFont("WarnFont1")
	MenuPanel2Text3:SetText("Deine gesamten Verwarnungen: ")
	MenuPanel2Text3:SizeToContents()
	MG_Warn.ClientMenuFrame.MenuPanel2Text4 = vgui.Create("DLabel", MenuPanel2)
	MG_Warn.ClientMenuFrame.MenuPanel2Text4:SetPos(5, 17)
	MG_Warn.ClientMenuFrame.MenuPanel2Text4:SetColor(Color(255, 200, 200, 255))
	MG_Warn.ClientMenuFrame.MenuPanel2Text4:SetFont("WarnFont1")
	MG_Warn.ClientMenuFrame.MenuPanel2Text4:SetText("0")
	MG_Warn.ClientMenuFrame.MenuPanel2Text4:SizeToContents()
	MG_Warn.ClientMenuFrame.MenuPanel2Text4:MoveRightOf(MenuPanel2Text3)
	MG_Warn.ClientMenuFrame.WarningsList = vgui.Create("DListView", MenuPanel)
	MG_Warn.ClientMenuFrame.WarningsList:SetPos(5, 5)
	MG_Warn.ClientMenuFrame.WarningsList:SetSize(770, 500)
	MG_Warn.ClientMenuFrame.WarningsList:SetMultiSelect(false)
	MG_Warn.ClientMenuFrame.WarningsList:AddColumn("Ausführender Admin"):SetFixedWidth(260)
	MG_Warn.ClientMenuFrame.WarningsList:AddColumn("Grund"):SetFixedWidth(360)
	MG_Warn.ClientMenuFrame.WarningsList:AddColumn("Datum"):SetFixedWidth(150)
	MG_Theme.Theme.ListView.SetupTheme(MG_Warn.ClientMenuFrame.WarningsList)
	net.Start("mg_warn_fetchownwarns")
	net.SendToServer()
end

net.Receive("mg_warn_sendplayerwarns", function(length)
	MG_Warn.playerinfo = net.ReadTable()
	MG_Warn.playerwarns = net.ReadUInt(32)
	if IsValid(MG_Warn.MenuFrame) then
		if MG_Warn.playerinfo then
			MG_Warn.MenuFrame.WarningsList:Clear()
			table.sort(MG_Warn.playerinfo, function(a, b) return tonumber(a.pid) > tonumber(b.pid) end)
			for _, v in ipairs(MG_Warn.playerinfo) do
				MG_Warn.MenuFrame.WarningsList:AddLine(v.pid, v.admin, v.reason, os.date("%X, %d.%m.%Y", tonumber(v.date)))
			end
			MG_Warn.MenuFrame.MenuPanel2Text4:SetText(#MG_Warn.playerinfo)
			MG_Warn.MenuFrame.MenuPanel2Text4:SizeToContents()
			MG_Theme.Theme.ListView.SetupTheme(MG_Warn.MenuFrame.WarningsList)
		end
		if MG_Warn.playerwarns then
			MG_Warn.MenuFrame.MenuPanel2Text2:SetText(MG_Warn.playerwarns)
			MG_Warn.MenuFrame.MenuPanel2Text2:SizeToContents()
		end
	end
end)

net.Receive("mg_warn_sendownwarns", function(length)
	MG_Warn.ownplayerinfo = net.ReadTable()
	MG_Warn.ownplayerwarns = net.ReadUInt(32)
	if IsValid(MG_Warn.ClientMenuFrame) then
		if MG_Warn.ownplayerinfo then
			MG_Warn.ClientMenuFrame.WarningsList:Clear()
			table.sort(MG_Warn.ownplayerinfo, function(a, b) return tonumber(a.pid) > tonumber(b.pid) end)
			for _, v in ipairs(MG_Warn.ownplayerinfo) do
				MG_Warn.ClientMenuFrame.WarningsList:AddLine(v.admin, v.reason, os.date("%X, %d.%m.%Y", tonumber(v.date)))
			end
			MG_Warn.ClientMenuFrame.MenuPanel2Text4:SetText(#MG_Warn.ownplayerinfo)
			MG_Warn.ClientMenuFrame.MenuPanel2Text4:SizeToContents()
			MG_Theme.Theme.ListView.SetupTheme(MG_Warn.ClientMenuFrame.WarningsList)
		end
		if MG_Warn.ownplayerwarns then
			MG_Warn.ClientMenuFrame.MenuPanel2Text2:SetText(MG_Warn.ownplayerwarns)
			MG_Warn.ClientMenuFrame.MenuPanel2Text2:SizeToContents()
		end
	end
end)

net.Receive("mg_warn_openupmenu", function(length)
	if !IsValid(MG_Warn.MenuFrame) then
		mg_warn_menu()
	end
end)

net.Receive("mg_warn_openupclientmenu", function(length)
	if !IsValid(MG_Warn.ClientMenuFrame) then
		mg_warn_clientmenu()
	end
end)

net.Receive("mg_warn_addnotification", function(length)
	local admin = net.ReadEntity()
	local target = net.ReadEntity()
	local reason = net.ReadString()
	if !IsValid(target) then return end
	chat.AddText(Color(60, 60, 60), "[", Color(30, 90, 150), "Verwarnungssystem", Color(60, 60, 60), "] ", (IsValid(admin) and (CORPSE and Color(255, 255, 150) or team.GetColor(admin:Team())) or Color(100, 100, 100)), (IsValid(admin) and admin:Name() or "Die Konsole"), Color(255, 255, 255), " hat ", (CORPSE and Color(255, 255, 150) or team.GetColor(target:Team())), tostring(target:Name()), Color(255, 255, 255), " mit dem Grund \"", Color(150, 40, 40), reason, Color(255, 255, 255), "\" verwarnt.")
end)

net.Receive("mg_warn_addnotification2", function(length)
	local admin = net.ReadEntity()
	local target = net.ReadString()
	local reason = net.ReadString()
	chat.AddText(Color(60, 60, 60), "[", Color(30, 90, 150), "Verwarnungssystem", Color(60, 60, 60), "] ", (IsValid(admin) and (CORPSE and Color(255, 255, 150) or team.GetColor(admin:Team())) or Color(100, 100, 100)), (IsValid(admin) and admin:Name() or "Die Konsole"), Color(255, 255, 255), " hat ", Color(255, 0, 0), target, Color(255, 255, 255), " mit dem Grund \"", Color(150, 40, 40), reason, Color(255, 255, 255), "\" verwarnt.")
end)

net.Receive("mg_warn_addchatmessage", function(length)
	local message = net.ReadTable()
	chat.AddText(unpack(message))
end)

concommand.Add("warn_menu", function(ply, _, _, args)
	PlayerToOpen = args
	net.Start("mg_warn_openmenu")
	net.SendToServer()
end)

function mg_warn_trywarn(tar, reason)
	local ply = LocalPlayer()
	if !tar then
		ply:PrintMessage(HUD_PRINTTALK, "Du musst entweder einen Namen oder eine SteamID angeben!")
		return false
	end
	local validate = mg_warn_validate(tar)
	if validate then
		local tid = validate
		if #tid == 7 then
			ply:PrintMessage(HUD_PRINTTALK, "Achte darauf, dass die SteamID in Anführungszeichen steht!")
			return false
		end
		tar = player.GetBySteamID(tid)
		if tar then
			if reason != "" and reason != nil then
				net.Start("mg_warn_warn")
					net.WriteEntity(tar)
					net.WriteString(reason)
				net.SendToServer()
				return true
			else
				ply:PrintMessage(HUD_PRINTTALK, "Du musst einen Grund angeben!")
				return false
			end
		end
		if reason != "" and reason != nil then
			net.Start("mg_warn_warnid")
				net.WriteString(tid)
				net.WriteString(reason)
			net.SendToServer()
			return true
		else
			ply:PrintMessage(HUD_PRINTTALK, "Du musst einen Grund angeben!")
			return false
		end
	end
	local user = mg_warn_getuser(tar)
	if user then
		if reason != nil and reason != ""then
			tar = user
			net.Start("mg_warn_warn")
				net.WriteEntity(tar)
				net.WriteString(reason)
			net.SendToServer()
			return true
		else
			ply:PrintMessage(HUD_PRINTTALK, "Du musst einen Grund angeben!")
			return false
		end
	else
		ply:PrintMessage(HUD_PRINTTALK, "Spieler/SteamID konnte nicht gefunden werden!")
		return false
	end
end

function mg_warn_deleteall(tar)
	local ply = LocalPlayer()
	if !tar then
		ply:PrintMessage(HUD_PRINTTALK, "Du musst entweder einen Namen oder eine SteamID angeben!")
		return
	end
	local validate = mg_warn_validate(tar)
	if validate then
		local tid = validate
		if #tid == 7 then
			ply:PrintMessage(HUD_PRINTTALK, "Achte darauf, dass die SteamID in Anführungszeichen steht!")
			return
		end
		local ply = player.GetBySteamID(tid)
		if ply then
			tar = mg_warn_getuser(tar)
			net.Start("mg_warn_deletewarns")
				net.WriteString(tar)
			net.SendToServer()
			return
		end
		net.Start("mg_warn_deletewarnsid")
			net.WriteString(tid)
		net.SendToServer()
		return
	end
	local user = mg_warn_getuser(tar)
	if user then
		net.Start("mg_warn_deletewarns")
			net.WriteString(tar)
		net.SendToServer()
	else
		ply:PrintMessage(HUD_PRINTTALK, "Spieler/SteamID konnte nicht gefunden werden!")
	end
end

function mg_warn_decreasewarn(tar)
	local ply = LocalPlayer()
	if !tar then
		ply:PrintMessage(HUD_PRINTTALK, "Du musst entweder einen Namen oder eine SteamID angeben!")
		return
	end
	local validate = mg_warn_validate(tar)
	if validate then
		local tid = validate
		if #tid == 7 then
			ply:PrintMessage(HUD_PRINTTALK, "Achte darauf, dass die SteamID in Anführungszeichen steht!")
			return
		end
		local ply = player.GetBySteamID(tid)
		if ply then
			net.Start("mg_warn_removewarn")
				net.WriteString(tar)
			net.SendToServer()
			return
		end
		net.Start("mg_warn_removewarnid")
			net.WriteString(tid)
		net.SendToServer()
		return
	end
	local user = mg_warn_getuser(tar)
	if user then
		net.Start("mg_warn_removewarn")
			net.WriteString(tar)
		net.SendToServer()
	else
		ply:PrintMessage(HUD_PRINTTALK, "Spieler/SteamID konnte nicht gefunden werden!")
	end
end