if SERVER then
	hook.Add("InitPostEntity", "MG_Warn_ULXCompatability", function()
		if ULib then
			ULib.ucl.registerAccess("warn_view", ULib.ACCESS_ADMIN, "Ability to view other player's warnings.", "Warn")
			ULib.ucl.registerAccess("warn_warn", ULib.ACCESS_ADMIN, "Ability to warn players.", "Warn")
			ULib.ucl.registerAccess("warn_edit", ULib.ACCESS_SUPERADMIN, "Ability to edit warns of a player.", "Warn")
			ULib.ucl.registerAccess("warn_remove", ULib.ACCESS_ADMIN, "Ability to reduce a player's active warnings.", "Warn")
			ULib.ucl.registerAccess("warn_delete", ULib.ACCESS_SUPERADMIN, "Ability to delete seperate warnings.", "Warn")
			ULib.ucl.registerAccess("warn_deleteall", ULib.ACCESS_SUPERADMIN, "Ability to delete a player's warning data entirely.", "Warn")
		end
	end)
end

function mg_warn_checkadmin_view(self)
	if !IsValid(self) then return false end
	if ULib then
		if ULib.ucl.query(self, "warn_view") then return true end
	end
	return false
end

function mg_warn_checkadmin_warn(self, target)
	if !IsValid(self) then return true end
	if IsValid(target) and target:IsAdmin() and !self:IsSuperAdmin() then return false end
	if ULib then
		if ULib.ucl.query(self, "warn_warn") then return true end
	end
	return false
end

function mg_warn_checkadmin_edit(self, target)
	if !IsValid(self) then return true end
	if IsValid(target) and target:IsAdmin() and !self:IsSuperAdmin() then return false end
	if ULib then
		if ULib.ucl.query(self, "warn_edit") then return true end
	end
	return false
end

function mg_warn_checkadmin_remove(self)
	if !IsValid(self) then return true end
	if ULib then
		if ULib.ucl.query(self, "warn_remove") then return true end
	end
	return false
end

function mg_warn_checkadmin_delete(self)
	if !IsValid(self) then return true end
	if ULib then
		if ULib.ucl.query(self, "warn_delete") then return true end
	end
	return false
end

function mg_warn_checkadmin_deleteall(self)
	if !IsValid(self) then return true end
	if ULib then
		if ULib.ucl.query(self, "warn_deleteall") then return true end
	end
	return false
end

if SERVER then
	concommand.Add("warn", function(ply, _, args)
		if !IsValid(ply) then
			mg_warn_trywarn(args[1], args[2], NULL)
		else
			mg_warn_sendmessage(ply, "Du hast keinen Zugriff auf diesen Befehl!")
		end
	end)

	concommand.Add("warn_remove", function(ply, _, args)
		if !IsValid(ply) then
			mg_warn_deleteall(args[1])
		else
			mg_warn_sendmessage(ply, "Du hast keinen Zugriff auf diesen Befehl!")
		end
	end)

	concommand.Add("warn_decrease", function(ply, _, args)
		if !IsValid(ply) then
			mg_warn_decreasewarn(args[1])
		else
			mg_warn_sendmessage(ply, "Du hast keinen Zugriff auf diesen Befehl!")
		end
	end)
end

function mg_warn_getuser(target)
	local players = player.GetAll()
	target = target:lower()
	local ply_match
	for _, player in ipairs(players) do
		if target == player:Name():lower() then
			if !ply_match then
				return player
			else
				return false
			end
		end
	end
	for _, player in ipairs(players) do
		local name_match
		if player:Name():lower():find(target, 1, true) then
			name_match = player
		end
		if ply_match and name_match then
			return false
		end
		if name_match then
			ply_match = name_match
		end
	end
	if !ply_match then
		return false
	end
	return ply_match
end

function mg_warn_validate(id)
	id = string.upper(string.Trim(id))
	if id:match("^(STEAM_[0-9]+:[0-9]+:[0-9]+)$") then
		return id
	else
		return false
	end
end