include("wars/sh_config.lua")

surface.CreateFont("r_teams", {font = "Roboto", size = 20, antialias = true, weight = 500})
surface.CreateFont("r_counter1", {font = "Roboto", size = 19, antialias = true, weight = 500})
surface.CreateFont("r_counter2", {font = "Roboto", size = 18, antialias = true, weight = 500})

local PANEL = {}
function PANEL:Init()
	self:SetSize(500, 165)
	self:MakePopup()
	self:Center()
	self:ParentToHUD()
	self:SetTitle("Kriegsanfrage")
	self:ShowCloseButton(false)
	self.Paint = MG_Theme.Theme.Frame.Paint
	self.PaintOver = MG_Theme.Theme.Frame.PaintOver
	local Close = vgui.Create("DButton", self)
	Close:SetSize(50, 20)
	Close:SetPos(self:GetWide() - 52, 2)
	Close:SetText("X")
	Close:SetFont("MG_Theme_Close")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 100, 100)
		else
			col = Color(200, 50, 50)
		end
		draw.RoundedBox(4, 0, 0, w, h, col)
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		self:Remove()
	end
	self.Model = self:Add("DModelPanel")
	self.Model:SetSize(64, 64)
	self.Model:SetPos(5, 30)
	self.Model.LayoutEntity = function()
	end
	self.Model:SetFOV(35)
	self.Model:SetCamPos(Vector(30, -7, 55))
	self.Model:SetLookAt(Vector(0, 0, 65))
	self.Label = self:Add("DLabel")
	self.Label:SetPos(74, 30)
	self.Label:SetHeight(30)
	self.Label:SetSize(400, 64)
	self.DisagreeBtn = self:Add("DButton")
	self.DisagreeBtn:SetHeight(30)
	self.DisagreeBtn:SetText("Ablehnen")
	self.DisagreeBtn.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		net.Start("r_accept")
			net.WriteBit(false)
		net.SendToServer()
		self:Remove()
	end
	MG_Theme.Theme.Button.SetupTheme(self.DisagreeBtn)
	self.AgreeBtn = self:Add("DButton")
	self.AgreeBtn:SetHeight(30)
	self.AgreeBtn:SetText("Akzeptieren")
	self.AgreeBtn.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		net.Start("r_accept")
			net.WriteBit(true)
		net.SendToServer()
		self:Remove()
	end
	MG_Theme.Theme.Button.SetupTheme(self.AgreeBtn)
	self.AgreeBtn:Dock(BOTTOM)
	self.DisagreeBtn:Dock(BOTTOM)
end
vgui.Register("WarRequest", PANEL, "DFrame")

local r_accept_window
local function ShowAcceptWindow(text, ent)
	if !IsValid(ent) or IsValid(r_accept_window) then return end
	r_accept_window = vgui.Create("WarRequest")
	r_accept_window.Label:SetText(text or "Fehler 404")
	r_accept_window.Model:SetModel(ent:GetModel())
end

net.Receive("r_show", function()
	ShowAcceptWindow(net.ReadString(), net.ReadEntity())
end)

local PANEL = {}
function PANEL:Init()
	self:SetSize(300, 260)
	self:MakePopup()
	self:Center()
	self:ParentToHUD()
	self:SetTitle("Bandenkrieg: Gegnerauswahl")
	self:ShowCloseButton(false)
	self.Paint = MG_Theme.Theme.Frame.Paint
	self.PaintOver = MG_Theme.Theme.Frame.PaintOver
	local Close = vgui.Create("DButton", self)
	Close:SetSize(50, 20)
	Close:SetPos(self:GetWide() - 52, 2)
	Close:SetText("X")
	Close:SetFont("MG_Theme_Close")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 100, 100)
		else
			col = Color(200, 50, 50)
		end
		draw.RoundedBox(4, 0, 0, w, h, col)
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		self:Remove()
	end
	self.PlayerList = self:Add("DListView")
	self.PlayerList:Dock(TOP)
	self.PlayerList:SetMultiSelect(false)
	self.PlayerList:AddColumn("Spieler")
	self.PlayerList:AddColumn("Job")
	self.PlayerList:SetHeight(200)
	self.Btn = self:Add("DButton")
	self.Btn:SetText("Kriegsanfrage überreichen")
	self.Btn:Dock(FILL)
	self.Btn.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		net.Start("r_gangwar")
			net.WriteEntity(self.Players[self.PlayerList:GetSelectedLine()])
		net.SendToServer()
		self:Remove()
	end
	MG_Theme.Theme.Button.SetupTheme(self.Btn)
end

function PANEL:UpdatePlayers(lst)
	self.Players = lst
	for _,v in pairs(lst) do
		self.PlayerList:AddLine(v:Name(), v:getDarkRPVar("job"))
	end
	MG_Theme.Theme.ListView.SetupTheme(self.PlayerList)
end
vgui.Register("GangwarMenu", PANEL, "DFrame")

local r_gangwar_window
net.Receive("r_gangwar", function()
	if IsValid(r_gangwar_window) then return end
	r_gangwar_window = vgui.Create("GangwarMenu")
	r_gangwar_window:UpdatePlayers(net.ReadTable())
end)

local PANEL = {}
function PANEL:Init()
	self:SetSize(300, 150)
	self:MakePopup()
	self:Center()
	self:ParentToHUD()
	self:SetTitle("Rebellion ausrufen")
	self:ShowCloseButton(false)
	self.Paint = MG_Theme.Theme.Frame.Paint
	self.PaintOver = MG_Theme.Theme.Frame.PaintOver
	local Close = vgui.Create("DButton", self)
	Close:SetSize(50, 20)
	Close:SetPos(self:GetWide() - 52, 2)
	Close:SetText("X")
	Close:SetFont("MG_Theme_Close")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 100, 100)
		else
			col = Color(200, 50, 50)
		end
		draw.RoundedBox(4, 0, 0, w, h, col)
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		self:Remove()
	end
	self.Label = self:Add("DLabel")
	self.Label:SetPos(74, 30)
	self.Label:SetHeight(30)
	self.Label:SetSize(226, 64)
	self.Label:SetWrap(true)
	self.Label:Dock(FILL)
	self.Label:SetText("Bist du dir sicher, dass du eine Rebellion ausrufen möchtest?")
	self.BtnN = self:Add("DButton")
	self.BtnN:SetText("Nein")
	self.BtnN:SetHeight(30)
	self.BtnN:Dock(BOTTOM)
	self.BtnN.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		self:Remove()
	end
	MG_Theme.Theme.Button.SetupTheme(self.BtnN)
	self.BtnY = self:Add("DButton")
	self.BtnY:SetText("Ja")
	self.BtnY:SetHeight(30)
	self.BtnY:Dock(BOTTOM)
	self.BtnY.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		net.Start("r_process")
		net.SendToServer()
		self:Remove()
	end
	MG_Theme.Theme.Button.SetupTheme(self.BtnY)
end
vgui.Register("r_window", PANEL, "DFrame")

local r_window
net.Receive("r_process", function()
	if IsValid(r_window) then return end
	r_window = vgui.Create("r_window")
end)

r_drawing = false

local text1 = ""
local text2 = ""
local team_count = ""
local team2_count = ""
local color1 = {}
local color2 = {}

local local_ply, veh

local color_black_light = Color(0, 0, 0, 200)

local showwarinfo = CreateClientConVar("cl_showwarinfo", 1, FCVAR_ARCHIVE)
local function DrawHUD()
	if !showwarinfo:GetBool() then return end
	local_ply = local_ply or LocalPlayer()
	veh = local_ply:GetVehicle()
	if IsValid(veh) then
		local class = veh:GetClass()
		if class == "prop_vehicle_jeep" or class == "prop_vehicle_jeep_old" or class == "prop_vehicle_airboat" then return end
	end
	if team_count != "" and team2_count != "" then
		local x, y = ScrW() - 280, ScrH() / 2 - 35
		local w, h = 280, 70
		local brd = 1
		surface.SetDrawColor(color1)
		surface.DrawRect(x, y + h / 2, w / 2, h / 2)
		surface.SetDrawColor(color2)
		surface.DrawRect(x + w / 2, y + h / 2, w / 2 * 2, h / 2)
		surface.SetDrawColor(color_black)
		surface.DrawRect(x + w / 2, y + h / 2, brd, h / 2)
		draw.SimpleTextOutlined(team_count, "r_teams", x + w / 4, y + h / 2 + 7, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
		draw.SimpleTextOutlined(team2_count, "r_teams", x + w - w / 4, y + h / 2 + 7, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
	end
	if text1 != "" and text2 != "" then
		surface.SetFont("r_counter1")
		local w1 = surface.GetTextSize(text1)
		surface.SetFont("r_counter2")
		local w2 = surface.GetTextSize(text2)
		local scrw = ScrW()
		local scrh = ScrH()
		local x, y = scrw - math.max(w1, w2) - 10, scrh / 2 - 45
		surface.SetDrawColor(0, 0, 0, 150)
		surface.DrawRect(x, y, scrw - x, scrh / 2 - y)
		draw.DrawText(text1, "r_counter1", x + 5, y + 5, color_white, TEXT_ALIGN_LEFT)
		draw.DrawText(text2, "r_counter2", scrw - 5, y + 25, color_white, TEXT_ALIGN_RIGHT)
	end
end

local soundnotification = CreateClientConVar("cl_warsoundnotification", 1, FCVAR_ARCHIVE)
net.Receive("r_update", function()
	text1 = net.ReadString()
	text2 = net.ReadString()
	local timeRemaining = net.ReadUInt(32)
	if timeRemaining > 0 and timeRemaining <= 9 and soundnotification:GetBool() then
		surface.PlaySound("npc/roller/code2.wav")
	end
	if text1 != "" and text2 != "" then
		r_drawing = true
		hook.Add("HUDPaint", "r_hud", DrawHUD)
	else
		r_drawing = false
		hook.Remove("HUDPaint", "r_hud")
	end
end)

net.Receive("r_counter", function()
	team_count = net.ReadString()
	team2_count = net.ReadString()
	color1 = net.ReadTable()
	color2 = net.ReadTable()
	color1.a = 200
	color2.a = 200
end)