/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import net.diebuddies.bridge.ModLoaderFunctions;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Replay;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.math.Math;
import net.diebuddies.math.RayIntersection;
import net.diebuddies.minecraft.ParticleSpawner;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.model.ColladaParser;
import net.diebuddies.opengl.Texture;
import net.diebuddies.opengl.TextureHelper;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.BlockEntityVertexConsumer;
import net.diebuddies.physics.BlockEntityVertexConsumerProvider;
import net.diebuddies.physics.BlockUpdate;
import net.diebuddies.physics.CubeExtension;
import net.diebuddies.physics.DummyMultiBufferSource;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.IRigidBody;
import net.diebuddies.physics.ItemVertexConsumerProvider;
import net.diebuddies.physics.JsonUnbakedModelHolder;
import net.diebuddies.physics.Mesh;
import net.diebuddies.physics.Model;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ragdoll.Ragdoll;
import net.diebuddies.physics.ragdoll.RagdollMapper;
import net.diebuddies.physics.settings.mobs.MobPhysicsType;
import net.diebuddies.physics.snow.math.AABB3D;
import net.diebuddies.physics.verlet.Cloth;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.ClothRules;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.vines.DynamicLoader;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1680;
import net.minecraft.class_1681;
import net.minecraft.class_1684;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3857;
import net.minecraft.class_3887;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_759;
import net.minecraft.class_776;
import net.minecraft.class_7764;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import physx.common.PxVec3;
import physx.physics.PxRigidBodyFlagEnum;
import physx.physics.PxRigidDynamic;

public class PhysicsMod {
    public static final Path CLOTH_DIRECTORY;
    public static final Path CLOTH_SYNCHRONIZED_DIRECTORY;
    public static final class_2960 SNOWBALL_TEXTURE;
    public static final class_2960 ENDERPEARL_TEXTURE;
    public static final class_2960 EGG_TEXTURE;
    public static final class_2960 SMOKE_TEXTURE;
    public static final class_2960 PUDDLE_TEXTURE;
    public static Object2ObjectMap<class_1937, PhysicsMod> instances;
    private static PhysicsMod currentInstance;
    public static final Map<class_1299<?>, class_897<?>> renderers;
    public static final Map<class_2248, String> registeredBlocks;
    public static final Map<String, class_2248> invRegisteredBlocks;
    public static final Map<String, class_2394> registeredParticles;
    public static final Map<class_2394, String> invRegisteredParticles;
    public static final Map<String, class_3414> registeredSounds;
    public static final Map<class_3414, String> invRegisteredSounds;
    public static boolean hudRendering;
    public static boolean sodiumCatch;
    public static boolean sodiumCatchBoundingBox;
    public static AABB3D sodiumBoundingBox;
    public static boolean clothSmootShadingIrisFix;
    public static Map<class_1087, JsonUnbakedModelHolder> loadedModels;
    public static Matrix4f projectionMatrix;
    public static Matrix4f viewMatrix;
    public static List<VerletSimulation> optifineClothCompat;
    public static List<ClothRenderCommand> clothRenderFast;
    public static boolean reloadCloth;
    public static Matrix4f itemBreakTransformation;
    public PhysicsWorld physicsWorld;
    public boolean init = false;
    public ConcurrentLinkedQueue<PhysicsEntity> entityBlocks = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<class_2338> blockUpdates = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<Explosion> explosions = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<Ragdoll> ragdolls = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<Ragdoll> sodiumRemoveRagdolls = new ConcurrentLinkedQueue();
    public List<BlockUpdate> updateQueue = new ObjectArrayList();
    public List<PhysicsEntity> blockifiedEntity = new ObjectArrayList();
    public PhysicsEntity itemStackEntity;
    public Set<BlockUpdate> removeUpdates = new ObjectOpenHashSet();
    public Set<Integer> alreadyBlockified = new ObjectOpenHashSet();
    public LongSet updatedLightBlocks = new LongOpenHashSet();
    public class_4587 localPivotMatrix = new class_4587();
    public class_897 cubifyEntityRenderer;
    public class_1297 cubifyEntity;
    public long time;
    public boolean blockify;
    public class_1044 blockifyTexture;
    public class_1297 blockifyEntity;
    public int blockifyFeatureIndex;
    public class_3887 blockifyFeature;
    public static final List<List<Mesh>> brokenBlocksLittle;
    public static final List<List<Mesh>> brokenBlocksLots;
    public static final List<List<Mesh>> brokenBlocksLittleVoxel;
    public static final List<List<Mesh>> brokenBlocksLotsVoxel;
    public static final List<Mesh> brokenBlock;
    public static final List<Mesh> snowballMesh;
    public static final List<List<Mesh>> snowballMeshFractured;
    public static final List<Mesh> enderpearlMesh;
    public static final List<List<Mesh>> enderpearlMeshFractured;
    public static final List<Mesh> eggMesh;
    public static final List<List<Mesh>> eggMeshFractured;
    public static final Mesh smoke;
    public static final Mesh liquid;
    public static Cloth defaultCape;
    public static Texture whiteTexture;
    public static Texture blackTexture;
    public static Texture foamTexture;
    public static Map<String, Cloth> cloth;
    private static final class_2350[] DIRECTIONS;

    private static List<Mesh> readBlock(String asset) {
        ObjectArrayList meshes = new ObjectArrayList();
        ObjectArrayList indices = new ObjectArrayList();
        ObjectArrayList indicesQuads = new ObjectArrayList();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(PhysicsMod.class.getClassLoader().getResourceAsStream(asset)));){
            String line = "";
            Mesh mesh = null;
            int ov = 0;
            int ot = 0;
            int on = 0;
            while ((line = reader.readLine()) != null) {
                String[] data;
                if (line.startsWith("o")) {
                    if (mesh != null) {
                        ov += mesh.positions.size();
                        ot += mesh.uvs.size();
                        on += mesh.normals.size();
                        mesh = PhysicsMod.unrollMeshIndices(mesh, (List<Vector3i>)indices, (List<Vector3i>)indicesQuads);
                        indices.clear();
                        indicesQuads.clear();
                        meshes.add(mesh);
                    }
                    mesh = new Mesh(false);
                    continue;
                }
                if (line.startsWith("vt")) {
                    data = line.split(" ");
                    mesh.uvs.add(new Vector2f(Float.parseFloat(data[1]), Float.parseFloat(data[2])));
                    continue;
                }
                if (line.startsWith("vn")) {
                    data = line.split(" ");
                    mesh.normals.add(new Vector3f(Float.parseFloat(data[1]), Float.parseFloat(data[2]), Float.parseFloat(data[3])));
                    continue;
                }
                if (line.startsWith("v")) {
                    data = line.split(" ");
                    mesh.positions.add(new Vector3f(Float.parseFloat(data[1]), Float.parseFloat(data[2]), Float.parseFloat(data[3])));
                    continue;
                }
                if (!line.startsWith("f")) continue;
                data = line.split(" ");
                boolean quads = data.length == 5;
                for (int i = 1; i < data.length; ++i) {
                    String[] idata = data[i].split("/");
                    if (quads) {
                        indicesQuads.add(new Vector3i(Integer.parseInt(idata[0]) - ov, Integer.parseInt(idata[1]) - ot, Integer.parseInt(idata[2]) - on));
                        continue;
                    }
                    indices.add(new Vector3i(Integer.parseInt(idata[0]) - ov, Integer.parseInt(idata[1]) - ot, Integer.parseInt(idata[2]) - on));
                }
                if (!quads) continue;
                int index = indicesQuads.size() - 4;
                indices.add((Vector3i)indicesQuads.get(index));
                indices.add((Vector3i)indicesQuads.get(index + 1));
                indices.add((Vector3i)indicesQuads.get(index + 2));
                indices.add((Vector3i)indicesQuads.get(index));
                indices.add((Vector3i)indicesQuads.get(index + 2));
                indices.add((Vector3i)indicesQuads.get(index + 3));
            }
            if (mesh != null) {
                mesh = PhysicsMod.unrollMeshIndices(mesh, (List<Vector3i>)indices, (List<Vector3i>)indicesQuads);
                meshes.add(mesh);
            }
            for (Mesh m : meshes) {
                m.calculateOffset(true);
                m.calculatePBRData(true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return meshes;
    }

    private static Mesh unrollMeshIndices(Mesh mesh, List<Vector3i> indices, List<Vector3i> indicesQuads) {
        int i;
        Mesh unrolledMesh = new Mesh(false);
        if (indicesQuads.size() > 0) {
            indices.clear();
            for (i = 0; i < indicesQuads.size() / 4; ++i) {
                int indexQuads = i * 6;
                unrolledMesh.indicesQuads.add(indexQuads);
                unrolledMesh.indicesQuads.add(indexQuads + 1);
                unrolledMesh.indicesQuads.add(indexQuads + 2);
                unrolledMesh.indicesQuads.add(indexQuads + 5);
                int indexTriangles = i * 4;
                indices.add(indicesQuads.get(indexTriangles));
                indices.add(indicesQuads.get(indexTriangles + 1));
                indices.add(indicesQuads.get(indexTriangles + 2));
                indices.add(indicesQuads.get(indexTriangles));
                indices.add(indicesQuads.get(indexTriangles + 2));
                indices.add(indicesQuads.get(indexTriangles + 3));
            }
        }
        for (i = 0; i < indices.size(); ++i) {
            Vector3i index = indices.get(i);
            int ipos = index.x - 1;
            int iuv = index.y - 1;
            int inormal = index.z - 1;
            unrolledMesh.positions.add(new Vector3f((Vector3fc)mesh.positions.get(ipos)));
            unrolledMesh.uvs.add(new Vector2f((Vector2fc)mesh.uvs.get(iuv)));
            unrolledMesh.normals.add(new Vector3f((Vector3fc)mesh.normals.get(inormal)));
            unrolledMesh.indices.add(i);
        }
        return unrolledMesh;
    }

    public static void createClothDirectory() {
        try {
            Files.createDirectories(CLOTH_DIRECTORY, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            PhysicsMod.copyResource("assets/physicsmod/cloth/Cloth.blend", CLOTH_DIRECTORY);
            PhysicsMod.copyResource("assets/physicsmod/cloth/Vanilla Cape.dae", CLOTH_DIRECTORY);
            PhysicsMod.copyResource("assets/physicsmod/cloth/TUTORIAL.txt", CLOTH_DIRECTORY);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadCloth() {
        if (whiteTexture == null) {
            whiteTexture = Texture.createColoredTexture((byte)-1, (byte)-1, (byte)-1, (byte)-1, Texture.FILTER_MINECRAFT_TEXTURE);
            blackTexture = Texture.createColoredTexture((byte)0, (byte)0, (byte)0, (byte)-1, Texture.FILTER_MINECRAFT_TEXTURE);
            foamTexture = Texture.load3DTexture("assets/physicsmod/textures/ocean/foam.dat", Texture.FILTER_LOAD_3D_TEXTURE, 256, 256, 16);
        }
        VAO.storePreviouslyBoundState();
        try {
            if (defaultCape == null) {
                ColladaMesh mesh = ColladaParser.loadStaticModel(new File(CLOTH_DIRECTORY + "/Vanilla Cape.dae"));
                mesh.flipUVs();
                defaultCape = new Cloth("Vanilla Cape", mesh, null, null, new ClothRules());
            }
        }
        catch (Exception e) {
            System.err.println("Couldn't load default cape model");
            e.printStackTrace();
        }
        if (cloth != null) {
            for (Cloth cape : cloth.values()) {
                cape.destroy();
            }
        }
        cloth = new Object2ObjectLinkedOpenHashMap();
        PhysicsMod.loadClothFromDirectory(CLOTH_DIRECTORY, true);
        PhysicsMod.loadClothFromDirectory(CLOTH_SYNCHRONIZED_DIRECTORY, false);
        VAO.restorePreviouslyBoundState();
    }

    private static void loadClothFromDirectory(Path clothDirectory, boolean local) {
        try {
            Collection files = Files.list(clothDirectory).filter(PhysicsMod::isValidCloth).collect(Collectors.toList());
            ObjectArrayList sortedCloth = new ObjectArrayList();
            for (Path path : files) {
                File model = path.toFile();
                String name = path.getFileName().toString();
                if (name.contains(".")) {
                    name = name.substring(0, name.lastIndexOf(46));
                }
                String pathNoExtension = path.toFile().getAbsolutePath().substring(0, path.toFile().getAbsolutePath().length() - 3);
                String texture = pathNoExtension.concat("png");
                File rules = new File(pathNoExtension.concat("rules"));
                try {
                    Map<String, ColladaMesh> meshes = ColladaParser.loadMultipleStaticModel(model);
                    ColladaMesh playerMesh = meshes.remove("Player");
                    ColladaMesh clothMesh = meshes.values().iterator().next();
                    sortedCloth.add(new Cloth(name, clothMesh, playerMesh, Texture.load(texture, Texture.FILTER_MINECRAFT_TEXTURE), ClothRules.load(rules, local)));
                }
                catch (Exception e) {
                    System.err.println("Couldn't load " + model.toString());
                    e.printStackTrace();
                }
            }
            Collections.sort(sortedCloth);
            for (Cloth cloth : sortedCloth) {
                PhysicsMod.cloth.put(cloth.name, cloth);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean isValidCloth(Path file) {
        try {
            if (file.toFile().getName().endsWith("dae") && new File(file.toFile().getAbsolutePath().substring(0, file.toFile().getAbsolutePath().length() - 3).concat("png")).exists()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void copyResource(String res, Path dest) throws IOException {
        String[] split = res.split("/");
        try (InputStream src = PhysicsMod.class.getClassLoader().getResourceAsStream(res);){
            Files.copy(src, dest.resolve(split[split.length - 1]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copyClothResource(String res, Path dest) throws IOException {
        PhysicsMod.copyResource(res + ".dae", dest);
        PhysicsMod.copyResource(res + ".png", dest);
        PhysicsMod.copyResource(res + ".rules", dest);
    }

    public static void resetClothSimulations() {
        for (PhysicsMod mod : instances.values()) {
            for (VerletSimulation simulation : mod.getPhysicsWorld().getVerletSimulations()) {
                simulation.destroyed = true;
            }
        }
    }

    public static double getPlaybackSpeed() {
        if (class_310.method_1551().method_1493()) {
            return 0.0;
        }
        if (StarterClient.replay) {
            return (double)ConfigClient.playbackSpeed * Replay.getPlaybackSpeed();
        }
        return ConfigClient.playbackSpeed;
    }

    public static PhysicsMod getInstance(class_1937 level) {
        PhysicsMod mod;
        if (!(level instanceof class_638)) {
            Thread.dumpStack();
        }
        if ((mod = (PhysicsMod)instances.get((Object)level)) == null) {
            mod = new PhysicsMod(level);
            instances.put((Object)level, (Object)mod);
        }
        return mod;
    }

    public static PhysicsMod getCurrentInstance() {
        return currentInstance;
    }

    public static void setCurrentInstance(PhysicsMod currentInstance) {
        PhysicsMod.currentInstance = currentInstance;
    }

    public static Object2ObjectMap<class_1937, PhysicsMod> getInstances() {
        return instances;
    }

    public PhysicsMod(class_1937 level) {
        this.physicsWorld = new PhysicsWorld(level);
        if (level instanceof class_638) {
            ((DynamicLoader)((class_638)level).method_2935()).setPhysicsMod(this);
        }
    }

    public PhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    public static void addSnowball(class_1937 level, class_1680 snowball) {
        if (ConfigClient.snowballImpact != 2) {
            PhysicsMod.addThrowableProjectile(level, (class_3857)snowball, snowballMesh.get(ConfigClient.snowballModel), class_310.method_1551().method_1531().method_4619(SNOWBALL_TEXTURE).method_4624(), ConfigClient.snowballShade, ConfigClient.snowballImpact == 0 ? snowballMeshFractured.get(ConfigClient.snowballModel) : null, ConfigClient.snowballModel == 0);
        }
    }

    public static void addEnderpearl(class_1937 level, class_1684 enderpearl) {
        if (ConfigClient.enderpearlImpact != 2) {
            PhysicsMod.addThrowableProjectile(level, (class_3857)enderpearl, enderpearlMesh.get(ConfigClient.enderpearlModel), class_310.method_1551().method_1531().method_4619(ENDERPEARL_TEXTURE).method_4624(), ConfigClient.enderpearlShade, ConfigClient.enderpearlImpact == 0 ? enderpearlMeshFractured.get(ConfigClient.enderpearlModel) : null, ConfigClient.enderpearlModel == 0);
        }
    }

    public static void addEgg(class_1937 level, class_1681 egg) {
        if (ConfigClient.eggImpact != 2) {
            PhysicsMod.addThrowableProjectile(level, (class_3857)egg, eggMesh.get(ConfigClient.eggModel), class_310.method_1551().method_1531().method_4619(EGG_TEXTURE).method_4624(), ConfigClient.eggShade, ConfigClient.eggImpact == 0 ? eggMeshFractured.get(ConfigClient.eggModel) : null, ConfigClient.eggModel == 0);
        }
    }

    public static void addThrowableProjectile(class_1937 level, class_3857 projectile, Mesh mesh, int textureID, boolean shade, List<Mesh> fractures, boolean fastBoxes) {
        PhysicsMod mod = PhysicsMod.getInstance(level);
        PhysicsEntity entity = new PhysicsEntity(PhysicsEntity.Type.ITEM, null);
        Vector3d snowballPos = new Vector3d(projectile.method_23317(), projectile.method_23318(), projectile.method_23321());
        float snowballRadius = 0.14f;
        class_2338.class_2339 originPos = new class_2338.class_2339();
        class_2338.class_2339 tmpPos = new class_2338.class_2339();
        Vector3d rayDir = new Vector3d(projectile.method_23317() - projectile.field_6038, projectile.method_23318() - projectile.field_5971, projectile.method_23321() - projectile.field_5989).normalize().negate();
        Vector3d aabbMin = new Vector3d();
        Vector3d aabbMax = new Vector3d();
        ObjectOpenHashSet hitPositions = new ObjectOpenHashSet();
        for (int count = 0; count < 5; ++count) {
            float threshold = snowballRadius;
            boolean hasHit = false;
            originPos.method_10102(snowballPos.x, snowballPos.y, snowballPos.z);
            for (int x = -1; x <= 1 && !hasHit; ++x) {
                for (int y = -1; y <= 1 && !hasHit; ++y) {
                    for (int z = -1; z <= 1 && !hasHit; ++z) {
                        class_265 voxelShape;
                        tmpPos.method_10103(originPos.method_10263() + x, originPos.method_10264() + y, originPos.method_10260() + z);
                        class_2680 state = level.method_8320((class_2338)tmpPos);
                        if (state.method_26215() || hitPositions.contains(tmpPos) || (voxelShape = state.method_26220((class_1922)level, projectile.method_24515())).method_1110()) continue;
                        for (class_238 aabb : voxelShape.method_1090()) {
                            if (!AABB3D.isInside(aabb.field_1323 - (double)threshold, aabb.field_1322 - (double)threshold, aabb.field_1321 - (double)threshold, aabb.field_1320 + (double)threshold, aabb.field_1325 + (double)threshold, aabb.field_1324 + (double)threshold, snowballPos.x, snowballPos.y, snowballPos.z)) continue;
                            aabbMin.set(aabb.field_1323 - (double)threshold, aabb.field_1322 - (double)threshold, aabb.field_1321 - (double)threshold);
                            aabbMax.set(aabb.field_1320 + (double)threshold, aabb.field_1325 + (double)threshold, aabb.field_1324 + (double)threshold);
                            RayIntersection.IntersectionResult result = RayIntersection.intersectAABB(snowballPos, rayDir, aabbMin, aabbMax);
                            if (!result.hit) continue;
                            hasHit = true;
                            snowballPos.x += rayDir.x * result.fraction;
                            snowballPos.y += rayDir.y * result.fraction;
                            snowballPos.z += rayDir.z * result.fraction;
                            hitPositions.add(new class_2338((class_2382)tmpPos));
                        }
                    }
                }
            }
            if (hasHit) break;
        }
        entity.getTransformation().translation((Vector3dc)snowballPos);
        Random random = new Random(projectile.method_5628());
        float progress = projectile.field_6012;
        entity.getTransformation().rotateX(random.nextDouble() * java.lang.Math.PI);
        entity.getTransformation().rotateY(random.nextDouble() * java.lang.Math.PI);
        entity.getTransformation().rotateZ(random.nextDouble() * java.lang.Math.PI + (double)progress * 0.5);
        entity.getOldTransformation().set((Matrix4dc)entity.getTransformation());
        entity.models.get((int)0).textureID = textureID;
        entity.backfaceCulling = true;
        entity.shade = shade;
        entity.models.get((int)0).mesh = mesh;
        ObjectArrayList bodies = new ObjectArrayList();
        if (fractures != null) {
            mod.physicsWorld.addBlockParticle(fractures, entity, null, (List<IRigidBody>)bodies, true);
        } else {
            IRigidBody body = mod.physicsWorld.addPhysicsSphere(entity, snowballRadius);
            ((PxRigidDynamic)body.getRigidBody()).setMaxAngularVelocity((float)java.lang.Math.toRadians(360.0));
            ((PxRigidDynamic)body.getRigidBody()).setRigidBodyFlag(PxRigidBodyFlagEnum.eENABLE_SPECULATIVE_CCD, true);
            ((PxRigidDynamic)body.getRigidBody()).setLinearDamping(0.9f);
            ((PxRigidDynamic)body.getRigidBody()).setAngularDamping(0.9f);
            bodies.add(body);
        }
        double speedX = projectile.method_23317() - projectile.field_6038;
        double speedY = projectile.method_23318() - projectile.field_5971;
        double speedZ = projectile.method_23321() - projectile.field_5989;
        float speedMultiplier = 10.0f;
        for (IRigidBody body : bodies) {
            MemoryStack mem = MemoryStack.stackPush();
            try {
                ((PxRigidDynamic)body.getRigidBody()).setLinearVelocity(PxVec3.createAt(mem, MemoryStack::nmalloc, (float)speedX * speedMultiplier, (float)speedY * speedMultiplier, (float)speedZ * speedMultiplier));
            }
            finally {
                if (mem == null) continue;
                mem.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blockifyEntity(class_1937 level, class_1309 entity) {
        class_897 entityRenderer;
        PhysicsMod mod = PhysicsMod.getInstance(level);
        if (ConfigMobs.getMobSetting((class_1297)entity).getType() == MobPhysicsType.OFF) {
            return;
        }
        if (mod.alreadyBlockified.contains(entity.method_5628()) && !(entity instanceof class_1657)) {
            return;
        }
        if (entity.method_5767()) {
            return;
        }
        mod.alreadyBlockified.add(entity.method_5628());
        class_897 renderer = entityRenderer = class_310.method_1551().method_1561().method_3953((class_1297)entity);
        class_583 model = null;
        if (entityRenderer instanceof class_922) {
            model = ((class_922)entityRenderer).method_4038();
        }
        class_4587 stack = new class_4587();
        stack.method_22903();
        mod.blockify = true;
        mod.localPivotMatrix = new class_4587();
        mod.cubifyEntityRenderer = renderer;
        mod.cubifyEntity = entity;
        PhysicsMod.setCurrentInstance(mod);
        class_1060 textureManager = class_310.method_1551().method_1531();
        mod.blockifyTexture = textureManager.method_4619(renderer.method_3931((class_1297)entity));
        mod.blockifyEntity = entity;
        mod.blockifyFeature = null;
        mod.blockifyFeatureIndex = 0;
        DummyMultiBufferSource source = new DummyMultiBufferSource();
        try {
            renderer.method_3936((class_1297)entity, 0.0f, class_310.method_1551().method_1488(), stack, (class_4597)source, 0);
        }
        catch (Exception e) {
            System.err.println("error rendering " + entity.getClass());
            e.printStackTrace();
        }
        finally {
            if (source.lastLayer != null) {
                source.lastLayer.method_23518();
            }
        }
        PhysicsMod.setCurrentInstance(null);
        mod.blockify = false;
        try {
            RagdollMapper.filterCuboidsFromEntities((class_1297)entity, model);
        }
        catch (Exception e) {
            System.err.println("error filtering " + entity.getClass());
            e.printStackTrace();
        }
        stack.method_22909();
        for (PhysicsEntity physicsEntity : mod.blockifiedEntity) {
            physicsEntity.backfaceCulling = false;
        }
        MobPhysicsType type = ConfigMobs.getMobSetting((class_1297)entity).getType();
        if (type == MobPhysicsType.RAGDOLL || type == MobPhysicsType.RAGDOLL_BREAK || type == MobPhysicsType.RAGDOLL_BREAK_BLOOD) {
            Ragdoll ragdoll = null;
            try {
                ragdoll = RagdollMapper.map(type, (class_1297)entity, model);
            }
            catch (Exception e) {
                System.err.println("error creating ragdoll for " + entity.getClass());
                e.printStackTrace();
            }
            if (ragdoll == null) {
                mod.entityBlocks.addAll(mod.blockifiedEntity);
                if (mod.entityBlocks.size() > 0) {
                    entity.method_5650(class_1297.class_5529.field_26999);
                }
            } else {
                class_638 clientLevel;
                class_1657 closest;
                mod.ragdolls.add(ragdoll);
                if (level instanceof class_638 && (closest = (clientLevel = (class_638)level).method_18459(entity.method_23317(), entity.method_23318(), entity.method_23321(), 8.0, false)) != null) {
                    ragdoll.velocity.set(entity.method_23317() - closest.method_23317(), 2.0, entity.method_23321() - closest.method_23321()).normalize().mul(5.0);
                }
                ragdoll.velocity.add(entity.method_18798().field_1352 * 10.0, entity.method_18798().field_1351 * 10.0, entity.method_18798().field_1350 * 10.0);
                entity.method_5650(class_1297.class_5529.field_26999);
            }
        } else {
            mod.entityBlocks.addAll(mod.blockifiedEntity);
            if (mod.entityBlocks.size() > 0) {
                entity.method_5650(class_1297.class_5529.field_26999);
            }
        }
        mod.blockifiedEntity.clear();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public static void createParticlesFromCuboids(class_4587.class_4665 stack, class_4587 local, List<class_630.class_628> cuboids, class_1297 entity, class_897 renderer, class_3887 feature, int overlay, float red, float green, float blue) {
        Matrix4f m = stack.method_23761();
        Matrix4f localM = local.method_23760().method_23761();
        Matrix3f localNM = local.method_23760().method_23762();
        Matrix4d transformation = new Matrix4d();
        Matrix4d transformationLocal = new Matrix4d();
        transformation.set((Matrix4fc)m);
        transformationLocal.set((Matrix4fc)localM);
        transformation.mul((Matrix4dc)transformationLocal.invert(new Matrix4d()));
        PhysicsMod mod = PhysicsMod.getInstance(entity.method_5770());
        int textureID = TextureHelper.getLoadedTextures();
        float partialTicks = class_310.method_1551().method_1488();
        double px = class_3532.method_16436((double)partialTicks, (double)entity.field_6014, (double)entity.method_23317());
        double py = class_3532.method_16436((double)partialTicks, (double)entity.field_6036, (double)entity.method_23318());
        double pz = class_3532.method_16436((double)partialTicks, (double)entity.field_5969, (double)entity.method_23321());
        transformation.setTranslation(px + transformation.m30(), py + transformation.m31(), pz + transformation.m32());
        Vector4f[] minMax = new Vector4f[6];
        Vector3f tmpNormal = new Vector3f();
        Vector4f tmpPos = new Vector4f();
        for (int i = 0; i < minMax.length; ++i) {
            minMax[i] = new Vector4f();
        }
        MobPhysicsType type = ConfigMobs.getMobSetting(entity).getType();
        for (class_630.class_628 box : cuboids) {
            if (box.field_3649.length < 6) continue;
            float minX = box.field_3649[0].field_3502[2].field_3605.x();
            float minY = box.field_3649[0].field_3502[2].field_3605.y();
            float minZ = box.field_3649[0].field_3502[2].field_3605.z();
            float maxX = box.field_3649[1].field_3502[3].field_3605.x();
            float maxY = box.field_3649[1].field_3502[3].field_3605.y();
            float maxZ = box.field_3649[1].field_3502[3].field_3605.z();
            int[] remap = new int[]{5, 4, 3, 2, 1, 0};
            float volume = java.lang.Math.abs(maxX - minX) / 16.0f * (java.lang.Math.abs(maxY - minY) / 16.0f) * (java.lang.Math.abs(maxZ - minZ) / 16.0f);
            boolean isBlocky = type == MobPhysicsType.BLOCKY || type == MobPhysicsType.RAGDOLL || type == MobPhysicsType.RAGDOLL_BREAK || type == MobPhysicsType.RAGDOLL_BREAK_BLOOD;
            boolean noVolume = false;
            if ((double)volume <= 1.0E-4) {
                if (!isBlocky) continue;
                noVolume = true;
            }
            boolean mirror = ((CubeExtension)box).isMirrored();
            List<Mesh> meshes = brokenBlocksLittle.get((int)(Math.random() * (float)brokenBlocksLittle.size()));
            if ((double)volume <= 0.04 || isBlocky) {
                meshes = brokenBlock;
            }
            for (int i = 0; i < box.field_3649.length; ++i) {
                float minU = 1.0f;
                float maxU = 0.0f;
                float minV = 1.0f;
                float maxV = 0.0f;
                for (class_630.class_618 vertex : box.field_3649[i].field_3502) {
                    if (vertex.field_3604 < minU) {
                        minU = vertex.field_3604;
                    }
                    if (vertex.field_3603 < minV) {
                        minV = vertex.field_3603;
                    }
                    if (vertex.field_3604 > maxU) {
                        maxU = vertex.field_3604;
                    }
                    if (!(vertex.field_3603 > maxV)) continue;
                    maxV = vertex.field_3603;
                }
                minMax[i].set(minU, maxU, minV, maxV);
            }
            PhysicsEntity parent = null;
            for (Mesh mesh : meshes) {
                Mesh clone;
                PhysicsEntity particle = new PhysicsEntity(PhysicsEntity.Type.MOB, entity.method_5864());
                particle.feature = feature;
                particle.noVolume = noVolume;
                particle.models.get((int)0).textureID = textureID;
                particle.models.get((int)0).mesh = clone = new Mesh();
                particle.getTransformation().set((Matrix4dc)transformation);
                particle.getOldTransformation().set((Matrix4dc)particle.getTransformation());
                int count = 0;
                Vector3f offset = new Vector3f();
                for (int i = 0; i < mesh.indices.size(); ++i) {
                    int index = mesh.indices.getInt(i);
                    byte sideIndex = mesh.sides.getByte(index);
                    Vector3f position = mesh.positions.get(index);
                    Vector2f uv = mesh.uvs.get(index);
                    Vector3f normal = mesh.normals.get(index);
                    float r = red;
                    float g = green;
                    float b = blue;
                    if (sideIndex == -1) {
                        if (type == MobPhysicsType.FRACTURED_BLOOD) {
                            r = 0.6f;
                            g = 0.0f;
                            b = 0.0f;
                        }
                        sideIndex = 0;
                    }
                    tmpNormal.set(mirror ? -normal.x : normal.x, normal.y, normal.z);
                    localNM.transform(tmpNormal);
                    Vector4f minMaxUVs = minMax[remap[sideIndex]];
                    tmpPos.set((float)Math.remap((double)(position.x + mesh.offset.x), -0.5, 0.5, (double)minX, (double)maxX) / 16.0f, (float)Math.remap((double)(position.y + mesh.offset.y), -0.5, 0.5, (double)minY, (double)maxY) / 16.0f, (float)Math.remap((double)(position.z + mesh.offset.z), mirror ? 0.5 : -0.5, mirror ? -0.5 : 0.5, (double)minZ, (double)maxZ) / 16.0f, 1.0f);
                    localM.transform(tmpPos);
                    clone.indices.add(count);
                    offset.add(tmpPos.x(), tmpPos.y(), tmpPos.z());
                    ++count;
                    Vector3f posR = new Vector3f(tmpPos.x(), tmpPos.y(), tmpPos.z());
                    clone.positions.add(posR);
                    clone.uvs.add(new Vector2f(Math.remap(uv.x, 1.0f, 0.0f, minMaxUVs.x, minMaxUVs.y), Math.remap(uv.y, 0.0f, 1.0f, minMaxUVs.z, minMaxUVs.w)));
                    clone.normals.add(new Vector3f(tmpNormal.x(), tmpNormal.y(), tmpNormal.z()));
                    clone.addColor(r, g, b);
                }
                if (StarterClient.iris || StarterClient.optifabric) {
                    clone.calculatePBRData(false);
                }
                offset.div((float)clone.positions.size());
                for (Vector3f position : clone.positions) {
                    position.sub((Vector3fc)offset);
                }
                clone.offset = offset;
                Vector3d ps = transformationLocal.getTranslation(new Vector3d());
                particle.pivot.set((Vector3dc)ps);
                if (parent == null) {
                    parent = particle;
                    mod.blockifiedEntity.add(particle);
                    continue;
                }
                parent.children.add(particle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhysicsEntity renderBlockIntoEntity(PhysicsEntity.Type type, class_1087 model, class_2680 state, class_2338 pos, boolean bakeAO) {
        this.itemStackEntity = new PhysicsEntity(type, state);
        this.itemStackEntity.models.get((int)0).mesh = new Mesh();
        PhysicsMod.setCurrentInstance(this);
        class_243 blockOffset = state.method_26226((class_1922)this.physicsWorld.getWorld(), pos);
        try {
            class_5820 random = new class_5820(0L);
            this.renderFlat(this.itemStackEntity, (class_1920)this.physicsWorld.getWorld(), model, state, pos, (class_5819)random, state.method_26190(pos), class_4608.field_21444);
        }
        catch (Exception e) {
            PhysicsEntity physicsEntity = null;
            return physicsEntity;
        }
        finally {
            PhysicsMod.setCurrentInstance(null);
        }
        if (this.itemStackEntity.models.get((int)0).mesh.indices.size() < 9) {
            PhysicsMod.setCurrentInstance(null);
            return null;
        }
        this.itemStackEntity.models.get((int)0).mesh.calculateOffset();
        if (StarterClient.iris || StarterClient.optifabric) {
            this.itemStackEntity.models.get((int)0).mesh.calculatePBRData(false);
        }
        this.itemStackEntity.models.get((int)0).textureID = class_310.method_1551().method_1531().method_4619(model.method_4711().method_45852()).method_4624();
        this.itemStackEntity.getTransformation().set((Matrix4dc)new Matrix4d().translate((double)pos.method_10263() + blockOffset.field_1352, (double)pos.method_10264() + blockOffset.field_1351, (double)pos.method_10260() + blockOffset.field_1350));
        this.itemStackEntity.getOldTransformation().set((Matrix4dc)this.itemStackEntity.getTransformation());
        this.itemStackEntity.models.get((int)0).animationSprite = model.method_4711();
        return this.itemStackEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhysicsEntity renderBlockIntoEntity(PhysicsEntity.Type type, class_827<class_2586> renderer, class_2586 blockEntity, class_2680 state, class_2338 pos, boolean destruction) {
        PhysicsEntity physicsBlockEntity = new PhysicsEntity(type, state);
        physicsBlockEntity.backfaceCulling = false;
        physicsBlockEntity.models.clear();
        PhysicsMod.setCurrentInstance(this);
        sodiumCatch = true;
        float tickDelta = 0.0f;
        BlockEntityVertexConsumerProvider source = new BlockEntityVertexConsumerProvider(destruction);
        try {
            renderer.method_3569(blockEntity, tickDelta, new class_4587(), (class_4597)source, class_4608.field_21444, 0);
        }
        catch (Exception e) {
            PhysicsEntity physicsEntity = null;
            return physicsEntity;
        }
        finally {
            PhysicsMod.setCurrentInstance(null);
            if (source.getLastLayer() != null) {
                source.getLastLayer().method_23518();
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            sodiumCatch = false;
        }
        class_243 blockOffset = state.method_26226((class_1922)this.physicsWorld.getWorld(), pos);
        ObjectArrayList meshes = new ObjectArrayList();
        for (BlockEntityVertexConsumer consumer : source.getBakedRenderTypeModels().values()) {
            Model model = consumer.model;
            if (model.mesh.indices.size() < 6) continue;
            meshes.add(model.mesh);
            if (StarterClient.iris || StarterClient.optifabric) {
                model.mesh.calculatePBRData(false);
            }
            physicsBlockEntity.models.add(model);
        }
        if (physicsBlockEntity.models.size() == 0) {
            PhysicsMod.setCurrentInstance(null);
            return null;
        }
        Mesh.calculateMeshOffsets((List<Mesh>)meshes, false);
        physicsBlockEntity.getTransformation().set((Matrix4dc)new Matrix4d().translate((double)pos.method_10263() + blockOffset.field_1352, (double)pos.method_10264() + blockOffset.field_1351, (double)pos.method_10260() + blockOffset.field_1350));
        physicsBlockEntity.getOldTransformation().set((Matrix4dc)physicsBlockEntity.getTransformation());
        return physicsBlockEntity;
    }

    public PhysicsEntity renderBlockIntoEntity(PhysicsEntity.Type type, class_827<class_2586> renderer, class_2586 blockEntity, class_2680 state, class_2338 pos) {
        return this.renderBlockIntoEntity(type, renderer, blockEntity, state, pos, true);
    }

    public PhysicsEntity renderBlockIntoEntity(class_1937 level, PhysicsEntity.Type type, class_2680 state, class_2338 pos, boolean bakeAO) {
        if (state.method_31709()) {
            class_827 renderer;
            class_824 berd = class_310.method_1551().method_31975();
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity != null && (renderer = berd.method_3550(blockEntity)) != null) {
                return this.renderBlockIntoEntity(type, (class_827<class_2586>)renderer, blockEntity, state, pos, false);
            }
        }
        class_776 manager = class_310.method_1551().method_1541();
        class_1087 model = manager.method_3349(state);
        return this.renderBlockIntoEntity(type, model, state, pos, bakeAO);
    }

    private int renderFlat(PhysicsEntity entity, class_1920 world, class_1087 model, class_2680 state, class_2338 pos, class_5819 random, long seed, int overlay) {
        int hashCode = 0;
        Mesh mesh = entity.models.get((int)0).mesh;
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            class_2350 direction = DIRECTIONS[i];
            random.method_43052(seed);
            List list = model.method_4707(state, direction, random);
            if (list.isEmpty()) continue;
            hashCode = hashCode * 31 + this.renderQuadsFlat(entity, mesh, world, state, pos, overlay, list);
        }
        random.method_43052(seed);
        List quads = model.method_4707(state, (class_2350)null, random);
        if (!quads.isEmpty()) {
            hashCode = hashCode * 31 + this.renderQuadsFlat(entity, mesh, world, state, pos, overlay, quads);
        }
        return hashCode;
    }

    private int renderQuadsFlat(PhysicsEntity entity, Mesh mesh, class_1920 world, class_2680 state, class_2338 pos, int overlay, List<class_777> quads) {
        int hashCode = 0;
        for (int i = 0; i < quads.size(); ++i) {
            hashCode = hashCode * 31 + this.renderQuadFlat(entity, mesh, world, state, pos, quads.get(i), overlay);
        }
        return hashCode;
    }

    private int renderQuadFlat(PhysicsEntity entity, Mesh mesh, class_1920 world, class_2680 state, class_2338 pos, class_777 quad, int overlay) {
        int hashCode = 0;
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        if (quad.method_3360()) {
            int blockColor = class_310.method_1551().method_1505().method_1697(state, world, pos, quad.method_3359());
            hashCode = hashCode * 31 + blockColor;
            red = (float)(blockColor >> 16 & 0xFF) / 255.0f;
            green = (float)(blockColor >> 8 & 0xFF) / 255.0f;
            blue = (float)(blockColor & 0xFF) / 255.0f;
        }
        entity.shade = quad.method_24874();
        int[] vertexData = quad.method_3357();
        class_2382 normal = quad.method_3358().method_10163();
        int vertexSize = class_290.field_1590.method_1359();
        int vertices = vertexData.length / vertexSize;
        for (int i = 0; i < vertices; ++i) {
            int offset = i * vertexSize;
            float x = Float.intBitsToFloat(vertexData[offset]);
            float y = Float.intBitsToFloat(vertexData[offset + 1]);
            float z = Float.intBitsToFloat(vertexData[offset + 2]);
            int rgb = vertexData[offset + 3];
            float r = (float)(rgb >> 24 & 0xFF) / 255.0f * red;
            float g = (float)(rgb >> 16 & 0xFF) / 255.0f * green;
            float b = (float)(rgb >> 8 & 0xFF) / 255.0f * blue;
            mesh.positions.add(new Vector3f(x, y, z));
            mesh.addColor(r, g, b);
            mesh.normals.add(new Vector3f((float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260()));
            mesh.uvs.add(new Vector2f(Float.intBitsToFloat(vertexData[offset + 4]), Float.intBitsToFloat(vertexData[offset + 5])));
        }
        int index = mesh.positions.size() - 4;
        mesh.indices.add(index);
        mesh.indices.add(index + 1);
        mesh.indices.add(index + 2);
        mesh.indices.add(index);
        mesh.indices.add(index + 2);
        mesh.indices.add(index + 3);
        return hashCode * 31 + quad.hashCode();
    }

    private void calculateShape(class_1920 blockAndTintGetter, class_2680 blockState, class_2338 blockPos, int[] is, class_2350 direction, @Nullable float[] fs, BitSet bitSet) {
        float m;
        int l;
        float f = 32.0f;
        float g = 32.0f;
        float h = 32.0f;
        float i = -32.0f;
        float j = -32.0f;
        float k = -32.0f;
        for (l = 0; l < 4; ++l) {
            m = Float.intBitsToFloat(is[l * 8]);
            float n = Float.intBitsToFloat(is[l * 8 + 1]);
            float o = Float.intBitsToFloat(is[l * 8 + 2]);
            f = java.lang.Math.min(f, m);
            g = java.lang.Math.min(g, n);
            h = java.lang.Math.min(h, o);
            i = java.lang.Math.max(i, m);
            j = java.lang.Math.max(j, n);
            k = java.lang.Math.max(k, o);
        }
        if (fs != null) {
            fs[class_2350.field_11039.method_10146()] = f;
            fs[class_2350.field_11034.method_10146()] = i;
            fs[class_2350.field_11033.method_10146()] = g;
            fs[class_2350.field_11036.method_10146()] = j;
            fs[class_2350.field_11043.method_10146()] = h;
            fs[class_2350.field_11035.method_10146()] = k;
            l = DIRECTIONS.length;
            fs[class_2350.field_11039.method_10146() + l] = 1.0f - f;
            fs[class_2350.field_11034.method_10146() + l] = 1.0f - i;
            fs[class_2350.field_11033.method_10146() + l] = 1.0f - g;
            fs[class_2350.field_11036.method_10146() + l] = 1.0f - j;
            fs[class_2350.field_11043.method_10146() + l] = 1.0f - h;
            fs[class_2350.field_11035.method_10146() + l] = 1.0f - k;
        }
        float p = 1.0E-4f;
        m = 0.9999f;
        switch (direction) {
            case field_11033: {
                bitSet.set(1, f >= 1.0E-4f || h >= 1.0E-4f || i <= 0.9999f || k <= 0.9999f);
                bitSet.set(0, g == j && (g < 1.0E-4f || blockState.method_26234((class_1922)blockAndTintGetter, blockPos)));
                break;
            }
            case field_11036: {
                bitSet.set(1, f >= 1.0E-4f || h >= 1.0E-4f || i <= 0.9999f || k <= 0.9999f);
                bitSet.set(0, g == j && (j > 0.9999f || blockState.method_26234((class_1922)blockAndTintGetter, blockPos)));
                break;
            }
            case field_11043: {
                bitSet.set(1, f >= 1.0E-4f || g >= 1.0E-4f || i <= 0.9999f || j <= 0.9999f);
                bitSet.set(0, h == k && (h < 1.0E-4f || blockState.method_26234((class_1922)blockAndTintGetter, blockPos)));
                break;
            }
            case field_11035: {
                bitSet.set(1, f >= 1.0E-4f || g >= 1.0E-4f || i <= 0.9999f || j <= 0.9999f);
                bitSet.set(0, h == k && (k > 0.9999f || blockState.method_26234((class_1922)blockAndTintGetter, blockPos)));
                break;
            }
            case field_11039: {
                bitSet.set(1, g >= 1.0E-4f || h >= 1.0E-4f || j <= 0.9999f || k <= 0.9999f);
                bitSet.set(0, f == i && (f < 1.0E-4f || blockState.method_26234((class_1922)blockAndTintGetter, blockPos)));
                break;
            }
            case field_11034: {
                bitSet.set(1, g >= 1.0E-4f || h >= 1.0E-4f || j <= 0.9999f || k <= 0.9999f);
                bitSet.set(0, f == i && (i > 0.9999f || blockState.method_26234((class_1922)blockAndTintGetter, blockPos)));
            }
        }
    }

    public static void blockifyItemStack(class_1937 level, class_1799 item, boolean mainHand) {
        try {
            if (StarterClient.iris) {
                Iris.enableHandRendering();
            }
            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            PhysicsMod.renderHand(level, item, camera, class_310.method_1551().method_1534(), mainHand);
            if (StarterClient.iris) {
                Iris.disableHandRendering();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void renderHand(class_1937 level, class_1799 item, class_4184 camera, float tickDelta, boolean mainHand) {
        class_4587 matrices = new class_4587();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        matrices.method_23760().method_23761().invert();
        matrices.method_22903();
        PhysicsMod.bobViewWhenHurt(matrices, tickDelta);
        if (((Boolean)class_310.method_1551().field_1690.method_42448().method_41753()).booleanValue()) {
            PhysicsMod.bobView(matrices, tickDelta);
        }
        PhysicsMod.renderItem(level, item, camera, mainHand, class_310.method_1551().field_1773.field_4012, tickDelta, matrices, class_310.method_1551().field_1724, class_310.method_1551().method_1561().method_23839((class_1297)class_310.method_1551().field_1724, tickDelta));
        matrices.method_22909();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderItem(class_1937 level, class_1799 item, class_4184 camera, boolean mainHand, class_759 firstPersonRenderer, float tickDelta, class_4587 matrices, class_746 player, int light) {
        float f = player.method_6055(tickDelta);
        class_1268 hand = (class_1268)MoreObjects.firstNonNull((Object)player.field_6266, (Object)class_1268.field_5808);
        float xRot = class_3532.method_16439((float)tickDelta, (float)player.field_6004, (float)player.method_36455());
        float h = class_3532.method_16439((float)tickDelta, (float)player.field_3914, (float)player.field_3916);
        float i = class_3532.method_16439((float)tickDelta, (float)player.field_3931, (float)player.field_3932);
        matrices.method_22907(class_7833.field_40714.rotationDegrees((player.method_5695(tickDelta) - h) * 0.1f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees((player.method_5705(tickDelta) - i) * 0.1f));
        ItemVertexConsumerProvider dummy = new ItemVertexConsumerProvider();
        float anim = hand == class_1268.field_5808 ? f : 0.0f;
        float height = 1.0f - class_3532.method_16439((float)tickDelta, (float)firstPersonRenderer.field_4053, (float)firstPersonRenderer.field_4043);
        try {
            boolean highRes;
            itemBreakTransformation = new Matrix4f();
            firstPersonRenderer.method_3228((class_742)player, tickDelta, xRot, mainHand ? class_1268.field_5808 : class_1268.field_5810, anim, item, height, matrices, (class_4597)dummy, light);
            class_1087 model = class_310.method_1551().method_1480().method_4019(item, null, null, 1);
            class_1058 sprite = model.method_4711();
            class_7764 contents = sprite.method_45851();
            float size = 1.0f / (float)contents.method_45807() * 0.6666666f;
            float texelSizeX = 1.0f / (float)contents.method_45807();
            float texelSizeY = 1.0f / (float)contents.method_45815();
            float depthScale = 0.041666664f / size;
            itemBreakTransformation.translateLocal((float)camera.method_19326().field_1352, (float)camera.method_19326().field_1351, (float)camera.method_19326().field_1350);
            boolean bl = highRes = contents.method_45807() > 32 || contents.method_45815() > 32;
            if (!highRes) {
                for (int x = 0; x < contents.method_45807(); ++x) {
                    for (int y = 0; y < contents.method_45815(); ++y) {
                        if (contents.method_45810(0, x, y)) continue;
                        float uvx = (float)x / (float)contents.method_45807() + texelSizeX * 0.5f;
                        float uvy = (float)y / (float)contents.method_45815() + texelSizeY * 0.5f;
                        ParticleSpawner.spawnItemPhysicsParticle(sprite, level, uvx, 1.0f - uvy, 0.5, size, depthScale, uvx, uvy, itemBreakTransformation);
                    }
                }
            }
        }
        finally {
            itemBreakTransformation = null;
        }
    }

    private static void bobView(class_4587 matrices, float f) {
        if (class_310.method_1551().method_1560() instanceof class_1657) {
            class_1657 playerEntity = (class_1657)class_310.method_1551().method_1560();
            float g = playerEntity.field_5973 - playerEntity.field_6039;
            float h = -(playerEntity.field_5973 + g * f);
            float i = class_3532.method_16439((float)f, (float)playerEntity.field_7505, (float)playerEntity.field_7483);
            matrices.method_22904((double)(class_3532.method_15374((float)(h * (float)java.lang.Math.PI)) * i * 0.5f), (double)(-java.lang.Math.abs(class_3532.method_15362((float)(h * (float)java.lang.Math.PI)) * i)), 0.0);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_15374((float)(h * (float)java.lang.Math.PI)) * i * 3.0f));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(java.lang.Math.abs(class_3532.method_15362((float)(h * (float)java.lang.Math.PI - 0.2f)) * i) * 5.0f));
        }
    }

    private static void bobViewWhenHurt(class_4587 matrices, float f) {
        if (class_310.method_1551().method_1560() instanceof class_1309) {
            float i;
            class_1309 livingEntity = (class_1309)class_310.method_1551().method_1560();
            float g = (float)livingEntity.field_6235 - f;
            if (livingEntity.method_29504()) {
                i = java.lang.Math.min((float)livingEntity.field_6213 + f, 20.0f);
                matrices.method_22907(class_7833.field_40718.rotationDegrees(40.0f - 8000.0f / (i + 200.0f)));
            }
            if (g < 0.0f) {
                return;
            }
            g /= (float)livingEntity.field_6254;
            g = class_3532.method_15374((float)(g * g * g * g * (float)java.lang.Math.PI));
            i = livingEntity.method_48157();
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-i));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(-g * 14.0f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(i));
        }
    }

    static {
        int j;
        List<Mesh> meshesVoxel;
        List<Mesh> meshes;
        int i;
        CLOTH_DIRECTORY = ModLoaderFunctions.getGameDir().resolve("cloth_local");
        CLOTH_SYNCHRONIZED_DIRECTORY = ModLoaderFunctions.getGameDir().resolve(".physics_mod_cache/cloth");
        SNOWBALL_TEXTURE = new class_2960("physicsmod:textures/items/snowball.png");
        ENDERPEARL_TEXTURE = new class_2960("physicsmod:textures/items/enderpearl.png");
        EGG_TEXTURE = new class_2960("physicsmod:textures/items/egg.png");
        SMOKE_TEXTURE = new class_2960("physicsmod:textures/smoke/smoke.png");
        PUDDLE_TEXTURE = new class_2960("physicsmod:textures/ocean/puddle.png");
        instances = new Object2ObjectOpenHashMap();
        renderers = new Object2ObjectOpenHashMap();
        registeredBlocks = new Object2ObjectOpenHashMap();
        invRegisteredBlocks = new Object2ObjectOpenHashMap();
        registeredParticles = new Object2ObjectAVLTreeMap();
        invRegisteredParticles = new Object2ObjectOpenHashMap();
        registeredSounds = new Object2ObjectAVLTreeMap();
        invRegisteredSounds = new Object2ObjectOpenHashMap();
        sodiumBoundingBox = new AABB3D(new Vector3d(), new Vector3d());
        loadedModels = new Object2ObjectOpenHashMap();
        projectionMatrix = new Matrix4f();
        viewMatrix = new Matrix4f();
        optifineClothCompat = new ObjectArrayList();
        clothRenderFast = new ObjectArrayList();
        brokenBlocksLittle = new ObjectArrayList();
        brokenBlocksLots = new ObjectArrayList();
        brokenBlocksLittleVoxel = new ObjectArrayList();
        brokenBlocksLotsVoxel = new ObjectArrayList();
        snowballMesh = new ObjectArrayList();
        snowballMeshFractured = new ObjectArrayList();
        enderpearlMesh = new ObjectArrayList();
        enderpearlMeshFractured = new ObjectArrayList();
        eggMesh = new ObjectArrayList();
        eggMeshFractured = new ObjectArrayList();
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_little_1.obj"));
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_little_2.obj"));
        brokenBlocksLittle.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_little_3.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_lots_2.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_lots_3.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_lots_4.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_lots_5.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_lots_6.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_lots_7.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_lots_8.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_lots_9.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_lots_10.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_lots_11.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_lots_12.obj"));
        brokenBlocksLots.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/realistic/physics_shattered_lots_13.obj"));
        brokenBlocksLittleVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_little_1_voxel.obj"));
        brokenBlocksLittleVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_little_2_voxel.obj"));
        brokenBlocksLittleVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_little_3_voxel.obj"));
        brokenBlocksLotsVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_lots_2_voxel.obj"));
        brokenBlocksLotsVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_lots_3_voxel.obj"));
        brokenBlocksLotsVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_lots_4_voxel.obj"));
        brokenBlocksLotsVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_lots_5_voxel.obj"));
        brokenBlocksLotsVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_lots_6_voxel.obj"));
        brokenBlocksLotsVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_lots_7_voxel.obj"));
        brokenBlocksLotsVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_lots_8_voxel.obj"));
        brokenBlocksLotsVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_lots_9_voxel.obj"));
        brokenBlocksLotsVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_lots_10_voxel.obj"));
        brokenBlocksLotsVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_lots_11_voxel.obj"));
        brokenBlocksLotsVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_lots_12_voxel.obj"));
        brokenBlocksLotsVoxel.add(PhysicsMod.readBlock("assets/physicsmod/models/fractures/voxel/physics_shattered_lots_13_voxel.obj"));
        for (i = 0; i < brokenBlocksLittle.size(); ++i) {
            meshes = brokenBlocksLittle.get(i);
            meshesVoxel = brokenBlocksLittleVoxel.get(i);
            for (j = 0; j < meshes.size(); ++j) {
                meshesVoxel.get((int)j).offset = new Vector3f((Vector3fc)meshes.get((int)j).offset);
            }
        }
        for (i = 0; i < brokenBlocksLots.size(); ++i) {
            meshes = brokenBlocksLots.get(i);
            meshesVoxel = brokenBlocksLotsVoxel.get(i);
            for (j = 0; j < meshes.size(); ++j) {
                meshesVoxel.get((int)j).offset = new Vector3f((Vector3fc)meshes.get((int)j).offset);
            }
        }
        brokenBlock = PhysicsMod.readBlock("assets/physicsmod/models/fractures/physics_simple.obj");
        snowballMesh.add(PhysicsMod.readBlock("assets/physicsmod/models/snowball/snowball_voxel.obj").get(0));
        snowballMesh.add(PhysicsMod.readBlock("assets/physicsmod/models/snowball/snowball_round.obj").get(0));
        snowballMeshFractured.add(PhysicsMod.readBlock("assets/physicsmod/models/snowball/snowball_voxel_fractured.obj"));
        snowballMeshFractured.add(PhysicsMod.readBlock("assets/physicsmod/models/snowball/snowball_round_fractured.obj"));
        enderpearlMesh.add(PhysicsMod.readBlock("assets/physicsmod/models/enderpearl/enderpearl_voxel.obj").get(0));
        enderpearlMesh.add(PhysicsMod.readBlock("assets/physicsmod/models/enderpearl/enderpearl_round.obj").get(0));
        enderpearlMeshFractured.add(PhysicsMod.readBlock("assets/physicsmod/models/enderpearl/enderpearl_voxel_fractured.obj"));
        enderpearlMeshFractured.add(PhysicsMod.readBlock("assets/physicsmod/models/enderpearl/enderpearl_round_fractured.obj"));
        eggMesh.add(PhysicsMod.readBlock("assets/physicsmod/models/egg/egg_voxel.obj").get(0));
        eggMesh.add(PhysicsMod.readBlock("assets/physicsmod/models/egg/egg_round.obj").get(0));
        eggMeshFractured.add(PhysicsMod.readBlock("assets/physicsmod/models/egg/egg_voxel_fractured.obj"));
        eggMeshFractured.add(PhysicsMod.readBlock("assets/physicsmod/models/egg/egg_round_fractured.obj"));
        smoke = PhysicsMod.readBlock("assets/physicsmod/models/smoke/smoke.obj").get(0);
        liquid = PhysicsMod.readBlock("assets/physicsmod/models/liquid/liquid.obj").get(0);
        DIRECTIONS = class_2350.values();
    }
}

