/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.cloth;

import com.google.gson.JsonArray;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.diebuddies.compat.Sodium;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigCloth;
import net.diebuddies.model.ColladaMesh;
import net.diebuddies.physics.DynamicsWorld;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.cloth.BaseEntry;
import net.diebuddies.physics.settings.cloth.CategorySelectionList;
import net.diebuddies.physics.settings.cloth.ClothConstants;
import net.diebuddies.physics.settings.cloth.ClothEntitySelectionScreen;
import net.diebuddies.physics.settings.cloth.ClothSelectionList;
import net.diebuddies.physics.settings.cloth.PartSelectionList;
import net.diebuddies.physics.settings.gui.legacy.LegacyAbstractSelectionList;
import net.diebuddies.physics.settings.mobs.BoundingBoxGetter;
import net.diebuddies.physics.settings.mobs.MobEntry;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.verlet.Cloth;
import net.diebuddies.physics.verlet.ModelPartParent;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3879;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5244;
import net.minecraft.class_583;
import net.minecraft.class_5944;
import net.minecraft.class_630;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_897;
import org.joml.Matrix4d;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ClothDisplayScreen
extends class_437 {
    private static final double ROTATE_SPEED = 6.0;
    private static final double START_ROTATE_SPEED = 25.0;
    private class_437 parent;
    private PartSelectionList partList;
    public LegacyAbstractSelectionList<?> activeList;
    private String selectedEntity = "physicsmod:yourself";
    public class_1299<? extends class_1297> entityType;
    private class_2960 textureLocation;
    private class_3879 model;
    private List<class_339> bottomWidgets = new ObjectArrayList();
    private class_2561 customTitle;
    private Map<String, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    private long lastTime;
    private double timeDelta;
    private static final double FIXED_TIME_STEP = 0.016666666666666666;
    private double rotationSpeed = 25.0;
    private double totalRotation;
    private int entityXPosition;
    private class_4185 rotateLeft;
    private class_4185 rotateRight;
    private double startX;
    private double startY;
    private double startZ;
    private double endX;
    private double endY;
    private double endZ;
    private boolean reloadLater;
    @Nullable
    private Map<String, ConfigCloth.ClothList> playerCopy;

    protected ClothDisplayScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"physicsmod.menu.cloth.partselection.title"));
        this.parent = parent;
        this.entityType = class_1299.field_6097;
        Object2ObjectOpenHashMap toCopy = ConfigCloth.getCustomizationParts("physicsmod:yourself");
        if (toCopy == null) {
            toCopy = new Object2ObjectOpenHashMap();
        }
        this.playerCopy = new Object2ObjectOpenHashMap();
        for (Map.Entry entry : toCopy.entrySet()) {
            this.playerCopy.put((String)entry.getKey(), ((ConfigCloth.ClothList)entry.getValue()).copy());
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.reloadLater = !ConfigCloth.clothUpToDate;
        ConfigCloth.isChangingPlayer = true;
        PhysicsMod.loadCloth();
        PhysicsMod.resetClothSimulations();
        this.loadModelAndTexture();
        this.loadCloth();
        this.lastTime = System.nanoTime();
        PhysicsMod.createClothDirectory();
        this.entityXPosition = (int)((double)this.field_22789 * 0.25);
        this.method_37063((class_364)((class_4185)((Animatable)ButtonSettings.builder(this.entityXPosition - 10, this.field_22790 - 57, 20, 20, (class_2561)class_2561.method_43470((String)"?"), button -> {
            this.rotationSpeed = 25.0;
        })).setAnimDepth(200.0f)));
        this.rotateLeft = (class_4185)((Animatable)ButtonSettings.builder(this.entityXPosition - 35, this.field_22790 - 57, 20, 20, (class_2561)class_2561.method_43470((String)"<"), button -> {})).setAnimDepth(200.0f);
        this.method_37063((class_364)this.rotateLeft);
        this.rotateRight = (class_4185)((Animatable)ButtonSettings.builder(this.entityXPosition + 15, this.field_22790 - 57, 20, 20, (class_2561)class_2561.method_43470((String)">"), button -> {})).setAnimDepth(200.0f);
        this.method_37063((class_364)this.rotateRight);
        this.goToCategoryScreen();
    }

    private void goToCategoryScreen() {
        if (this.activeList != null) {
            this.field_22786.remove(this.activeList);
        }
        this.customTitle = this.reloadLater ? class_2561.method_43471((String)"physicsmod.menu.cloth.downloading.title") : class_2561.method_43469((String)"physicsmod.menu.cloth.categoryselection.title", (Object[])new Object[]{ClothDisplayScreen.getEntityName(this.selectedEntity)});
        this.setBottomWidgets(new class_339[]{ButtonSettings.builder(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"physicsmod.menu.cloth.selection.changeEntity"), button -> this.field_22787.method_1507((class_437)new ClothEntitySelectionScreen(this, this.field_22787.field_1690))), ButtonSettings.builder(0, 0, 100, 20, class_5244.field_24334, button -> this.method_25419())});
        CategorySelectionList list = new CategorySelectionList(this, this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
        this.field_22786.add(list);
        this.activeList = list;
    }

    private void goToPartsScreen() {
        if (this.activeList != null) {
            this.field_22786.remove(this.activeList);
        }
        this.customTitle = class_2561.method_43469((String)"physicsmod.menu.cloth.partselection.title", (Object[])new Object[]{ClothDisplayScreen.getEntityName(this.selectedEntity)});
        this.setBottomWidgets(new class_339[]{ButtonSettings.builder(0, 0, 100, 20, (class_2561)class_2561.method_43471((String)"physicsmod.menu.cloth.selection.changeEntity"), button -> this.field_22787.method_1507((class_437)new ClothEntitySelectionScreen(this, this.field_22787.field_1690))), ButtonSettings.builder(0, 0, 100, 20, class_5244.field_24334, button -> this.method_25419())});
        this.partList = new PartSelectionList(this, this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
        this.field_22786.add(this.partList);
        this.activeList = this.partList;
    }

    public void goToClothScreen(String selectedCategory) {
        if (this.activeList != null) {
            this.field_22786.remove(this.activeList);
        }
        this.customTitle = class_2561.method_43469((String)"physicsmod.menu.cloth.clothselection.title", (Object[])new Object[]{ClothDisplayScreen.getEntityName(this.selectedEntity)});
        this.setBottomWidgets(new class_339[]{ButtonSettings.builder(0, this.field_22790 - 27, 100, 20, (class_2561)class_2561.method_43471((String)"physicsmod.menu.cloth.selection.openFolder"), button -> class_156.method_668().method_672(PhysicsMod.CLOTH_DIRECTORY.toFile())), ButtonSettings.builder(0, this.field_22790 - 27, 100, 20, (class_2561)class_2561.method_43471((String)"physicsmod.gui.select"), button -> this.goToCategoryScreen())});
        ClothSelectionList list = new ClothSelectionList(this, selectedCategory, this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 25);
        this.field_22786.add(list);
        this.activeList = list;
    }

    public static String getEntityName(String selectedEntity) {
        if (selectedEntity.equals("physicsmod:yourself")) {
            return class_2477.method_10517().method_48307("physicsmod.menu.cloth.clothselection.yourself");
        }
        if (selectedEntity.equals("minecraft:player")) {
            return class_2477.method_10517().method_48307("physicsmod.menu.cloth.clothselection.allPlayers");
        }
        return selectedEntity.replace("physicsmod:player:", "");
    }

    public void setBottomWidgets(class_339 ... newWidgets) {
        for (class_339 widget : this.bottomWidgets) {
            this.method_37066((class_364)widget);
        }
        this.bottomWidgets.clear();
        int width = 100;
        int padding = 10;
        int y = this.field_22790 - 27;
        int centerX = this.field_22789 / 2;
        int offsetX = centerX - (width * newWidgets.length + (newWidgets.length - 1) * padding) / 2;
        for (class_339 widget : newWidgets) {
            this.bottomWidgets.add(widget);
            widget.method_46419(y);
            widget.method_46421(offsetX);
            widget.method_25358(width);
            this.method_37063((class_364)widget);
            offsetX += width + padding;
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.activeList.method_25394(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_27534(this.field_22793, this.customTitle, this.field_22789 / 2, 15, 0xFFFFFF);
        if (this.rotateLeft.method_25367()) {
            this.rotationSpeed = -6.0;
        } else if (this.rotateRight.method_25367()) {
            this.rotationSpeed = 6.0;
        }
        this.updateCloth();
        this.renderEntity();
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    public void method_25393() {
        if (this.reloadLater && ConfigCloth.clothUpToDate) {
            this.method_25426();
        }
        super.method_25393();
    }

    private void updateCloth() {
        long time = System.nanoTime();
        double passedTime = (double)(System.nanoTime() - this.lastTime) / 1.0E9;
        this.lastTime = time;
        this.timeDelta += passedTime;
        while (this.timeDelta >= 0.016666666666666666) {
            this.timeDelta -= 0.016666666666666666;
            this.rotationSpeed = org.joml.Math.lerp((double)this.rotationSpeed, (double)0.0, (double)0.06);
            this.rotateEntity();
            for (VerletSimulation simulation : this.simulations.values()) {
                this.rotateCloth(simulation);
                simulation.update(null, 0.016666666666666666);
            }
        }
    }

    private void rotateCloth(VerletSimulation simulation) {
        class_4587 stack = new class_4587();
        stack.method_23760().method_23761().rotate((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, (float)(-Math.toRadians(this.totalRotation)), 0.0f));
        simulation.getConstraint(ModelPartConstraint.class).modelPartTransformation(stack);
        Matrix4d rotation = new Matrix4d((Matrix4fc)stack.method_23760().method_23761());
        ColladaMesh mesh = simulation.cloth.mesh;
        int size = mesh.positions.size();
        List<Vector3f> positions = mesh.positions;
        List<VerletPoint> points = simulation.getPoints();
        Vector3d tmp = new Vector3d();
        for (int i = 0; i < points.size() && i < size; ++i) {
            VerletPoint point = points.get(i);
            Vector3f pos = positions.get(i);
            tmp.set((double)pos.x, (double)pos.y, (double)pos.z);
            if (point.locked) {
                rotation.transformPosition(tmp);
                point.position.set((Vector3dc)tmp);
                continue;
            }
            if (point.softRestriction == null) continue;
            rotation.transformPosition(tmp);
            point.softRestriction.set((Vector3dc)tmp);
        }
    }

    private void rotateEntity() {
        this.totalRotation += this.rotationSpeed;
    }

    private void renderEntity() {
        class_4587 matrices = RenderSystem.getModelViewStack();
        float scale = (float)this.field_22790 * 0.215f;
        double xPosition = this.entityXPosition;
        double yPosition = (double)this.field_22790 * 0.5;
        float depth = 100.0f;
        matrices.method_22903();
        matrices.method_22904(xPosition, yPosition, (double)depth);
        matrices.method_22905(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        class_310.method_1551().field_1773.method_22974().method_3316();
        class_308.method_34742();
        RenderSystem.enableBlend();
        RenderSystem.enableCull();
        double mobWidth = this.endX - this.startX;
        double mobHeight = this.endY - this.startY;
        double mobDepth = this.endZ - this.startZ;
        float mobScale = -1.0f / (float)Math.max(mobWidth, Math.max(mobHeight, mobDepth)) * 2.0f;
        matrices.method_22905(mobScale, mobScale, mobScale);
        matrices.method_22904(-mobWidth * 0.5 - this.startX, -mobHeight * 0.5 + this.endY, -mobDepth * 0.5 - this.startZ);
        matrices.method_22907(new Quaternionf().rotationXYZ((float)Math.toRadians(-25.0), (float)Math.toRadians(this.totalRotation), (float)Math.toRadians(180.0)));
        RenderSystem.applyModelViewMatrix();
        try {
            class_1921 renderType = class_1921.method_23576((class_2960)this.textureLocation);
            if (this.partList != null && this.partList.getHovered() != null) {
                String selected = (String)((BaseEntry)this.partList.getHovered()).getUserData();
                for (class_630 part : ClothConstants.getModelParts(this.model)) {
                    if (selected.equals(((ModelPartParent)part).physicsmod$getName())) {
                        part.field_3665 = true;
                        continue;
                    }
                    part.field_3665 = false;
                }
            }
            ClothConstants.hideProperParts(this.selectedEntity, this.model);
            class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
            class_4588 vertexConsumer = bufferSource.getBuffer(renderType);
            this.model.method_2828(new class_4587(), vertexConsumer, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.0f);
            bufferSource.method_22993();
            for (class_630 part : ClothConstants.getModelParts(this.model)) {
                part.field_3665 = !part.field_3665;
            }
            ClothConstants.hideProperParts(this.selectedEntity, this.model);
            renderType = class_1921.method_23580((class_2960)this.textureLocation);
            vertexConsumer = bufferSource.getBuffer(renderType);
            this.model.method_2828(new class_4587(), vertexConsumer, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.175f);
            bufferSource.method_22993();
            for (class_630 part : ClothConstants.getModelParts(this.model)) {
                part.field_3665 = true;
            }
        }
        catch (Exception renderType) {
            // empty catch block
        }
        class_5944 shader = RenderSystem.getShader();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34501);
        RenderSystem.enableDepthTest();
        class_310.method_1551().field_1773.method_22974().method_3316();
        class_308.method_34742();
        RenderSystem.disableCull();
        RenderSystem.activeTexture((int)33984);
        this.renderStaticCloth(matrices);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_22904(xPosition, yPosition, (double)depth);
        matrices.method_22905(scale, scale, scale);
        matrices.method_22905(mobScale, mobScale, mobScale);
        matrices.method_22904(-mobWidth * 0.5 - this.startX, -mobHeight * 0.5 + this.endY, -mobDepth * 0.5 - this.startZ);
        matrices.method_22907(new Quaternionf().rotationXYZ((float)Math.toRadians(-25.0), 0.0f, (float)Math.toRadians(180.0)));
        RenderSystem.applyModelViewMatrix();
        this.renderCloth(matrices);
        matrices.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        RenderSystem.setShader(() -> shader);
    }

    private void renderCloth(class_4587 matrices) {
        for (VerletSimulation simulation : this.simulations.values()) {
            int brightness;
            int glID = simulation.textureID;
            RenderSystem.setShaderTexture((int)0, (int)glID);
            RenderSystem.bindTexture((int)glID);
            simulation.brightness = brightness = 0xF00000;
            if (!simulation.cloth.rules.isDynamic()) continue;
            simulation.render(matrices);
        }
    }

    private void renderStaticCloth(class_4587 matrices) {
        for (VerletSimulation simulation : this.simulations.values()) {
            int glID;
            int brightness = 0xF00000;
            matrices.method_22903();
            simulation.getConstraint(ModelPartConstraint.class).modelPartTransformation(matrices);
            RenderSystem.applyModelViewMatrix();
            if (!simulation.cloth.rules.isDynamic()) {
                glID = simulation.textureID;
                RenderSystem.setShaderTexture((int)0, (int)glID);
                RenderSystem.bindTexture((int)glID);
                simulation.cloth.mesh.renderSlow(brightness, ConfigClient.clothSmoothShading);
            }
            if (simulation.cloth.playerMesh != null && this.textureLocation != null) {
                glID = class_310.method_1551().method_1531().method_4619(this.textureLocation).method_4624();
                RenderSystem.setShaderTexture((int)0, (int)glID);
                RenderSystem.bindTexture((int)glID);
                simulation.cloth.playerMesh.renderSlow(brightness, false);
            }
            matrices.method_22909();
        }
    }

    public void loadModelAndTexture() {
        class_746 player;
        class_897 renderer = PhysicsMod.renderers.get(this.entityType);
        this.textureLocation = MobEntry.getTextureLocation(renderer, this.entityType);
        this.model = MobEntry.getModel(renderer, this.entityType);
        class_3879 class_38792 = this.model;
        if (class_38792 instanceof class_583) {
            class_583 entityModel = (class_583)class_38792;
            entityModel.field_3448 = false;
        }
        if (this.entityType == class_1299.field_6097 && (player = class_310.method_1551().field_1724) != null) {
            renderer = class_310.method_1551().method_1561().method_3953((class_1297)player);
            this.textureLocation = MobEntry.getTextureLocation(renderer, this.entityType, (class_1297)player);
            this.model = MobEntry.getModel(renderer, this.entityType, (class_1297)player);
            class_3879 class_38793 = this.model;
            if (class_38793 instanceof class_583) {
                class_583 entityModel = (class_583)class_38793;
                entityModel.field_3448 = false;
            }
        }
        PhysicsMod.sodiumCatchBoundingBox = true;
        PhysicsMod.sodiumBoundingBox.start.set(Double.MAX_VALUE);
        PhysicsMod.sodiumBoundingBox.end.set(-1.7976931348623157E308);
        try {
            BoundingBoxGetter boundingBox = StarterClient.sodium ? Sodium.getNewBoundingBoxConsumer() : new BoundingBoxGetter();
            this.model.method_2828(new class_4587(), (class_4588)boundingBox, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.0f);
            if (StarterClient.sodium) {
                boundingBox.min = PhysicsMod.sodiumBoundingBox.getMin();
                boundingBox.max = PhysicsMod.sodiumBoundingBox.getMax();
            }
            this.startX = boundingBox.min.x;
            this.endX = boundingBox.max.x;
            this.startY = boundingBox.min.y;
            this.endY = boundingBox.max.y;
            this.startZ = boundingBox.min.z;
            this.endZ = boundingBox.max.z;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PhysicsMod.sodiumCatchBoundingBox = false;
    }

    public void loadCloth() {
        Map<String, ConfigCloth.ClothList> customizations = ConfigCloth.getCustomizationParts(this.selectedEntity);
        this.simulations = new Object2ObjectOpenHashMap();
        if (customizations == null) {
            return;
        }
        for (Map.Entry<String, ConfigCloth.ClothList> clothParts : customizations.entrySet()) {
            String modelPart = clothParts.getKey();
            ConfigCloth.ClothList clothList = clothParts.getValue();
            for (String clothPart : clothList.getClothPieces()) {
                Cloth cloth = PhysicsMod.cloth.get(clothPart);
                if (cloth == null) continue;
                VerletSimulation simulation = new VerletSimulation(new Vector3d((Vector3fc)DynamicsWorld.DEFAULT_GRAVITY).negate(), 45, 0.92, new Vector3d(0.0));
                ModelPartConstraint modelPartConstraint = new ModelPartConstraint(simulation, cloth.rules.getIgnoreParts(), null, modelPart, this.model);
                modelPartConstraint.setCustomTransformation(matrix -> matrix.method_22907(new Quaternionf().rotationXYZ(0.0f, (float)(-Math.toRadians(this.totalRotation)), 0.0f)));
                simulation.addConstraint(modelPartConstraint);
                class_4587 modelMatrix = new class_4587();
                modelMatrix.method_23760().method_23761().rotate((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, (float)(-Math.toRadians(this.totalRotation)), 0.0f));
                modelPartConstraint.modelPartTransformation(modelMatrix);
                Matrix4d partTransformation = new Matrix4d((Matrix4fc)modelMatrix.method_23760().method_23761());
                int texture = cloth.getTexture(null);
                if (texture == -1) {
                    texture = class_310.method_1551().method_1531().method_4619(this.textureLocation).method_4624();
                }
                simulation.addCloth(cloth, texture, partTransformation, false);
                simulation.setTransformation(partTransformation);
                simulation.setBufferTransformation(partTransformation);
                simulation.updateOffsets();
                simulation.calculateNormals();
                modelPartConstraint.initAsyncData(null, simulation);
                modelPartConstraint.changeInstantly = true;
                modelPartConstraint.updateAfter(0.0, simulation);
                simulation.downloadData();
                this.simulations.put(modelPart + clothPart, simulation);
            }
        }
    }

    public String getSelectedEntity() {
        return this.selectedEntity;
    }

    public void setSelectedEntity(String selectedEntity) {
        this.selectedEntity = selectedEntity;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
        ConfigCloth.isChangingPlayer = false;
        Object2ObjectOpenHashMap toCheck = ConfigCloth.getCustomizationParts("physicsmod:yourself");
        if (toCheck == null) {
            toCheck = new Object2ObjectOpenHashMap();
        }
        if (!toCheck.equals(this.playerCopy)) {
            UUID uuid = ConfigCloth.getMinecraftUUID();
            if (uuid != null) {
                String uuidString = uuid.toString();
                ConfigCloth.setCustomizationParts(uuidString, (Map<String, ConfigCloth.ClothList>)toCheck);
                JsonArray array = new JsonArray();
                for (Map.Entry entry : toCheck.entrySet()) {
                    for (String part : ((ConfigCloth.ClothList)entry.getValue()).getClothPieces()) {
                        array.add(part);
                    }
                }
            } else {
                StarterClient.logger.error("Couldn't find player uuid");
            }
        }
        ConfigCloth.save();
        PhysicsMod.resetClothSimulations();
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
    }
}

