/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.ux;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.math.Math;
import net.diebuddies.mixins.guiphysics.MixinAbstractWidgetAccessor;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.Animator;
import net.diebuddies.physics.settings.ux.BaseColors;
import net.diebuddies.physics.settings.ux.TextAlignment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4264;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class ButtonRenderer
extends Animator {
    private TextAlignment alignment;
    private boolean renderTooltips = true;
    private class_124 chatFormatting;
    private class_2960 image;

    public ButtonRenderer(TextAlignment alignment, class_124 chatFormatting) {
        this.chatFormatting = chatFormatting;
        this.alignment = alignment;
    }

    public ButtonRenderer(TextAlignment alignment) {
        this(alignment, null);
    }

    public ButtonRenderer() {
        this(TextAlignment.CENTER);
    }

    @Override
    public boolean render(Animatable animatable, class_332 guiGraphics, int mouseX, int mouseY, float renderPercent, float delta) {
        boolean hovered = animatable.isInside(mouseX, mouseY);
        if (animatable instanceof MixinAbstractWidgetAccessor) {
            MixinAbstractWidgetAccessor accessor = (MixinAbstractWidgetAccessor)((Object)animatable);
            boolean wasHovered = accessor.getIsHovered();
            accessor.setIsHovered(hovered);
            if (!wasHovered && hovered) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15002, (float)(Math.random() * 0.2f + 0.9f)));
            }
        }
        int color = BaseColors.BACKGROUND_COLOR;
        float x = animatable.getAnimX();
        float y = animatable.getAnimY();
        float width = animatable.getAnimWidth();
        float height = animatable.getAnimHeight();
        float depth = animatable.getAnimDepth();
        class_4587 matrices = guiGraphics.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, depth);
        depth = -2.0f;
        class_4264 button = (class_4264)animatable;
        if (!button.field_22763) {
            color = BaseColors.INACTIVE_COLOR;
        }
        Matrix4f pose = matrices.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        ButtonRenderer.drawRect(bufferBuilder, pose, x, y, width, height, depth, color);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        if (this.image != null) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.image);
            RenderSystem.setShaderColor((float)animatable.getAnimRed(), (float)animatable.getAnimGreen(), (float)animatable.getAnimBlue(), (float)animatable.getAnimAlpha());
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            ButtonRenderer.drawRect(bufferBuilder, pose, x, y, width, height, depth, 0.0f, 1.0f, 0.0f, 1.0f);
            class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.disableBlend();
        class_5481 formattedCharSequence = (this.chatFormatting == null ? button.method_25369() : button.method_25369().method_27661().method_27692(this.chatFormatting)).method_30937();
        class_327 font = class_310.method_1551().field_1772;
        float xText = x + 7.0f;
        if (this.alignment == TextAlignment.CENTER) {
            xText = x + width * 0.5f - (float)font.method_30880(formattedCharSequence) * 0.5f;
        } else if (this.alignment == TextAlignment.RIGHT) {
            xText = x + width - (float)font.method_30880(formattedCharSequence) - 7.0f;
        }
        ButtonRenderer.drawText(guiGraphics, font, formattedCharSequence, Math.fastRound(xText), Math.fastRound(y + (height - 8.0f) / 2.0f));
        matrices.method_22909();
        if (this.renderTooltips && animatable instanceof MixinAbstractWidgetAccessor) {
            class_339 widget;
            MixinAbstractWidgetAccessor invoker = (MixinAbstractWidgetAccessor)((Object)animatable);
            if (animatable instanceof class_339 && (widget = (class_339)animatable).method_25367()) {
                invoker.invokeUpdateTooltip();
            }
        }
        return true;
    }

    public ButtonRenderer setRenderTooltips(boolean renderTooltips) {
        this.renderTooltips = renderTooltips;
        return this;
    }

    public boolean isRenderingTooltips() {
        return this.renderTooltips;
    }

    public class_2960 getImage() {
        return this.image;
    }

    public ButtonRenderer setImage(class_2960 image) {
        this.image = image;
        return this;
    }
}

