/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.ux;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.opengl.ResourceManager;
import net.diebuddies.opengl.Texture;
import net.diebuddies.physics.liquid.SimpleTextureDimension;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.Animator;
import net.diebuddies.render.MainRenderer;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5944;
import net.minecraft.class_6382;
import org.joml.Matrix4f;

public class ImageElement
extends class_339 {
    private ResourceManager resourceManager;
    private float textureWidth;
    private float textureHeight;
    private float textureAspectRatio;
    private Texture texture;
    private class_2960 imageLocation;
    private boolean keepAspectRatio;
    private class_5944 shader;
    private float time;

    public ImageElement(class_2960 imageLocation, float x, float y, float width, float height, boolean keepAspectRatio) {
        super((int)x, (int)y, (int)width, (int)height, null);
        this.imageLocation = imageLocation;
        this.keepAspectRatio = keepAspectRatio;
        class_1060 textureManager = class_310.method_1551().method_1531();
        class_1044 abstractTexture = textureManager.method_4619(imageLocation);
        abstractTexture.method_4527(true, true);
        if (abstractTexture instanceof SimpleTextureDimension) {
            SimpleTextureDimension textureDimension = (SimpleTextureDimension)abstractTexture;
            this.textureWidth = textureDimension.getWidth();
            this.textureHeight = textureDimension.getHeight();
        } else {
            this.textureWidth = width;
            this.textureHeight = height;
        }
        this.textureAspectRatio = this.textureWidth / this.textureHeight;
        this.shader = MainRenderer.getParallaxShader();
    }

    public ImageElement(ResourceManager resourceManager, class_2960 imageLocation, float x, float y, float width, float height, boolean keepAspectRatio) {
        super((int)x, (int)y, (int)width, (int)height, null);
        this.resourceManager = resourceManager;
        this.imageLocation = imageLocation;
        this.keepAspectRatio = keepAspectRatio;
        this.shader = MainRenderer.getParallaxShader();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        this.time += delta / 20.0f;
        Animatable ths = (Animatable)((Object)this);
        RenderSystem.setShader(() -> this.shader);
        float fogStart = RenderSystem.getShaderFogStart();
        RenderSystem.setShaderFogStart((float)this.time);
        if (this.resourceManager != null) {
            RenderSystem.setShaderTexture((int)0, (int)this.texture.getID());
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.getImageLocation());
        }
        RenderSystem.setShaderColor((float)ths.getAnimRed(), (float)ths.getAnimGreen(), (float)ths.getAnimBlue(), (float)ths.getAnimAlpha());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        float umin = 0.0f;
        float umax = 1.0f;
        float vmin = 0.0f;
        float vmax = 1.0f;
        if (this.keepAspectRatio) {
            float panelAspectRatio = ths.getAnimWidth() / ths.getAnimHeight();
            if (this.textureAspectRatio < panelAspectRatio) {
                multiplier = panelAspectRatio / this.textureAspectRatio;
                half = (1.0f - (vmax /= multiplier)) * 0.5f;
                vmax += half;
                vmin += half;
            } else {
                multiplier = panelAspectRatio / this.textureAspectRatio;
                half = (1.0f - (umax *= multiplier)) * 0.5f;
                umax += half;
                umin += half;
            }
        }
        float x = ths.getAnimX();
        float y = ths.getAnimY();
        float width = ths.getAnimWidth();
        float height = ths.getAnimHeight();
        float depth = ths.getAnimDepth();
        Matrix4f pose = guiGraphics.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        Animator.drawRect(bufferBuilder, pose, x, y, width, height, depth, umin, umax, vmin, vmax);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderFogStart((float)fogStart);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
    }

    public class_2960 getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(class_2960 imageLocation) {
        this.imageLocation = imageLocation;
    }

    public void method_47399(class_6382 var1) {
    }

    public void destroyLoadedTexture() {
        if (this.resourceManager != null) {
            this.resourceManager.destroyTexture(this.imageLocation);
            this.texture = null;
        }
    }

    public boolean loadImage() {
        if (this.resourceManager == null) {
            return true;
        }
        if (this.texture == null) {
            this.texture = this.resourceManager.getTexture(this.imageLocation, false, Texture.FILTER_LOAD_GUI_TEXTURE);
            return false;
        }
        this.resourceManager.update();
        if (this.texture.getID() == -1) {
            return false;
        }
        this.textureWidth = this.texture.getWidth();
        this.textureHeight = this.texture.getHeight();
        this.textureAspectRatio = this.textureWidth / this.textureHeight;
        return true;
    }

    public ImageElement setShader(class_5944 shader) {
        this.shader = shader;
        return this;
    }
}

