/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.wind;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Random;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.math.PerlinNoise;
import net.diebuddies.physics.PhysicsWorld;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import org.joml.Vector2d;
import org.joml.Vector3f;

public class WeatherDomain {
    private static final int DOMAIN_MODIFIER = 0;
    private static final int RESET_FORCES_EVERY_X_TICKS = 8;
    private static final int REMOVE_CACHE_DISTANCE = 16900;
    private final Long2IntMap cachedHeights = new Long2IntOpenHashMap();
    private Long2ObjectMap<Vector3f> windForces = new Long2ObjectOpenHashMap();
    private PhysicsWorld physics;
    private double delta;
    private int updateCount;
    private PerlinNoise perlin;
    private class_2338.class_2339 tmp = new class_2338.class_2339();

    public WeatherDomain(PhysicsWorld physics) {
        this.physics = physics;
        this.perlin = new PerlinNoise(new Random());
    }

    public Vector3f getWindDirection(int x, int y, int z) {
        long blockPos = class_2338.method_10064((int)(x >> 0), (int)(y >> 0), (int)(z >> 0));
        return (Vector3f)this.windForces.computeIfAbsent(blockPos, key -> this.computeWindDirection(x >> 0, y >> 0, z >> 0));
    }

    public float getWindStrength(int x, int y, int z) {
        int height = this.cachedHeights.computeIfAbsent(class_2338.method_10064((int)x, (int)0, (int)z), key -> this.computeWindHeight(x, z));
        if (y >= height) {
            return this.getWindStrengthFast();
        }
        return 0.0f;
    }

    private int computeWindHeight(int x, int z) {
        class_1937 level = this.physics.getLevel();
        int motionBlocking = level.method_8624(class_2902.class_2903.field_13197, x, z);
        this.tmp.method_33097(x);
        this.tmp.method_33099(z);
        for (int y = motionBlocking; y >= level.method_31607(); --y) {
            this.tmp.method_33098(y);
            class_2680 state = level.method_8320((class_2338)this.tmp);
            if (state.method_26215() || !state.method_26234((class_1922)level, (class_2338)this.tmp) && state.method_26167((class_1922)level, (class_2338)this.tmp) || state.method_26204() instanceof class_2397) continue;
            return y;
        }
        return level.method_31607();
    }

    public void blockUpdate(class_2338 pos) {
        long blockPos = class_2338.method_10064((int)pos.method_10263(), (int)0, (int)pos.method_10260());
        if (this.cachedHeights.containsKey(blockPos)) {
            int currentHeight = this.cachedHeights.get(blockPos);
            if (pos.method_10264() >= currentHeight) {
                this.cachedHeights.remove(blockPos);
            }
        }
    }

    public float getWindStrengthFast() {
        float rainLevel = this.physics.getLevel().method_8430(1.0f);
        float thunderLevel = this.physics.getLevel().method_8478(1.0f);
        return (rainLevel * ConfigClient.weatherRainStrength + thunderLevel * ConfigClient.weatherThunderStrength) * 0.3333f + ConfigClient.weatherClearStrength;
    }

    private Vector3f computeWindDirection(int x, int y, int z) {
        z *= 5;
        double wind = this.perlin.noise(this.perlin.noise((double)(x *= 5) / 45.0, (double)(y *= 5) / 45.0, this.delta / 4000.0) * 1.0 + (double)x / 50.0, this.perlin.noise((double)x / 35.0, (double)y / 35.0, this.delta / 4000.0) * 1.0 + (double)y / 50.0);
        double scale = 0.1;
        double bigWind = this.perlin.noise(this.perlin.noise((double)x / 45.0 * scale, (double)y / 45.0 * scale, this.delta / 4000.0) * 4.0 + (double)x / 50.0 * scale, this.perlin.noise((double)x / 35.0 * scale, (double)y / 35.0 * scale, this.delta / 4000.0) * 4.0 + (double)y / 50.0 * scale);
        double jitter = this.perlin.noise(this.perlin.noise((double)x / 25.0, (double)y / 25.0, this.delta / 100.0) * 1.0 + (double)x / 20.0, this.perlin.noise((double)x / 15.0, (double)y / 15.0, this.delta / 100.0) * 1.0 + (double)y / 20.0);
        double windForce = Math.clamp((bigWind * 0.5 + 0.5) * 0.7 + (wind * 0.5 + 0.0) * 0.25 + (jitter * 0.5 + 0.5) * 0.05, 0.0, 1.0);
        double upScale = 0.1;
        double upWind = this.perlin.noise(this.perlin.noise((double)x / 45.0 * upScale, (double)y / 45.0 * upScale, this.delta / 4000.0) * 1.0 + (double)x / 50.0 * upScale, this.perlin.noise((double)x / 35.0 * upScale, (double)y / 35.0 * upScale, this.delta / 4000.0) * 1.0 + (double)y / 50.0 * upScale);
        double upForce = Math.clamp(upWind, 0.0, 1.0);
        double angle = org.joml.Math.toRadians((double)((this.perlin.noise(0.2412, this.delta / 200000.0) + this.perlin.noise(0.74128, this.delta / 50.0) * 0.005) * 1080.0));
        double windX = org.joml.Math.sin((double)angle) * windForce;
        double windZ = org.joml.Math.cos((double)angle) * windForce;
        double windY = upForce;
        return new Vector3f((float)windX, (float)windY, (float)windZ);
    }

    public void update(double diff) {
        this.delta += diff * 1000.0;
        ++this.updateCount;
        if (this.updateCount >= 8) {
            class_2338 cameraPos = class_310.method_1551().field_1773.method_19418().method_19328();
            this.windForces.clear();
            ObjectIterator it = this.cachedHeights.long2IntEntrySet().iterator();
            while (it.hasNext()) {
                Long2IntMap.Entry entry = (Long2IntMap.Entry)it.next();
                long blockPos = entry.getLongKey();
                this.tmp.method_16363(blockPos);
                double lengthSquared = Vector2d.distanceSquared((double)this.tmp.method_10263(), (double)this.tmp.method_10260(), (double)cameraPos.method_10263(), (double)cameraPos.method_10260());
                if (!(lengthSquared > 16900.0)) continue;
                it.remove();
            }
            this.updateCount = 0;
        }
    }
}

