/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.tr7zw.skinlayers.Config;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.config.CustomConfigScreen;
import dev.tr7zw.skinlayers.render.PreviewHelper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_7172;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SkinLayersModBase {
    public static SkinLayersModBase instance;
    public static final Logger LOGGER;
    public static Config config;
    private File settingsFile = new File("config", "skinlayers.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static boolean disguiseHeadsCompatibility;

    public void onInitialize() {
        instance = this;
        if (this.settingsFile.exists()) {
            try {
                config = (Config)new Gson().fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), Config.class);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (config == null) {
            config = new Config();
            this.writeConfig();
        }
        try {
            Class<?> clientClass = Class.forName("dev.tr7zw.disguiseheads.DisguiseHeadsShared");
            disguiseHeadsCompatibility = clientClass != null;
            LOGGER.info("Found DisguiseHeads, enable compatibility!");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void writeConfig() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public class_437 createConfigScreen(class_437 parent) {
        CustomConfigScreen screen = new CustomConfigScreen(parent, "text.skinlayers.title"){

            @Override
            public void initialize() {
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getOnOffOption("text.skinlayers.enable.hat", () -> SkinLayersModBase.config.enableHat, b -> {
                    SkinLayersModBase.config.enableHat = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.jacket", () -> SkinLayersModBase.config.enableJacket, b -> {
                    SkinLayersModBase.config.enableJacket = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.leftsleeve", () -> SkinLayersModBase.config.enableLeftSleeve, b -> {
                    SkinLayersModBase.config.enableLeftSleeve = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.rightsleeve", () -> SkinLayersModBase.config.enableRightSleeve, b -> {
                    SkinLayersModBase.config.enableRightSleeve = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.leftpants", () -> SkinLayersModBase.config.enableLeftPants, b -> {
                    SkinLayersModBase.config.enableLeftPants = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.rightpants", () -> SkinLayersModBase.config.enableRightPants, b -> {
                    SkinLayersModBase.config.enableRightPants = b;
                }));
                options.add(this.getIntOption("text.skinlayers.renderdistancelod", 5, 40, () -> SkinLayersModBase.config.renderDistanceLOD, i -> {
                    SkinLayersModBase.config.renderDistanceLOD = i;
                }));
                options.add(this.getDoubleOption("text.skinlayers.basevoxelsize", 1.001f, 1.4f, 0.001f, () -> SkinLayersModBase.config.baseVoxelSize, i -> {
                    SkinLayersModBase.config.baseVoxelSize = i.floatValue();
                    SkinLayersModBase.this.refreshLayers((class_1657)this.field_22787.field_1724);
                }));
                options.add(this.getDoubleOption("text.skinlayers.headvoxelsize", 1.001f, 1.25f, 0.001f, () -> SkinLayersModBase.config.headVoxelSize, i -> {
                    SkinLayersModBase.config.headVoxelSize = i.floatValue();
                    SkinLayersModBase.this.refreshLayers((class_1657)this.field_22787.field_1724);
                }));
                options.add(this.getDoubleOption("text.skinlayers.bodyvoxelwidthsize", 1.001f, 1.4f, 0.001f, () -> SkinLayersModBase.config.bodyVoxelWidthSize, i -> {
                    SkinLayersModBase.config.bodyVoxelWidthSize = i.floatValue();
                    SkinLayersModBase.this.refreshLayers((class_1657)this.field_22787.field_1724);
                }));
                options.add(this.getOnOffOption("text.skinlayers.skulls.enable", () -> SkinLayersModBase.config.enableSkulls, b -> {
                    SkinLayersModBase.config.enableSkulls = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.skullsitems.enable", () -> SkinLayersModBase.config.enableSkullsItems, b -> {
                    SkinLayersModBase.config.enableSkullsItems = b;
                }));
                options.add(this.getDoubleOption("text.skinlayers.skulls.voxelsize", 1.001f, 1.2f, 0.001f, () -> SkinLayersModBase.config.skullVoxelSize, i -> {
                    SkinLayersModBase.config.skullVoxelSize = i.floatValue();
                }));
                options.add(this.getOnOffOption("text.skinlayers.fastrender.enable", () -> SkinLayersModBase.config.fastRender, b -> {
                    SkinLayersModBase.config.fastRender = b;
                }));
                options.add(this.getDoubleOption("text.skinlayers.firstperson.voxelsize", 1.02f, 1.2f, 0.001f, () -> SkinLayersModBase.config.firstPersonPixelScaling, i -> {
                    SkinLayersModBase.config.firstPersonPixelScaling = i.floatValue();
                }));
                this.getOptions().method_20408(options.toArray(new class_7172[0]));
            }

            @Override
            public void save() {
                SkinLayersModBase.this.writeConfig();
            }

            @Override
            public void method_25394(class_332 guiGraphics, int xMouse, int yMouse, float f) {
                super.method_25394(guiGraphics, xMouse, yMouse, f);
                if (this.field_22787.field_1687 != null) {
                    int x = this.field_22787.method_22683().method_4486() / 2;
                    int y = this.field_22787.method_22683().method_4502() - 45;
                    int size = (int)(40.0f * ((float)this.field_22787.method_22683().method_4502() / 200.0f));
                    float lookX = x - xMouse;
                    float lookY = y - 80 - yMouse;
                    lookY = Math.min(lookY, 10.0f);
                    PreviewHelper.renderEntityInInventoryFollowsMouse(guiGraphics, x, y, size, lookX, lookY, (class_1309)this.field_22787.field_1724);
                }
            }

            @Override
            public void reset() {
                config = new Config();
                SkinLayersModBase.this.writeConfig();
            }
        };
        return screen;
    }

    public void refreshLayers(class_1657 player) {
        if (player == null || !(player instanceof PlayerSettings)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        settings.clearMeshes();
        settings.setCurrentSkin(null);
    }

    static {
        LOGGER = LogManager.getLogger();
        config = null;
        disguiseHeadsCompatibility = false;
    }
}

