/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSource;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;

public final class ItemLightSources {
    private static final Map<class_1792, ItemLightSource> ITEM_LIGHT_SOURCES = new Reference2ObjectOpenHashMap();
    private static final Map<class_1792, ItemLightSource> STATIC_ITEM_LIGHT_SOURCES = new Reference2ObjectOpenHashMap();

    private ItemLightSources() {
        throw new UnsupportedOperationException("ItemLightSources only contains static definitions.");
    }

    public static void load(class_3300 resourceManager) {
        ITEM_LIGHT_SOURCES.clear();
        resourceManager.method_14488("dynamiclights/item", path -> path.method_12832().endsWith(".json")).forEach(ItemLightSources::load);
        ITEM_LIGHT_SOURCES.putAll(STATIC_ITEM_LIGHT_SOURCES);
    }

    private static void load(class_2960 resourceId, class_3298 resource) {
        class_2960 id = new class_2960(resourceId.method_12836(), resourceId.method_12832().replace(".json", ""));
        try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            ItemLightSource.fromJson(id, json).ifPresent(data -> {
                if (!STATIC_ITEM_LIGHT_SOURCES.containsKey(data.item())) {
                    ItemLightSources.register(data);
                }
            });
        }
        catch (IOException | IllegalStateException e) {
            LambDynLights.get().warn("Failed to load item light source \"" + String.valueOf(id) + "\".");
        }
    }

    private static void register(ItemLightSource data) {
        ItemLightSource other = ITEM_LIGHT_SOURCES.get(data.item());
        if (other != null) {
            LambDynLights.get().warn("Failed to register item light source \"" + String.valueOf(data.id()) + "\", duplicates item \"" + String.valueOf(class_7923.field_41178.method_10221((Object)data.item())) + "\" found in \"" + String.valueOf(other.id()) + "\".");
            return;
        }
        ITEM_LIGHT_SOURCES.put(data.item(), data);
    }

    public static void registerItemLightSource(ItemLightSource data) {
        ItemLightSource other = STATIC_ITEM_LIGHT_SOURCES.get(data.item());
        if (other != null) {
            LambDynLights.get().warn("Failed to register item light source \"" + String.valueOf(data.id()) + "\", duplicates item \"" + String.valueOf(class_7923.field_41178.method_10221((Object)data.item())) + "\" found in \"" + String.valueOf(other.id()) + "\".");
            return;
        }
        STATIC_ITEM_LIGHT_SOURCES.put(data.item(), data);
    }

    public static int getLuminance(class_1799 stack, boolean submergedInWater) {
        ItemLightSource data = ITEM_LIGHT_SOURCES.get(stack.method_7909());
        if (data != null) {
            return data.getLuminance(stack, submergedInWater);
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return ItemLightSource.BlockItemLightSource.getLuminance(stack, blockItem.method_7711().method_9564());
        }
        return 0;
    }
}

