/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.DynamicLightsMode;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2586.class})
public abstract class BlockEntityMixin
implements DynamicLightSource {
    @Final
    @Shadow
    protected class_2338 field_11867;
    @Shadow
    @Nullable
    protected class_1937 field_11863;
    @Shadow
    protected boolean field_11865;
    @Unique
    private int luminance = 0;
    @Unique
    private int lastLuminance = 0;
    @Unique
    private long lastUpdate = 0L;
    @Unique
    private final LongOpenHashSet lambdynlights$trackedLitChunkPos = new LongOpenHashSet();

    @Override
    public double getDynamicLightX() {
        return (double)this.field_11867.method_10263() + 0.5;
    }

    @Override
    public double getDynamicLightY() {
        return (double)this.field_11867.method_10264() + 0.5;
    }

    @Override
    public double getDynamicLightZ() {
        return (double)this.field_11867.method_10260() + 0.5;
    }

    @Override
    public class_1937 getDynamicLightWorld() {
        return this.field_11863;
    }

    @Inject(method={"markRemoved"}, at={@At(value="TAIL")})
    private void onRemoved(CallbackInfo ci) {
        this.setDynamicLightEnabled(false);
    }

    @Override
    public void resetDynamicLight() {
        this.lastLuminance = 0;
    }

    @Override
    public void dynamicLightTick() {
        if (this.field_11863 == null || !this.field_11863.method_8608()) {
            return;
        }
        if (!this.field_11865) {
            this.luminance = DynamicLightHandlers.getLuminanceFrom((class_2586)this);
            LambDynLights.updateTracking(this);
            if (!this.isDynamicLightEnabled()) {
                this.lastLuminance = 0;
            }
        }
    }

    @Override
    public int getLuminance() {
        return this.luminance;
    }

    @Override
    public boolean shouldUpdateDynamicLight() {
        DynamicLightsMode mode = LambDynLights.get().config.getDynamicLightsMode();
        if (!mode.isEnabled()) {
            return false;
        }
        if (mode.hasDelay()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.lastUpdate + (long)mode.getDelay()) {
                return false;
            }
            this.lastUpdate = currentTime;
        }
        return true;
    }

    @Override
    public boolean lambdynlights$updateDynamicLight(@NotNull class_761 renderer) {
        if (!this.shouldUpdateDynamicLight()) {
            return false;
        }
        int luminance = this.getLuminance();
        if (luminance != this.lastLuminance) {
            this.lastLuminance = luminance;
            if (this.lambdynlights$trackedLitChunkPos.isEmpty()) {
                class_2338.class_2339 chunkPos = new class_2338.class_2339(class_3532.method_48116((int)this.field_11867.method_10263(), (int)16), class_3532.method_48116((int)this.field_11867.method_10264(), (int)16), class_3532.method_48116((int)this.field_11867.method_10260(), (int)16));
                LambDynLights.updateTrackedChunks((class_2338)chunkPos, null, this.lambdynlights$trackedLitChunkPos);
                class_2350 directionX = (this.field_11867.method_10263() & 0xF) >= 8 ? class_2350.field_11034 : class_2350.field_11039;
                class_2350 directionY = (this.field_11867.method_10264() & 0xF) >= 8 ? class_2350.field_11036 : class_2350.field_11033;
                class_2350 directionZ = (this.field_11867.method_10260() & 0xF) >= 8 ? class_2350.field_11035 : class_2350.field_11043;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.method_10098(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.method_10098(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.method_10098(directionX.method_10153());
                    } else {
                        chunkPos.method_10098(directionZ.method_10153());
                        chunkPos.method_10098(directionY);
                    }
                    LambDynLights.updateTrackedChunks((class_2338)chunkPos, null, this.lambdynlights$trackedLitChunkPos);
                }
            }
            this.lambdynlights$scheduleTrackedChunksRebuild(renderer);
            return true;
        }
        return false;
    }

    @Override
    public void lambdynlights$scheduleTrackedChunksRebuild(@NotNull class_761 renderer) {
        if (this.field_11863 == class_310.method_1551().field_1687) {
            LongIterator longIterator = this.lambdynlights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                LambDynLights.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

