/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.updater;

import com.seibel.distanthorizons.api.enums.config.EDhApiUpdateBranch;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.jar.ModJarInfo;
import com.seibel.distanthorizons.core.jar.installer.ModrinthGetter;
import com.seibel.distanthorizons.core.jar.updater.SelfUpdater;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.Objects;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.DhScreen;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.GuiHelper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.TexturedButtonWidget;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.updater.ChangelogScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class UpdateModScreen
extends DhScreen {
    private Screen parent;
    private String newVersionID;
    private String currentVer;
    private String nextVer;

    public UpdateModScreen(Screen parent, String newVersionID) {
        super((Component)GuiHelper.Translatable("distanthorizons.updater.title", new Object[0]));
        this.parent = parent;
        this.newVersionID = newVersionID;
        EDhApiUpdateBranch updateBranch = EDhApiUpdateBranch.convertAutoToStableOrNightly(Config.Client.Advanced.AutoUpdater.updateBranch.get());
        if (updateBranch == EDhApiUpdateBranch.STABLE) {
            this.currentVer = "2.2.1-a";
            this.nextVer = ModrinthGetter.releaseNames.get(this.newVersionID);
        } else {
            this.currentVer = ModJarInfo.Git_Commit.substring(0, 7);
            this.nextVer = this.newVersionID.substring(0, 7);
        }
    }

    protected void init() {
        super.init();
        try {
            this.addBtn(new TexturedButtonWidget(this.width / 2 - 65, this.height / 2 - 110, 130, 65, 0, 0, 0, ResourceLocation.fromNamespaceAndPath((String)"distanthorizons", (String)"logo.png"), 130, 65, buttonWidget -> System.out.println("Nice, you found an easter egg :)"), (Component)GuiHelper.Translatable("distanthorizons.updater.title", new Object[0]), false));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!ModInfo.IS_DEV_BUILD) {
            this.addBtn(new TexturedButtonWidget(this.width / 2 - 97, this.height / 2 + 8, 20, 20, 0, 0, 0, ResourceLocation.fromNamespaceAndPath((String)"distanthorizons", (String)"textures/gui/changelog.png"), 20, 20, buttonWidget -> Objects.requireNonNull(this.minecraft).setScreen((Screen)new ChangelogScreen(this, this.newVersionID)), (Component)GuiHelper.Translatable("distanthorizons.updater.title", new Object[0])));
        }
        this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.updater.update", new Object[0]), this.width / 2 - 75, this.height / 2 + 8, 150, 20, btn -> {
            SelfUpdater.updateMod();
            this.onClose();
        }));
        this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.updater.silent", new Object[0]), this.width / 2 - 75, this.height / 2 + 30, 150, 20, btn -> {
            Config.Client.Advanced.AutoUpdater.enableSilentUpdates.set(true);
            SelfUpdater.updateMod();
            this.onClose();
        }));
        this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.updater.later", new Object[0]), this.width / 2 + 2, this.height / 2 + 70, 100, 20, btn -> this.onClose()));
        this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.updater.never", new Object[0]), this.width / 2 - 102, this.height / 2 + 70, 100, 20, btn -> {
            Config.Client.Advanced.AutoUpdater.enableAutoUpdater.set(false);
            this.onClose();
        }));
    }

    public void render(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices, mouseX, mouseY, delta);
        super.render(matrices, mouseX, mouseY, delta);
        this.DhDrawCenteredString(matrices, this.font, (Component)GuiHelper.Translatable("distanthorizons.updater.text1", new Object[0]), this.width / 2, this.height / 2 - 35, 0xFFFFFF);
        this.DhDrawCenteredString(matrices, this.font, (Component)GuiHelper.Translatable("distanthorizons.updater.text2", this.currentVer, this.nextVer), this.width / 2, this.height / 2 - 20, 5438802);
    }

    public void onClose() {
        Objects.requireNonNull(this.minecraft).setScreen(this.parent);
    }
}

