/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration;

import com.mojang.datafixers.DataFixer;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.WorldData;

public final class GlobalParameters {
    public final ChunkGenerator generator;
    public final StructureTemplateManager structures;
    public final RandomState randomState;
    public final WorldOptions worldOptions;
    public final IDhServerLevel lodLevel;
    public final ServerLevel level;
    public final Registry<Biome> biomes;
    public final RegistryAccess registry;
    public final long worldSeed;
    public final DataFixer fixerUpper;
    public final BiomeManager biomeManager;
    public final ChunkScanAccess chunkScanner;

    public GlobalParameters(IDhServerLevel lodLevel) {
        this.lodLevel = lodLevel;
        this.level = ((ServerLevelWrapper)lodLevel.getServerLevelWrapper()).getWrappedMcObject();
        MinecraftServer server = this.level.getServer();
        WorldData worldData = server.getWorldData();
        this.registry = server.registryAccess();
        this.worldOptions = worldData.worldGenOptions();
        this.biomes = this.registry.registryOrThrow(Registries.BIOME);
        this.worldSeed = this.worldOptions.seed();
        this.biomeManager = new BiomeManager((BiomeManager.NoiseBiomeSource)this.level, BiomeManager.obfuscateSeed((long)this.worldSeed));
        this.chunkScanner = this.level.getChunkSource().chunkScanner();
        this.structures = server.getStructureManager();
        this.generator = this.level.getChunkSource().getGenerator();
        this.fixerUpper = server.getFixerUpper();
        this.randomState = this.level.getChunkSource().randomState();
    }
}

