/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config;

import com.google.gson.JsonElement;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Locale;
import javax.annotation.Nullable;

public interface IConfigBase {
    public ConfigType getType();

    public String getName();

    default public String getLowerName() {
        return this.getName().toLowerCase(Locale.ROOT);
    }

    default public String getCleanName() {
        String result = this.getName();
        if (result.contains(".")) {
            result = result.replace('.', '_');
        }
        return result;
    }

    @Nullable
    public String getComment();

    default public String getPrettyName() {
        return this.getName();
    }

    default public String getConfigGuiDisplayName() {
        return StringUtils.getTranslatedOrFallback(this.getTranslatedName(), this.getName());
    }

    default public String getTranslatedName() {
        return this.getName();
    }

    public void setValueFromJsonElement(JsonElement var1);

    public JsonElement getAsJsonElement();
}

