/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal;

import com.seibel.distanthorizons.core.Initializer;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import com.seibel.distanthorizons.core.util.TimerUtil;
import com.seibel.distanthorizons.core.util.objects.Pair;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.DhClientServerWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.world.IDhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.ArrayList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SharedApi {
    public static final SharedApi INSTANCE = new SharedApi();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final Set<DhChunkPos> UPDATING_CHUNK_POS_SET = ConcurrentHashMap.newKeySet();
    private static final int MAX_UPDATING_CHUNK_COUNT_PER_THREAD = 500;
    private static final int MIN_MS_BETWEEN_OVERLOADED_LOG_MESSAGE = 30000;
    private static final Timer CHUNK_UPDATE_TIMER = TimerUtil.CreateTimer("ChunkUpdateTimer");
    private static AbstractDhWorld currentWorld;
    private static int lastWorldGenTickDelta;
    private static long lastOverloadedLogMessageMsTime;

    private SharedApi() {
    }

    public static void init() {
        Initializer.init();
    }

    public static EWorldEnvironment getEnvironment() {
        return currentWorld == null ? null : SharedApi.currentWorld.environment;
    }

    public static void setDhWorld(AbstractDhWorld newWorld) {
        currentWorld = newWorld;
        if (currentWorld != null) {
            ThreadPoolUtil.setupThreadPools();
        } else {
            ThreadPoolUtil.shutdownThreadPools();
            DebugRenderer.clearRenderables();
            MC_RENDER.clearTargetFrameBuffer();
            AbstractDhRepo.closeAllConnections();
            UPDATING_CHUNK_POS_SET.clear();
            System.gc();
        }
    }

    public static void worldGenTick(Runnable worldGenRunnable) {
        if (--lastWorldGenTickDelta <= 0) {
            worldGenRunnable.run();
            lastWorldGenTickDelta = 20;
        }
    }

    public static AbstractDhWorld getAbstractDhWorld() {
        return currentWorld;
    }

    public static DhClientServerWorld getDhClientServerWorld() {
        return currentWorld != null && DhClientServerWorld.class.isInstance(currentWorld) ? (DhClientServerWorld)currentWorld : null;
    }

    public static IDhClientWorld getIDhClientWorld() {
        return currentWorld != null && IDhClientWorld.class.isInstance(currentWorld) ? (IDhClientWorld)((Object)currentWorld) : null;
    }

    public static IDhServerWorld getIDhServerWorld() {
        return currentWorld != null && IDhServerWorld.class.isInstance(currentWorld) ? (IDhServerWorld)((Object)currentWorld) : null;
    }

    public static boolean isChunkAtBlockPosAlreadyUpdating(int blockPosX, int blockPosZ) {
        return UPDATING_CHUNK_POS_SET.contains(new DhChunkPos(new DhBlockPos2D(blockPosX, blockPosZ)));
    }

    public static boolean isChunkAtChunkPosAlreadyUpdating(int chunkPosX, int chunkPosZ) {
        return UPDATING_CHUNK_POS_SET.contains(new DhChunkPos(chunkPosX, chunkPosZ));
    }

    public void chunkBlockChangedEvent(IChunkWrapper chunk, ILevelWrapper level) {
        this.applyChunkUpdate(chunk, level, true);
    }

    public void chunkLoadEvent(IChunkWrapper chunk, ILevelWrapper level) {
        this.applyChunkUpdate(chunk, level, false);
    }

    public void applyChunkUpdate(IChunkWrapper chunkWrapper, ILevelWrapper level, boolean updateNeighborChunks) {
        int maxQueueCount;
        if (chunkWrapper == null) {
            return;
        }
        AbstractDhWorld dhWorld = SharedApi.getAbstractDhWorld();
        if (dhWorld == null) {
            if (level instanceof IClientLevelWrapper) {
                IClientLevelWrapper clientLevel = (IClientLevelWrapper)level;
                ClientApi.INSTANCE.waitingChunkByClientLevelAndPos.replace(new Pair<IClientLevelWrapper, DhChunkPos>(clientLevel, chunkWrapper.getChunkPos()), chunkWrapper);
            }
            return;
        }
        IDhLevel dhLevel = dhWorld.getLevel(level);
        if (dhLevel == null) {
            if (level instanceof IClientLevelWrapper) {
                IClientLevelWrapper clientLevel = (IClientLevelWrapper)level;
                ClientApi.INSTANCE.waitingChunkByClientLevelAndPos.replace(new Pair<IClientLevelWrapper, DhChunkPos>(clientLevel, chunkWrapper.getChunkPos()), chunkWrapper);
            }
            return;
        }
        int currentQueueCount = UPDATING_CHUNK_POS_SET.size();
        if (currentQueueCount >= (maxQueueCount = 500 * Config.Client.Advanced.MultiThreading.numberOfLodBuilderThreads.get())) {
            long msBetweenLastLog = System.currentTimeMillis() - lastOverloadedLogMessageMsTime;
            if (msBetweenLastLog >= 30000L) {
                lastOverloadedLogMessageMsTime = System.currentTimeMillis();
                String message = "Distant Horizons overloaded, too many chunks queued for updating. \nThis may result in holes in your LODs. \nPlease move through the world slower, decrease your vanilla render distance, slow down your world pre-generator, or increase the Distant Horizons' CPU load config. \nMax queue count [" + maxQueueCount + "] ([" + 500 + "] per thread).";
                ClientApi.INSTANCE.showChatMessageNextFrame(message);
                LOGGER.warn(message);
            }
            return;
        }
        if (UPDATING_CHUNK_POS_SET.contains(chunkWrapper.getChunkPos())) {
            return;
        }
        UPDATING_CHUNK_POS_SET.add(chunkWrapper.getChunkPos());
        if (!updateNeighborChunks) {
            SharedApi.bakeChunkLightingAndSendToLevelAsync(chunkWrapper, null, dhLevel);
        } else {
            ArrayList<IChunkWrapper> neighbourChunkList = new ArrayList<IChunkWrapper>(9);
            for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    if (xOffset == 0 && zOffset == 0) {
                        neighbourChunkList.add(chunkWrapper);
                        continue;
                    }
                    DhChunkPos neighbourPos = new DhChunkPos(chunkWrapper.getChunkPos().getX() + xOffset, chunkWrapper.getChunkPos().getZ() + zOffset);
                    IChunkWrapper neighbourChunk = dhLevel.getLevelWrapper().tryGetChunk(neighbourPos);
                    if (neighbourChunk == null) continue;
                    neighbourChunkList.add(neighbourChunk);
                }
            }
            for (IChunkWrapper litChunk : neighbourChunkList) {
                SharedApi.bakeChunkLightingAndSendToLevelAsync(litChunk, neighbourChunkList, dhLevel);
            }
        }
    }

    private static CompletableFuture<Void> bakeChunkLightingAndSendToLevelAsync(IChunkWrapper chunkWrapper, @Nullable ArrayList<IChunkWrapper> neighbourChunkList, IDhLevel dhLevel) {
        ThreadPoolExecutor executor = ThreadPoolUtil.getChunkToLodBuilderExecutor();
        if (executor == null) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            return CompletableFuture.runAsync(() -> {
                block18: {
                    int newChunkHash;
                    block16: {
                        block17: {
                            boolean checkChunkHash = Config.Client.Advanced.LodBuilding.disableUnchangedChunkCheck.get() == false;
                            int oldChunkHash = dhLevel.getChunkHash(chunkWrapper.getChunkPos());
                            newChunkHash = chunkWrapper.getBlockBiomeHashCode();
                            if (!checkChunkHash || oldChunkHash != newChunkHash) break block16;
                            int updateTimeoutInSec = Config.Client.Advanced.LodBuilding.minTimeBetweenChunkUpdatesInSeconds.get();
                            if (updateTimeoutInSec != 0) {
                                CHUNK_UPDATE_TIMER.schedule(new TimerTask(chunkWrapper){
                                    final /* synthetic */ IChunkWrapper val$chunkWrapper;
                                    {
                                        this.val$chunkWrapper = iChunkWrapper;
                                    }

                                    @Override
                                    public void run() {
                                        UPDATING_CHUNK_POS_SET.remove(this.val$chunkWrapper.getChunkPos());
                                    }
                                }, (long)updateTimeoutInSec * 1000L);
                                break block17;
                            }
                            UPDATING_CHUNK_POS_SET.remove(chunkWrapper.getChunkPos());
                        }
                        return;
                    }
                    try {
                        ArrayList<IChunkWrapper> nearbyChunkList;
                        if (neighbourChunkList != null) {
                            nearbyChunkList = neighbourChunkList;
                        } else {
                            nearbyChunkList = new ArrayList<IChunkWrapper>(1);
                            nearbyChunkList.add(chunkWrapper);
                        }
                        boolean tryUsingMcLightingEngine = false;
                        if (tryUsingMcLightingEngine) {
                            boolean chunkLightPopulated = false;
                            boolean onlyUseDhLighting = Config.Client.Advanced.LodBuilding.onlyUseDhLightingEngine.get();
                            if (!onlyUseDhLighting && chunkWrapper.isLightCorrect() && !(chunkLightPopulated = chunkWrapper.bakeDhLightingUsingMcLightingEngine(dhLevel.getLevelWrapper()))) {
                                chunkWrapper.clearDhBlockLighting();
                                chunkWrapper.clearDhSkyLighting();
                            }
                            if (!chunkLightPopulated) {
                                DhLightingEngine.INSTANCE.lightChunk(chunkWrapper, nearbyChunkList, dhLevel.hasSkyLight() ? 15 : 0);
                            }
                        } else {
                            DhLightingEngine.INSTANCE.lightChunk(chunkWrapper, nearbyChunkList, dhLevel.hasSkyLight() ? 15 : 0);
                        }
                        dhLevel.updateBeaconBeamsForChunk(chunkWrapper, nearbyChunkList);
                        dhLevel.updateChunkAsync(chunkWrapper, newChunkHash);
                        int updateTimeoutInSec = Config.Client.Advanced.LodBuilding.minTimeBetweenChunkUpdatesInSeconds.get();
                        if (updateTimeoutInSec != 0) {
                            CHUNK_UPDATE_TIMER.schedule(new /* invalid duplicate definition of identical inner class */, (long)updateTimeoutInSec * 1000L);
                            break block18;
                        }
                        UPDATING_CHUNK_POS_SET.remove(chunkWrapper.getChunkPos());
                    }
                    catch (Exception e) {
                        try {
                            LOGGER.error("Unexpected error when updating chunk at pos: [" + chunkWrapper.getChunkPos() + "]", (Throwable)e);
                            int updateTimeoutInSec = Config.Client.Advanced.LodBuilding.minTimeBetweenChunkUpdatesInSeconds.get();
                            if (updateTimeoutInSec != 0) {
                                CHUNK_UPDATE_TIMER.schedule(new /* invalid duplicate definition of identical inner class */, (long)updateTimeoutInSec * 1000L);
                                break block18;
                            }
                            UPDATING_CHUNK_POS_SET.remove(chunkWrapper.getChunkPos());
                        }
                        catch (Throwable throwable) {
                            int updateTimeoutInSec = Config.Client.Advanced.LodBuilding.minTimeBetweenChunkUpdatesInSeconds.get();
                            if (updateTimeoutInSec != 0) {
                                CHUNK_UPDATE_TIMER.schedule(new /* invalid duplicate definition of identical inner class */, (long)updateTimeoutInSec * 1000L);
                            } else {
                                UPDATING_CHUNK_POS_SET.remove(chunkWrapper.getChunkPos());
                            }
                            throw throwable;
                        }
                    }
                }
            }, executor);
        }
        catch (RejectedExecutionException ignore) {
            return CompletableFuture.completedFuture(null);
        }
    }

    public String getDebugMenuString() {
        int maxUpdateCount = 500 * Config.Client.Advanced.MultiThreading.numberOfLodBuilderThreads.get();
        String updatingCountStr = F3Screen.NUMBER_FORMAT.format(UPDATING_CHUNK_POS_SET.size());
        String maxUpdateCountStr = F3Screen.NUMBER_FORMAT.format(maxUpdateCount);
        return "Queued chunk updates: " + updatingCountStr + " / " + maxUpdateCountStr;
    }

    static {
        lastWorldGenTickDelta = 0;
        lastOverloadedLogMessageMsTime = 0L;
    }
}

