/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModChecker;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import com.seibel.distanthorizons.neoforge.NeoforgeClientProxy;
import com.seibel.distanthorizons.neoforge.NeoforgeServerProxy;
import com.seibel.distanthorizons.neoforge.wrappers.modAccessor.ModChecker;
import com.seibel.distanthorizons.neoforge.wrappers.modAccessor.OptifineAccessor;
import java.util.function.Consumer;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.AbstractModInitializer;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.gui.GetConfigScreen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="distanthorizons")
public class NeoforgeMain
extends AbstractModInitializer {
    public NeoforgeMain(IEventBus eventBus) {
        eventBus.addListener(e -> this.onInitializeClient());
        eventBus.addListener(e -> this.onInitializeServer());
    }

    @Override
    protected AbstractModInitializer.IEventProxy createServerProxy(boolean isDedicated) {
        return new NeoforgeServerProxy(isDedicated);
    }

    @Override
    protected void createInitialBindings() {
        SingletonInjector.INSTANCE.bind(IModChecker.class, ModChecker.INSTANCE);
    }

    @Override
    protected AbstractModInitializer.IEventProxy createClientProxy() {
        return new NeoforgeClientProxy();
    }

    @Override
    protected void initializeModCompat() {
        IModChecker modChecker;
        this.tryCreateModCompatAccessor("optifine", IOptifineAccessor.class, OptifineAccessor::new);
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, parent) -> GetConfigScreen.getScreen(parent));
        if (Config.Client.Advanced.Logging.showModCompatibilityWarningsOnStartup.get().booleanValue() && (modChecker = SingletonInjector.INSTANCE.get(IModChecker.class)).isModLoaded("alexscaves")) {
            String message = "\u00a76Distant Horizons: Alex's Cave detected.\u00a7r\nYou may have to change Alex's config for DH to render. ";
            ClientApi.INSTANCE.showChatMessageNextFrame(message);
        }
    }

    @Override
    protected void subscribeRegisterCommandsEvent(Consumer<CommandDispatcher<CommandSourceStack>> eventHandler) {
        NeoForge.EVENT_BUS.addListener(e -> eventHandler.accept(e.getDispatcher()));
    }

    @Override
    protected void subscribeClientStartedEvent(Runnable eventHandler) {
    }

    @Override
    protected void subscribeServerStartingEvent(Consumer<MinecraftServer> eventHandler) {
        NeoForge.EVENT_BUS.addListener(e -> eventHandler.accept(e.getServer()));
    }

    @Override
    protected void runDelayedSetup() {
        SingletonInjector.INSTANCE.runDelayedSetup();
    }
}

