/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.neoforge.mixins.client;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.neoforge.NeoforgeClientProxy;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class MixinLevelRenderer {
    @Shadow(remap=false)
    private ClientLevel level;

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/client/renderer/LevelRenderer;renderSectionLayer(Lnet/minecraft/client/renderer/RenderType;DDDLorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"}, cancellable=true)
    private void renderChunkLayer(RenderType renderType, double x, double y, double z, Matrix4f projectionMatrix, Matrix4f frustumMatrix, CallbackInfo callback) {
        Mat4f mcModelViewMatrix = NeoforgeClientProxy.currentModelViewMatrix;
        Mat4f mcProjectionMatrix = NeoforgeClientProxy.currentProjectionMatrix;
        float frameTime = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
        if (renderType.equals(RenderType.solid())) {
            ClientApi.INSTANCE.renderLods(ClientLevelWrapper.getWrapper(this.level), mcModelViewMatrix, mcProjectionMatrix, frameTime);
        } else if (renderType.equals(RenderType.translucent())) {
            ClientApi.INSTANCE.renderDeferredLods(ClientLevelWrapper.getWrapper(this.level), mcModelViewMatrix, mcProjectionMatrix, frameTime);
        }
        if (Config.Client.Advanced.Debugging.lodOnlyMode.get().booleanValue()) {
            callback.cancel();
        }
    }

    @Inject(at={@At(value="TAIL", target="Lnet/minecraft/world/level/lighting/LevelLightEngine;runLightUpdates()I")}, method={"renderLevel(Lnet/minecraft/client/DeltaTracker;ZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"})
    private void callAfterRunUpdates(CallbackInfo ci) {
        ChunkWrapper.syncedUpdateClientLightStatus();
    }
}

