/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.world.level.dimension.DimensionType;

public class DimensionTypeWrapper
implements IDimensionTypeWrapper {
    private static final ConcurrentMap<DimensionType, DimensionTypeWrapper> dimensionTypeWrapperMap = new ConcurrentHashMap<DimensionType, DimensionTypeWrapper>();
    private final DimensionType dimensionType;

    public DimensionTypeWrapper(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public static DimensionTypeWrapper getDimensionTypeWrapper(DimensionType dimensionType) {
        if (dimensionTypeWrapperMap.containsKey(dimensionType) && dimensionTypeWrapperMap.get(dimensionType) != null) {
            return (DimensionTypeWrapper)dimensionTypeWrapperMap.get(dimensionType);
        }
        DimensionTypeWrapper dimensionTypeWrapper = new DimensionTypeWrapper(dimensionType);
        dimensionTypeWrapperMap.put(dimensionType, dimensionTypeWrapper);
        return dimensionTypeWrapper;
    }

    public static void clearMap() {
        dimensionTypeWrapperMap.clear();
    }

    @Override
    public String getDimensionName() {
        return this.dimensionType.effectsLocation().getPath();
    }

    @Override
    public boolean hasCeiling() {
        return this.dimensionType.hasCeiling();
    }

    @Override
    public boolean hasSkyLight() {
        return this.dimensionType.hasSkyLight();
    }

    @Override
    public Object getWrappedMcObject() {
        return this.dimensionType;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() != DimensionTypeWrapper.class) {
            return false;
        }
        DimensionTypeWrapper other = (DimensionTypeWrapper)obj;
        return other.getDimensionName().equals(this.getDimensionName());
    }
}

