/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import com.logisticscraft.occlusionculling.util.Vec3d;
import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.versionless.EntityCullingVersionlessBase;
import dev.tr7zw.entityculling.versionless.access.Cullable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2818;
import net.minecraft.class_310;

public class CullTask
implements Runnable {
    public boolean requestCull = false;
    public boolean disableEntityCulling = false;
    public boolean disableBlockEntityCulling = false;
    private final OcclusionCullingInstance culling;
    private final class_310 client = class_310.method_1551();
    private final int sleepDelay;
    private final int hitboxLimit;
    private final Set<class_2591<?>> blockEntityWhitelist;
    private final Set<class_1299<?>> entityWhistelist;
    public long lastTime;
    private Vec3d lastPos;
    private Vec3d aabbMin;
    private Vec3d aabbMax;

    public CullTask(OcclusionCullingInstance culling, Set<class_2591<?>> blockEntityWhitelist, Set<class_1299<?>> entityWhistelist) {
        this.sleepDelay = EntityCullingModBase.instance.config.sleepDelay;
        this.hitboxLimit = EntityCullingModBase.instance.config.hitboxLimit;
        this.lastTime = 0L;
        this.lastPos = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMin = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMax = new Vec3d(0.0, 0.0, 0.0);
        this.culling = culling;
        this.blockEntityWhitelist = blockEntityWhitelist;
        this.entityWhistelist = entityWhistelist;
    }

    @Override
    public void run() {
        while (this.client.method_22108()) {
            try {
                class_243 cameraMC;
                Thread.sleep(this.sleepDelay);
                if (!EntityCullingVersionlessBase.enabled || this.client.field_1687 == null || this.client.field_1724 == null || this.client.field_1724.field_6012 <= 10) continue;
                class_243 class_2432 = cameraMC = EntityCullingModBase.instance.config.debugMode ? this.client.field_1724.method_5836(0.0f) : this.client.field_1773.method_19418().method_19326();
                if (!this.requestCull && cameraMC.field_1352 == this.lastPos.x && cameraMC.field_1351 == this.lastPos.y && cameraMC.field_1350 == this.lastPos.z) continue;
                long start = System.currentTimeMillis();
                this.requestCull = false;
                this.lastPos.set(cameraMC.field_1352, cameraMC.field_1351, cameraMC.field_1350);
                Vec3d camera = this.lastPos;
                this.culling.resetCache();
                this.cullBlockEntities(cameraMC, camera);
                this.cullEntities(cameraMC, camera);
                this.lastTime = System.currentTimeMillis() - start;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Shutting down culling task!");
    }

    private void cullEntities(class_243 cameraMC, Vec3d camera) {
        if (this.disableEntityCulling) {
            return;
        }
        class_1297 entity = null;
        Iterator iterable = this.client.field_1687.method_18112().iterator();
        while (iterable.hasNext()) {
            Cullable cullable;
            try {
                entity = (class_1297)iterable.next();
            }
            catch (ArrayIndexOutOfBoundsException | NullPointerException | ConcurrentModificationException ex) {
                break;
            }
            if (entity == null) break;
            if (!(entity instanceof Cullable) || this.entityWhistelist.contains(entity.method_5864()) || EntityCullingModBase.instance.isDynamicWhitelisted(entity) || (cullable = (Cullable)entity).isForcedVisible()) continue;
            if (class_310.method_1551().method_27022(entity) || this.isSkippableArmorstand(entity)) {
                cullable.setCulled(false);
                continue;
            }
            if (!entity.method_19538().method_24802((class_2374)cameraMC, (double)EntityCullingModBase.instance.config.tracingDistance)) {
                cullable.setCulled(false);
                continue;
            }
            class_238 boundingBox = entity.method_5830();
            if (boundingBox.method_17939() > (double)this.hitboxLimit || boundingBox.method_17940() > (double)this.hitboxLimit || boundingBox.method_17941() > (double)this.hitboxLimit) {
                cullable.setCulled(false);
                continue;
            }
            this.aabbMin.set(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1321);
            this.aabbMax.set(boundingBox.field_1320, boundingBox.field_1325, boundingBox.field_1324);
            boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
            cullable.setCulled(!visible);
        }
    }

    private void cullBlockEntities(class_243 cameraMC, Vec3d camera) {
        if (this.disableBlockEntityCulling) {
            return;
        }
        for (int x = -8; x <= 8; ++x) {
            block3: for (int z = -8; z <= 8; ++z) {
                class_2818 chunk = this.client.field_1687.method_8497(this.client.field_1724.method_31476().field_9181 + x, this.client.field_1724.method_31476().field_9180 + z);
                Iterator iterator = chunk.method_12214().entrySet().iterator();
                while (iterator.hasNext()) {
                    class_2338 pos;
                    Cullable cullable;
                    Map.Entry entry;
                    try {
                        entry = iterator.next();
                    }
                    catch (NullPointerException | ConcurrentModificationException ex) {
                        continue block3;
                    }
                    if (entry == null) continue block3;
                    if (this.blockEntityWhitelist.contains(((class_2586)entry.getValue()).method_11017()) || EntityCullingModBase.instance.isDynamicWhitelisted((class_2586)entry.getValue()) || (cullable = (Cullable)entry.getValue()).isForcedVisible() || !CullTask.closerThan(pos = (class_2338)entry.getKey(), (class_2374)cameraMC, 64.0)) continue;
                    class_238 boundingBox = EntityCullingModBase.instance.setupAABB((class_2586)entry.getValue(), pos);
                    if (boundingBox.method_17939() > (double)this.hitboxLimit || boundingBox.method_17940() > (double)this.hitboxLimit || boundingBox.method_17941() > (double)this.hitboxLimit) {
                        cullable.setCulled(false);
                        continue;
                    }
                    this.aabbMin.set(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1321);
                    this.aabbMax.set(boundingBox.field_1320, boundingBox.field_1325, boundingBox.field_1324);
                    boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
                    cullable.setCulled(!visible);
                }
            }
        }
    }

    private boolean isSkippableArmorstand(class_1297 entity) {
        if (!EntityCullingModBase.instance.config.skipMarkerArmorStands) {
            return false;
        }
        return entity instanceof class_1531 && ((class_1531)entity).method_6912();
    }

    private static boolean closerThan(class_2338 blockPos, class_2374 position, double d) {
        return CullTask.distSqr(blockPos, position.method_10216(), position.method_10214(), position.method_10215(), true) < d * d;
    }

    private static double distSqr(class_2338 blockPos, double d, double e, double f, boolean bl) {
        double g = bl ? 0.5 : 0.0;
        double h = (double)blockPos.method_10263() + g - d;
        double i = (double)blockPos.method_10264() + g - e;
        double j = (double)blockPos.method_10260() + g - f;
        return h * h + i * i + j * j;
    }
}

