/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.block.redstone_wire;

import net.caffeinemc.mods.lithium.common.util.DirectionConstants;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2457.class})
public class RedStoneWireBlockMixin
extends class_2248 {
    private static final int MIN = 0;
    private static final int MAX = 15;
    private static final int MAX_WIRE = 14;

    public RedStoneWireBlockMixin(class_4970.class_2251 settings) {
        super(settings);
    }

    @Inject(method={"calculateTargetStrength(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I"}, cancellable=true, at={@At(value="HEAD")})
    private void getReceivedPowerFaster(class_1937 world, class_2338 pos, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)this.getReceivedPower(world, pos));
    }

    private int getReceivedPower(class_1937 world, class_2338 pos) {
        class_2818 chunk = world.method_8500(pos);
        int power = 0;
        for (class_2350 dir : DirectionConstants.VERTICAL) {
            class_2338 side = pos.method_10093(dir);
            class_2680 neighbor = chunk.method_8320(side);
            if (neighbor.method_26215() || neighbor.method_27852((class_2248)this) || (power = Math.max(power, this.getPowerFromVertical(world, side, neighbor, dir))) < 15) continue;
            return 15;
        }
        class_2338 up = pos.method_10084();
        boolean checkWiresAbove = !chunk.method_8320(up).method_26212((class_1922)world, up);
        for (class_2350 dir : DirectionConstants.HORIZONTAL) {
            if ((power = Math.max(power, this.getPowerFromSide(world, pos.method_10093(dir), dir, checkWiresAbove))) < 15) continue;
            return 15;
        }
        return power;
    }

    private int getPowerFromVertical(class_1937 world, class_2338 pos, class_2680 state, class_2350 toDir) {
        int power = state.method_26195((class_1922)world, pos, toDir);
        if (power >= 15) {
            return 15;
        }
        if (state.method_26212((class_1922)world, pos)) {
            return Math.max(power, this.getStrongPowerTo(world, pos, toDir.method_10153()));
        }
        return power;
    }

    private int getPowerFromSide(class_1937 world, class_2338 pos, class_2350 toDir, boolean checkWiresAbove) {
        class_2338 down;
        class_2680 belowState;
        class_2818 chunk = world.method_8500(pos);
        class_2680 state = chunk.method_8320(pos);
        if (state.method_27852((class_2248)this)) {
            return (Integer)state.method_11654((class_2769)class_2741.field_12511) - 1;
        }
        int power = state.method_26195((class_1922)world, pos, toDir);
        if (power >= 15) {
            return 15;
        }
        if (state.method_26212((class_1922)world, pos)) {
            class_2338 up;
            class_2680 aboveState;
            if ((power = Math.max(power, this.getStrongPowerTo(world, pos, toDir.method_10153()))) >= 15) {
                return 15;
            }
            if (checkWiresAbove && power < 14 && (aboveState = chunk.method_8320(up = pos.method_10084())).method_27852((class_2248)this)) {
                power = Math.max(power, (Integer)aboveState.method_11654((class_2769)class_2741.field_12511) - 1);
            }
        } else if (power < 14 && (belowState = chunk.method_8320(down = pos.method_10074())).method_27852((class_2248)this)) {
            power = Math.max(power, (Integer)belowState.method_11654((class_2769)class_2741.field_12511) - 1);
        }
        return power;
    }

    private int getStrongPowerTo(class_1937 world, class_2338 pos, class_2350 ignore) {
        int power = 0;
        for (class_2350 dir : DirectionConstants.ALL) {
            class_2338 side;
            class_2680 neighbor;
            if (dir == ignore || (neighbor = world.method_8320(side = pos.method_10093(dir))).method_26215() || neighbor.method_27852((class_2248)this) || (power = Math.max(power, neighbor.method_26203((class_1922)world, side, dir))) < 15) continue;
            return 15;
        }
        return power;
    }
}

